/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrix.openlcb.configurexml.OlcbEventNameStoreXml;
import org.openlcb.EventID;
import org.openlcb.EventNameStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbEventNameStore
implements EventNameStore {
    private Map<String, EventID> nameToId = new HashMap<String, EventID>();
    private Map<EventID, String> idToName = new HashMap<EventID, String>();
    public boolean dirty = false;
    private Runnable shutDownTask = null;
    private static final Logger log = LoggerFactory.getLogger(OlcbEventNameStore.class);

    public OlcbEventNameStore() {
        this.readDetails();
        this.initShutdownTask();
    }

    public String getEventName(EventID eventID) {
        String name = this.idToName.get(eventID);
        if (name == null || name.isEmpty()) {
            return eventID.toShortString();
        }
        return name;
    }

    public boolean hasEventName(EventID eventID) {
        String name = this.idToName.get(eventID);
        return name != null && !name.isEmpty();
    }

    public EventID getEventID(String name) {
        EventID eid = this.nameToId.get(name);
        if (eid == null) {
            return new EventID(name);
        }
        return eid;
    }

    public boolean hasEventID(String name) {
        EventID eid = this.nameToId.get(name);
        return eid != null;
    }

    public void addMatch(EventID eventID, String name) {
        this.nameToId.put(name, eventID);
        this.idToName.put(eventID, name);
        log.trace("setting dirty true");
        this.dirty = true;
    }

    public Set<EventID> getMatches() {
        return this.idToName.keySet();
    }

    public void readDetails() {
        log.debug("reading Event Name Details");
        new OlcbEventNameStoreXml(this, "EventNames.xml").load();
        log.debug("...done reading Event Name details");
    }

    protected void initShutdownTask() {
        log.debug("Register ShutDown task");
        if (this.shutDownTask == null) {
            this.shutDownTask = () -> {
                log.debug("Start writing event name details...");
                try {
                    this.writeEventNameDetails();
                }
                catch (IOException ioe) {
                    log.error("Exception writing event name", (Throwable)ioe);
                }
            };
            InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        }
    }

    public void writeEventNameDetails() throws IOException {
        log.debug("storing event name map {}", (Object)this.dirty);
        if (this.dirty) {
            new OlcbEventNameStoreXml(this, "EventNames.xml").store();
            this.dirty = false;
            log.debug("...done writing event name details");
        }
    }
}

