/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Meter;
import jmri.MeterManager;
import jmri.implementation.AbstractAnalogIO;
import jmri.implementation.DefaultMeter;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.managers.AbstractMeterManager;
import org.openlcb.Connection;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.implementations.LocationServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbMeterManager
extends AbstractMeterManager {
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;
    private final MimicNodeStore store;
    private static final Logger log = LoggerFactory.getLogger(OlcbMeterManager.class);

    public OlcbMeterManager(@Nonnull CanSystemConnectionMemo memo) {
        super(memo);
        this.memo = memo;
        this.iface = memo.get(OlcbInterface.class);
        this.iface.registerMessageListener((Connection)new EWPListener());
        this.store = memo.get(MimicNodeStore.class);
    }

    public static Meter createVoltageMeter(String sysName) {
        DefaultMeter.DefaultVoltageMeter meter = new DefaultMeter.DefaultVoltageMeter(sysName, Meter.Unit.NoPrefix, 0.0, 50.0, 0.001, null);
        InstanceManager.getDefault(MeterManager.class).register(meter);
        return meter;
    }

    public static Meter createCurrentMeter(String sysName) {
        DefaultMeter.DefaultCurrentMeter meter = new DefaultMeter.DefaultCurrentMeter(sysName, Meter.Unit.NoPrefix, 0.0, 50.0, 0.001, null);
        InstanceManager.getDefault(MeterManager.class).register(meter);
        return meter;
    }

    class EWPListener
    extends MessageDecoder {
        EWPListener() {
        }

        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            LocationServiceUtils.Content content = LocationServiceUtils.parse((Message)msg);
            if (content == null) {
                return;
            }
            int ordinal = 1;
            NodeID scannedNode = content.getScannedDevice();
            String scannedName = "";
            if (OlcbMeterManager.this.store != null) {
                scannedName = OlcbMeterManager.this.store.findNode(scannedNode).getSimpleNodeIdent().getUserName();
            }
            log.debug("Retrieved scannedNode {} scannedName {}", (Object)scannedNode, (Object)scannedName);
            if (scannedName == null || scannedName.isEmpty()) {
                scannedName = scannedNode.toString();
            }
            for (LocationServiceUtils.Block block : content.getBlocks()) {
                log.debug("  Block of type {}", (Object)block.getType());
                if (!(block instanceof LocationServiceUtils.AnalogBlock)) continue;
                LocationServiceUtils.AnalogBlock analog = (LocationServiceUtils.AnalogBlock)block;
                String text = analog.getText();
                LocationServiceUtils.AnalogBlock.Unit unit = analog.getUnit();
                String systemLetter = OlcbMeterManager.this.memo.getSystemPrefix();
                String sysName = systemLetter + OlcbMeterManager.this.typeLetter() + " " + scannedNode.toString() + " " + ordinal + " " + text;
                String userName = scannedName + " " + ordinal + " " + text;
                log.debug("  Unit: {}, Text: '{}'  systemName: '{}'", new Object[]{unit, text, sysName});
                Meter meter = (Meter)OlcbMeterManager.this.getBySystemName(sysName);
                if (meter == null) {
                    log.debug("Creating new meter '{}' of type '{}'", (Object)text, (Object)unit);
                    if (unit == LocationServiceUtils.AnalogBlock.Unit.VOLTS) {
                        meter = OlcbMeterManager.createVoltageMeter(sysName);
                    } else if (unit == LocationServiceUtils.AnalogBlock.Unit.AMPERES) {
                        meter = OlcbMeterManager.createCurrentMeter(sysName);
                    } else {
                        log.warn("Meters of type {} are not supported yet", (Object)unit);
                        continue;
                    }
                    InstanceManager.getDefault(MeterManager.class).register(meter);
                }
                meter.setUserName(userName);
                ((AbstractAnalogIO)((Object)meter)).setValue(analog.getValue());
                ++ordinal;
            }
        }
    }
}

