/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.SwingPropertyChangeSupport;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.ShutDownManager;
import jmri.jmrix.openlcb.configurexml.OlcbNodeGroupStoreXml;
import org.openlcb.NodeID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbNodeGroupStore
implements InstanceManagerAutoDefault {
    private HashMap<String, HashSet<NodeID>> mapOfGroups = new HashMap();
    private HashMap<NodeID, TreeSet<String>> mapOfNodes = new HashMap();
    private boolean dirty = false;
    private Runnable shutDownTask = null;
    private final SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);
    private static final Logger log = LoggerFactory.getLogger(OlcbNodeGroupStore.class);

    public OlcbNodeGroupStore() {
        log.debug("Initialising");
        this.load();
        this.initShutdownTask();
        this.dirty = false;
    }

    protected void load() {
        new OlcbNodeGroupStoreXml(this, "NodeGroupAssociations.xml").load();
    }

    protected void store() throws IOException {
        log.debug("Store invoked");
        if (this.dirty) {
            new OlcbNodeGroupStoreXml(this, "NodeGroupAssociations.xml").store();
            this.dirty = false;
        }
    }

    protected void initShutdownTask() {
        log.debug("Register ShutDown task");
        if (this.shutDownTask == null) {
            this.shutDownTask = () -> {
                try {
                    this.store();
                }
                catch (IOException ioe) {
                    log.error("Exception writing node group associations", (Throwable)ioe);
                }
            };
            InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        }
    }

    public void addNodeToGroup(NodeID node, String group) {
        if (!this.mapOfGroups.containsKey(group)) {
            this.mapOfGroups.put(group, new HashSet());
        }
        if (!this.mapOfNodes.containsKey(node)) {
            this.mapOfNodes.put(node, new TreeSet());
        }
        this.mapOfGroups.get(group).add(node);
        this.mapOfNodes.get(node).add(group);
        this.fireChangeEvent();
    }

    public void removeNodeFromGroup(NodeID node, String group) {
        TreeSet<String> listGroups;
        HashSet<NodeID> listNodes = this.mapOfGroups.get(group);
        if (listNodes != null) {
            listNodes.remove(node);
        }
        if ((listGroups = this.mapOfNodes.get(node)) != null) {
            listGroups.remove(group);
        }
        if ((listNodes = this.mapOfGroups.get(group)) != null && listNodes.size() == 0) {
            this.removeGroup(group);
        }
        this.fireChangeEvent();
    }

    public void removeGroup(String group) {
        this.mapOfGroups.remove(group);
        for (Collection collection : this.mapOfGroups.values()) {
            for (NodeID node : collection) {
                this.mapOfNodes.get(node).remove(group);
            }
        }
        this.fireChangeEvent();
    }

    public List<String> getGroupNames() {
        ArrayList<String> retval = new ArrayList<String>(this.mapOfGroups.keySet());
        retval.sort(Collator.getInstance());
        return retval;
    }

    public Set<NodeID> getGroupNodes(String group) {
        return this.mapOfGroups.get(group);
    }

    public List<String> getNodesGroups(NodeID node) {
        ArrayList<String> retval = new ArrayList<String>((Collection)this.mapOfNodes.get(node));
        retval.sort(Collator.getInstance());
        return retval;
    }

    public boolean isNodeInGroup(NodeID node, String group) {
        TreeSet<String> list = this.mapOfNodes.get(node);
        if (list == null) {
            return false;
        }
        return list.contains(group);
    }

    protected void fireChangeEvent() {
        this.pcs.firePropertyChange("Associations", false, true);
        this.dirty = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

