/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import jmri.JmriException;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.managers.AbstractPowerManager;
import org.openlcb.EventID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.EventTable;
import org.openlcb.implementations.VersionedValueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbPowerManager
extends AbstractPowerManager<CanSystemConnectionMemo> {
    OlcbAddress addrOn = new OlcbAddress(new EventID("01.00.00.00.00.00.FF.FE"));
    OlcbAddress addrOff = new OlcbAddress(new EventID("01.00.00.00.00.00.FF.FF"));
    private final OlcbInterface iface;
    VersionedValueListener<Boolean> powerListener;
    BitProducerConsumer pc;
    EventTable.EventTableEntryHolder onEventTableEntryHolder = null;
    EventTable.EventTableEntryHolder offEventTableEntryHolder = null;
    private static final int PC_DEFAULT_FLAGS = 30;
    private static final Logger log = LoggerFactory.getLogger(OlcbPowerManager.class);

    public OlcbPowerManager(CanSystemConnectionMemo memo) {
        super(memo);
        this.iface = memo.get(OlcbInterface.class);
        int flags = 30;
        log.debug("Power Manager Flags: default {} overridden {} listen bit {}", new Object[]{30, flags, 16});
        this.pc = new BitProducerConsumer(this.iface, this.addrOn.toEventID(), this.addrOff.toEventID(), flags);
        this.powerListener = new VersionedValueListener<Boolean>(this.pc.getValue()){

            public void update(Boolean value) {
                try {
                    OlcbPowerManager.super.setPower(value != false ? 2 : 4);
                }
                catch (JmriException e) {
                    log.error("Unexpected exception", (Throwable)e);
                }
            }
        };
        this.onEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrOn.toEventID(), "PowerManager:on");
        this.offEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrOff.toEventID(), "PowerManager:off");
    }

    @Override
    public void setPower(int s) {
        if (s == 2) {
            this.powerListener.setFromOwnerWithForceNotify((Object)true);
        } else if (s == 4) {
            this.powerListener.setFromOwnerWithForceNotify((Object)false);
        }
        try {
            super.setPower(s);
        }
        catch (JmriException e) {
            log.error("Unexpected exception", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.powerListener != null) {
            this.powerListener.release();
            this.powerListener = null;
        }
        if (this.pc != null) {
            this.pc.release();
            this.pc = null;
        }
        if (this.onEventTableEntryHolder != null) {
            this.onEventTableEntryHolder.release();
            this.onEventTableEntryHolder = null;
        }
        if (this.offEventTableEntryHolder != null) {
            this.offEventTableEntryHolder.release();
            this.offEventTableEntryHolder = null;
        }
    }
}

