/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.openlcb.OlcbThrottle;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.VerifyNodeIDNumberGlobalMessage;
import org.openlcb.implementations.MemoryConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbProgrammer
extends AbstractProgrammer
implements AddressedProgrammer {
    public static final int SPACE_DCC_CV = 248;
    public static final EventID IS_PROGRAMMINGTRACK_EVENT = new EventID("09.00.99.FE.FF.FF.00.02");
    public static final int ERROR_NO_LOCO = 8241;
    public static final int ERROR_FAILED_VERIFY = 8242;
    public static final int ERROR_NO_RAILCOM = 8243;
    public static final int ERROR_INVALID_RESPONSE = 8244;
    public static final int ERROR_PGM_SHORT = 8245;
    public static final int ERROR_UNIMPLEMENTED_CMD = 4162;
    public static final int ERROR_INVALID_ARGUMENTS = 4224;
    public static final int ERROR_PGM_DISABLED = 4129;
    private final OlcbInterface iface;
    @CheckForNull
    NodeID nid;
    private int dccAddress;
    private boolean dccIsLong;
    private ProgTrackListener listener;
    private static final Logger log = LoggerFactory.getLogger(OlcbProgrammer.class);

    public OlcbProgrammer(OlcbInterface system, final @CheckForNull NodeID nid) {
        this.iface = system;
        this.nid = nid;
        if (nid != null) {
            system.getOutputConnection().registerStartNotification(new Connection.ConnectionListener(){

                public void connectionActive(Connection connection) {
                    OlcbProgrammer.this.getInterface().getOutputConnection().put((Message)new VerifyNodeIDNumberGlobalMessage(OlcbProgrammer.this.getInterface().getNodeId(), nid), null);
                }
            });
        } else {
            this.startProgTrackLookup();
        }
    }

    public OlcbProgrammer(OlcbInterface system, boolean isLong, int address) {
        this(system, OlcbThrottle.guessDCCNodeID(isLong, address));
        this.dccIsLong = isLong;
        this.dccAddress = address;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> retval = new ArrayList<ProgrammingMode>();
        retval.add(ProgrammingMode.DIRECTBYTEMODE);
        retval.add(ProgrammingMode.OPSBYTEMODE);
        return retval;
    }

    @Override
    protected void timeout() {
    }

    @Override
    public void writeCV(String CV, final int val, final ProgListener p) throws ProgrammerException {
        this.checkProgramTrack();
        this.getInterface().getMemoryConfigurationService().requestWrite(this.nid, 248, this.getCvAddress(CV), new byte[]{(byte)val}, new MemoryConfigurationService.McsWriteHandler(){

            public void handleSuccess() {
                OlcbProgrammer.this.notifyProgListenerEnd(p, val, 0);
            }

            public void handleFailure(int i) {
                if (i == 8243 && (OlcbProgrammer.this.dccAddress > 0 || OlcbProgrammer.this.dccIsLong)) {
                    OlcbProgrammer.this.notifyProgListenerEnd(p, val, 0);
                    return;
                }
                OlcbProgrammer.this.notifyProgListenerEnd(p, 0, OlcbProgrammer.olcbErrorToProgStatus(i));
            }
        });
    }

    @Override
    public void readCV(final String CV, final ProgListener p) throws ProgrammerException {
        this.checkProgramTrack();
        this.getInterface().getMemoryConfigurationService().requestRead(this.nid, 248, this.getCvAddress(CV), 1, new MemoryConfigurationService.McsReadHandler(){

            public void handleReadData(NodeID nodeID, int i, long l, byte[] bytes) {
                if (bytes.length < 1) {
                    this.handleFailure(4096);
                    return;
                }
                if (p != null) {
                    OlcbProgrammer.this.notifyProgListenerEnd(p, bytes[0] & 0xFF, 0);
                }
            }

            public void handleFailure(int i) {
                log.debug("CV {} read - memory config error 0x{}", (Object)CV, (Object)Integer.toHexString(i));
                OlcbProgrammer.this.notifyProgListenerEnd(p, 0, OlcbProgrammer.olcbErrorToProgStatus(i));
            }
        });
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.checkProgramTrack();
    }

    @Override
    public boolean getLongAddress() {
        return this.dccIsLong;
    }

    @Override
    public int getAddressNumber() {
        return this.dccAddress;
    }

    @Override
    public String getAddress() {
        if (this.dccAddress > 0 || this.dccIsLong) {
            return Integer.toString(this.dccAddress) + (this.dccIsLong ? "L" : "S");
        }
        if (this.nid != null) {
            return this.nid.toString();
        }
        return "null";
    }

    private OlcbInterface getInterface() {
        return this.iface;
    }

    private long getCvAddress(String cvName) {
        int cvNum = Integer.parseInt(cvName);
        return cvNum - 1;
    }

    private void startProgTrackLookup() {
        if (this.listener == null) {
            this.listener = new ProgTrackListener();
        }
        if (!this.listener.isRegistered) {
            this.iface.registerMessageListener((Connection)this.listener);
            this.listener.isRegistered = true;
        }
        this.iface.getOutputConnection().registerStartNotification(new Connection.ConnectionListener(){

            public void connectionActive(Connection connection) {
                OlcbProgrammer.this.iface.getOutputConnection().put((Message)new IdentifyProducersMessage(OlcbProgrammer.this.iface.getNodeId(), IS_PROGRAMMINGTRACK_EVENT), null);
            }
        });
    }

    private boolean foundProgrammingTrack(@Nonnull NodeID nodeID) {
        if (this.nid == null) {
            this.nid = nodeID;
            log.info("Found programming track {}.", (Object)nodeID);
        }
        return true;
    }

    private void checkProgramTrack() throws ProgrammerException {
        if (this.nid == null) {
            throw new ProgrammerException("No programming track found.");
        }
    }

    private static int olcbErrorToProgStatus(int olcbError) {
        switch (olcbError) {
            case 8241: {
                return 2;
            }
            case 8242: {
                return 64;
            }
            case 8243: {
                return 32;
            }
            case 8244: {
                return 1024;
            }
            case 8245: {
                return 256;
            }
            case 4162: {
                return 8;
            }
            case 4224: {
                return 512;
            }
            case 4129: {
                return 4;
            }
        }
        if ((olcbError & 0x2000) != 0) {
            return 512;
        }
        if ((olcbError & 0x1000) != 0) {
            return 8;
        }
        if (olcbError != 0) {
            return 1;
        }
        return 0;
    }

    class ProgTrackListener
    extends MessageDecoder {
        boolean isRegistered = false;

        ProgTrackListener() {
        }

        public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
            if (!msg.getEventID().equals((Object)IS_PROGRAMMINGTRACK_EVENT)) {
                return;
            }
            if (msg.getSourceNodeID() == null) {
                log.error("Found programming track with null source node.");
                return;
            }
            if (msg.getSourceNodeID().getContents()[0] == 0) {
                log.error("Found programming track with invalid source node: {}", (Object)msg.getSourceNodeID());
                return;
            }
            if (OlcbProgrammer.this.foundProgrammingTrack(msg.getSourceNodeID())) {
                OlcbProgrammer.this.iface.unRegisterMessageListener((Connection)this);
                this.isRegistered = false;
            }
        }
    }
}

