/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.AbstractIdTagReporter;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import org.openlcb.Connection;
import org.openlcb.ConsumerRangeIdentifiedMessage;
import org.openlcb.EventID;
import org.openlcb.EventState;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.implementations.EventTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbReporter
extends AbstractIdTagReporter {
    private static final int REPORTER_BIT_COUNT = 16;
    private static final long REPORTER_LSB = 65536L;
    private static final long REPORTER_EVENT_MASK = 65535L;
    private static final long EXIT_BIT = 16384L;
    private static final long ORIENTATION_BIT = 32768L;
    private static final long ADDRESS_MASK = 16383L;
    private static final int HIBITS_SHORTADDRESS = 40;
    private static final int HIBITS_CONSIST = 41;
    private OlcbAddress baseAddress;
    private EventID baseEventID;
    private long baseEventNumber;
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;
    private final Connection messageListener = new Receiver();
    EventTable.EventTableEntryHolder baseEventTableEntryHolder = null;
    int lastLoco = -1;
    private static final Logger log = LoggerFactory.getLogger(OlcbReporter.class);

    public OlcbReporter(String prefix, String address, CanSystemConnectionMemo memo) {
        super(prefix + "R" + address);
        this.memo = memo;
        this.iface = memo != null ? memo.get(OlcbInterface.class) : null;
        this.init(address);
    }

    private void init(String address) {
        this.iface.registerMessageListener(this.messageListener);
        OlcbAddress a = new OlcbAddress(address, this.memo);
        OlcbAddress[] v = a.split(this.memo);
        if (v == null) {
            log.error("Did not find usable system name: {}", (Object)address);
            return;
        }
        switch (v.length) {
            case 1: {
                this.baseAddress = v[0];
                this.baseEventID = this.baseAddress.toEventID();
                this.baseEventNumber = this.baseEventID.toLong();
                break;
            }
            default: {
                log.error("Can't parse OpenLCB Reporter system name: {}", (Object)address);
            }
        }
    }

    void finishLoad() {
        if (this.baseEventTableEntryHolder != null) {
            this.baseEventTableEntryHolder.release();
            this.baseEventTableEntryHolder = null;
        }
        this.baseEventTableEntryHolder = this.iface.getEventTable().addEvent(this.baseEventID, this.getEventName());
        ConsumerRangeIdentifiedMessage m = new ConsumerRangeIdentifiedMessage(this.iface.getNodeId(), this.getEventRangeID());
        this.iface.getOutputConnection().put((Message)m, this.messageListener);
    }

    private EventID getEventRangeID() {
        long eventRange = this.baseEventNumber;
        if ((this.baseEventNumber & 0x10000L) == 0L) {
            eventRange |= 0xFFFFL;
        }
        byte[] contents = new byte[8];
        for (int i = 1; i <= 8; ++i) {
            contents[8 - i] = (byte)(eventRange & 0xFFL);
            eventRange >>= 8;
        }
        return new EventID(contents);
    }

    private String getEventName() {
        String name = this.getUserName();
        if (name == null) {
            name = this.mSystemName;
        }
        return Bundle.getMessage("ReporterEventName", name);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        super.setUserName(s);
        if (this.baseEventTableEntryHolder != null) {
            this.baseEventTableEntryHolder.getEntry().updateDescription(this.getEventName());
        }
    }

    @Override
    public void dispose() {
        if (this.baseEventTableEntryHolder != null) {
            this.baseEventTableEntryHolder.release();
            this.baseEventTableEntryHolder = null;
        }
        this.iface.unRegisterMessageListener(this.messageListener);
        super.dispose();
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return OlcbAddress.compareSystemNameSuffix(suffix1, suffix2, this.memo);
    }

    @Override
    public int getState() {
        return this.lastLoco;
    }

    @Override
    public void setState(int s) {
        this.lastLoco = s;
    }

    private void handleReport(long reportBits, boolean isEntry) {
        this.notify(null);
        if (!isEntry || (reportBits & 0x4000L) != 0L) {
            return;
        }
        long addressBits = reportBits & 0x3FFFL;
        int address = 0;
        int hiBits = (int)(addressBits >> 8 & 0x3FL);
        int direction = (int)(reportBits & 0x8000L);
        if (addressBits < 10240L) {
            address = (int)addressBits;
        } else if (hiBits == 40) {
            address = (int)(addressBits & 0xFFL);
        } else if (hiBits == 41) {
            address = (int)(addressBits & 0x7FL);
        }
        RailCom tag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + address);
        if (direction != 0) {
            tag.setOrientation(32);
        } else {
            tag.setOrientation(16);
        }
        this.notify(tag);
    }

    private class Receiver
    extends MessageDecoder {
        private Receiver() {
        }

        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            long id = msg.getEventID().toLong();
            if ((id & 0xFFFFFFFFFFFF0000L) != OlcbReporter.this.baseEventNumber) {
                return;
            }
            OlcbReporter.this.handleReport(id & 0xFFFFL, true);
        }

        public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
            long id = msg.getEventID().toLong();
            if ((id & 0xFFFFFFFFFFFF0000L) != OlcbReporter.this.baseEventNumber) {
                return;
            }
            if (msg.getEventState() == EventState.Invalid) {
                OlcbReporter.this.handleReport(id & 0xFFFFL, false);
            } else if (msg.getEventState() == EventState.Valid) {
                OlcbReporter.this.handleReport(id & 0xFFFFL, true);
            }
        }
    }
}

