/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.BooleanPropertyDescriptor;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.Reporter;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbReporter;
import jmri.jmrix.openlcb.OlcbUtils;
import jmri.managers.AbstractReporterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbReporterManager
extends AbstractReporterManager {
    private boolean isLoading = false;
    private final ArrayList<OlcbReporter> pendingReporters = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(OlcbReporterManager.class);

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        ArrayList l = new ArrayList();
        l.add(new BooleanPropertyDescriptor("IsAuthoritative", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateAuthHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        l.add(new BooleanPropertyDescriptor("ListenStateMessages", true){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("OlcbStateListenHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return OlcbUtils.isOlcbBean(bean);
            }
        });
        return l;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public OlcbReporterManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="passing exception text")
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String addr = systemName.substring(this.getSystemNamePrefix().length());
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (NamedBean.BadSystemNameException e) {
            log.error(e.getMessage());
            throw e;
        }
        OlcbReporter s = new OlcbReporter(this.getSystemPrefix(), addr, (CanSystemConnectionMemo)this.memo);
        s.setUserName(userName);
        ArrayList<OlcbReporter> arrayList = this.pendingReporters;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingReporters.add(s);
            } else {
                s.finishLoad();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        log.debug("Reporter manager : start load");
        ArrayList<OlcbReporter> arrayList = this.pendingReporters;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        log.debug("Reporter manager : finish load");
        ArrayList<OlcbReporter> arrayList = this.pendingReporters;
        synchronized (arrayList) {
            this.pendingReporters.forEach(OlcbReporter::finishLoad);
            this.pendingReporters.clear();
            this.isLoading = false;
        }
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpPrefix = prefix + this.typeLetter();
        String tmpSName = tmpPrefix + curAddress;
        try {
            OlcbAddress.validateSystemNameFormat(tmpSName, Locale.getDefault(), tmpPrefix, (CanSystemConnectionMemo)this.memo);
        }
        catch (NamedBean.BadSystemNameException ex) {
            throw new JmriException(ex.getMessage());
        }
        return prefix + this.typeLetter() + curAddress;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getNextValidSystemName(@Nonnull NamedBean currentBean) throws JmriException {
        String currentName = currentBean.getSystemName();
        return this.incrementSystemName(currentName);
    }

    public String incrementSystemName(String currentName) {
        String oAddr = currentName.substring(this.getSystemNamePrefix().length());
        OlcbAddress a = new OlcbAddress(oAddr, (CanSystemConnectionMemo)this.memo);
        int[] e = a.elements();
        for (int idx = 5; idx > 2; --idx) {
            int n = idx;
            e[n] = e[n] + 1;
            if (e[idx] <= 255) break;
            e[idx] = 0;
        }
        String newValue = a.toDottedString();
        return this.getSystemNamePrefix() + newValue;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddReporterEntryToolTip");
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        name = super.validateSystemNameFormat(name, locale);
        name = OlcbAddress.validateSystemNameFormat(name, locale, this.getSystemNamePrefix(), (CanSystemConnectionMemo)this.memo);
        return name;
    }
}

