/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.TimerTask;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.NamedBean;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbUtils;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import org.openlcb.EventID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.EventTable;
import org.openlcb.implementations.VersionedValueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbSensor
extends AbstractSensor {
    static final int ON_TIME = 500;
    OlcbAddress addrActive;
    OlcbAddress addrInactive;
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;
    VersionedValueListener<Boolean> sensorListener;
    BitProducerConsumer pc;
    EventTable.EventTableEntryHolder activeEventTableEntryHolder = null;
    EventTable.EventTableEntryHolder inactiveEventTableEntryHolder = null;
    private static final boolean DEFAULT_IS_AUTHORITATIVE = true;
    private static final boolean DEFAULT_LISTEN = true;
    private static final int PC_DEFAULT_FLAGS = 30;
    private TimerTask timerTask;
    private static final Logger log = LoggerFactory.getLogger(OlcbSensor.class);

    public OlcbSensor(String prefix, String address, CanSystemConnectionMemo memo) {
        super(prefix + "S" + address);
        this.memo = memo;
        this.iface = memo != null ? memo.get(OlcbInterface.class) : null;
        this.init(address);
    }

    private void init(String address) {
        OlcbAddress a = new OlcbAddress(address, this.memo);
        OlcbAddress[] v = a.split(this.memo);
        if (v == null) {
            log.error("Did not find usable system name: {}", (Object)address);
            return;
        }
        switch (v.length) {
            case 1: {
                this.addrActive = v[0];
                this.addrInactive = null;
                break;
            }
            case 2: {
                this.addrActive = v[0];
                this.addrInactive = v[1];
                break;
            }
            default: {
                log.error("Can't parse OpenLCB Sensor system name: {}", (Object)address);
            }
        }
    }

    void finishLoad() {
        int flags = 30;
        flags = OlcbUtils.overridePCFlagsFromProperties(this, flags);
        log.debug("Sensor Flags: default {} overridden {} listen bit {}", new Object[]{30, flags, 16});
        this.disposePc();
        if (this.addrInactive == null) {
            this.pc = new BitProducerConsumer(this.iface, this.addrActive.toEventID(), BitProducerConsumer.nullEvent, flags);
            this.sensorListener = new VersionedValueListener<Boolean>(this.pc.getValue()){

                public void update(Boolean value) {
                    OlcbSensor.this.setOwnState(value != false ? 2 : 4);
                    if (value.booleanValue()) {
                        OlcbSensor.this.setTimeout();
                    }
                }
            };
        } else {
            this.pc = new BitProducerConsumer(this.iface, this.addrActive.toEventID(), this.addrInactive.toEventID(), flags);
            this.sensorListener = new VersionedValueListener<Boolean>(this.pc.getValue()){

                public void update(Boolean value) {
                    OlcbSensor.this.setOwnState(value != false ? 2 : 4);
                }
            };
        }
        this.activeEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrActive.toEventID(), this.getEventName(true));
        if (this.addrInactive != null) {
            this.inactiveEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrInactive.toEventID(), this.getEventName(false));
        }
    }

    public String getEventName(boolean isActive) {
        String name = this.getUserName();
        if (name == null) {
            name = this.mSystemName;
        }
        String msgName = isActive ? "SensorActiveEventName" : "SensorInactiveEventName";
        return Bundle.getMessage(msgName, name);
    }

    public EventID getEventID(boolean isActive) {
        if (isActive) {
            return this.addrActive.toEventID();
        }
        if (this.addrInactive != null) {
            return this.addrInactive.toEventID();
        }
        return null;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getRecommendedToolTip() {
        if (this.addrInactive == null) {
            return this.addrActive.toDottedString();
        }
        return this.addrActive.toDottedString() + ";" + this.addrInactive.toDottedString();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        super.setUserName(s);
        if (this.activeEventTableEntryHolder != null) {
            this.activeEventTableEntryHolder.getEntry().updateDescription(this.getEventName(true));
        }
        if (this.inactiveEventTableEntryHolder != null) {
            this.inactiveEventTableEntryHolder.getEntry().updateDescription(this.getEventName(false));
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.pc != null) {
            this.pc.resetToDefault();
            this.pc.sendQuery();
        }
    }

    @Override
    public void setKnownState(int s) {
        if (s == 2) {
            this.sensorListener.setFromOwnerWithForceNotify((Object)true);
            if (this.addrInactive == null) {
                this.setTimeout();
            }
        } else if (s == 4) {
            this.sensorListener.setFromOwnerWithForceNotify((Object)false);
        } else if (s == 1 && this.pc != null) {
            this.pc.resetToDefault();
        }
        this.setOwnState(s);
    }

    void setTimeout() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                OlcbSensor.this.timerTask = null;
                ThreadingUtil.runOnGUI(() -> OlcbSensor.this.setKnownState(4));
            }
        };
        TimerUtil.schedule(this.timerTask, 500L);
    }

    public void setAuthoritative(boolean authoritative) {
        boolean recreate = authoritative != this.isAuthoritative() && this.pc != null;
        this.setProperty("IsAuthoritative", authoritative);
        if (recreate) {
            this.finishLoad();
        }
    }

    public boolean isAuthoritative() {
        Boolean value = (Boolean)this.getProperty("IsAuthoritative");
        if (value != null) {
            return value;
        }
        return true;
    }

    @Override
    public void setProperty(@Nonnull String key, Object value) {
        Object old = this.getProperty(key);
        super.setProperty(key, value);
        if (value.equals(old)) {
            return;
        }
        if (this.pc == null) {
            return;
        }
        this.finishLoad();
    }

    public boolean isListeningToStateMessages() {
        Boolean value = (Boolean)this.getProperty("ListenStateMessages");
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setListeningToStateMessages(boolean listen) {
        boolean recreate = listen != this.isListeningToStateMessages() && this.pc != null;
        this.setProperty("ListenStateMessages", listen);
        if (recreate) {
            this.finishLoad();
        }
    }

    @Override
    public boolean canInvert() {
        return false;
    }

    @Override
    public void dispose() {
        this.disposePc();
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        super.dispose();
    }

    private void disposePc() {
        if (this.sensorListener != null) {
            this.sensorListener.release();
            this.sensorListener = null;
        }
        if (this.pc != null) {
            this.pc.release();
            this.pc = null;
        }
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return OlcbAddress.compareSystemNameSuffix(suffix1, suffix2, this.memo);
    }
}

