/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.nio.charset.StandardCharsets;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.implementation.AbstractStringIO;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbUtils;
import jmri.util.ThreadingUtil;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.EventTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbStringIO
extends AbstractStringIO {
    OlcbAddress addrActive;
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;
    BitProducerConsumer pc;
    EventTable.EventTableEntryHolder activeEventTableEntryHolder = null;
    private static final int PC_DEFAULT_FLAGS = 30;
    private static final Logger log = LoggerFactory.getLogger(OlcbStringIO.class);

    public OlcbStringIO(String prefix, String address, CanSystemConnectionMemo memo) {
        super(prefix + "C" + address);
        log.trace("ctor with {} and {}", (Object)prefix, (Object)address);
        this.memo = memo;
        this.iface = memo != null ? memo.get(OlcbInterface.class) : null;
        this.init(address);
    }

    private void init(String address) {
        OlcbAddress a = new OlcbAddress(address, this.memo);
        OlcbAddress[] v = a.split(this.memo);
        if (v == null) {
            log.error("Did not find usable system name: {}", (Object)address);
            return;
        }
        switch (v.length) {
            case 1: {
                this.addrActive = v[0];
                break;
            }
            default: {
                log.error("Can't parse OpenLCB StringIO system name: {}", (Object)address);
            }
        }
        this.iface.registerMessageListener((Connection)new EWPListener());
    }

    void finishLoad() {
        log.trace("finishLoad runs");
        int flags = 30;
        flags = OlcbUtils.overridePCFlagsFromProperties(this, flags);
        log.debug("StringIO Flags: default {} overridden {} listen bit {}", new Object[]{30, flags, 16});
        this.disposePc();
        this.pc = new BitProducerConsumer(this.iface, this.addrActive.toEventID(), BitProducerConsumer.nullEvent, flags);
        this.activeEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrActive.toEventID(), this.getEventName(true));
    }

    private void disposePc() {
        if (this.pc != null) {
            this.pc.release();
            this.pc = null;
        }
    }

    public String getEventName(boolean isActive) {
        String name = this.getUserName();
        if (name == null) {
            name = this.mSystemName;
        }
        String msgName = "StringIOEventName";
        return Bundle.getMessage(msgName, name);
    }

    public EventID getEventID(boolean isActive) {
        return this.addrActive.toEventID();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getRecommendedToolTip() {
        return this.addrActive.toDottedString();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        super.setUserName(s);
        if (this.activeEventTableEntryHolder != null) {
            this.activeEventTableEntryHolder.getEntry().updateDescription(this.getEventName(true));
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.pc != null) {
            this.pc.resetToDefault();
            this.pc.sendQuery();
        }
    }

    @Override
    protected void sendStringToLayout(String value) throws JmriException {
        this.iface.getOutputConnection().put((Message)new ProducerConsumerEventReportMessage(this.iface.getNodeId(), this.getEventID(true), value.getBytes(StandardCharsets.UTF_8)), null);
    }

    @Override
    public int getMaximumLength() {
        return 242;
    }

    @Override
    protected boolean cutLongStrings() {
        return true;
    }

    class EWPListener
    extends MessageDecoder {
        EWPListener() {
        }

        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            if (!msg.getEventID().equals((Object)OlcbStringIO.this.getEventID(true))) {
                return;
            }
            ThreadingUtil.runOnGUI(() -> {
                try {
                    OlcbStringIO.this.setString(new String(msg.getPayloadArray(), StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    log.warn("EWP processing got exception", (Throwable)e);
                }
            });
        }
    }
}

