/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.StringIO;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbStringIO;
import jmri.managers.AbstractStringIOManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbStringIOManager
extends AbstractStringIOManager {
    private boolean isLoading = false;
    private final ArrayList<OlcbStringIO> pendingStringIOs = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(OlcbStringIOManager.class);

    public OlcbStringIOManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public StringIO provideStringIO(@Nonnull String sName) throws IllegalArgumentException {
        String name = sName.substring(this.getSystemPrefix().length() + 1);
        return new OlcbStringIO(this.getSystemPrefix(), name, (CanSystemConnectionMemo)this.memo);
    }

    @Override
    @Nonnull
    public StringIO provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideStringIO(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public StringIO createNewStringIO(String sName, String uName) {
        String name = sName.substring(this.getSystemPrefix().length() + 1);
        OlcbStringIO s = new OlcbStringIO(this.getSystemPrefix(), name, (CanSystemConnectionMemo)this.memo);
        if (uName != null) {
            s.setUserName(uName);
        }
        ArrayList<OlcbStringIO> arrayList = this.pendingStringIOs;
        synchronized (arrayList) {
            if (this.isLoading) {
                this.pendingStringIOs.add(s);
            } else {
                s.finishLoad();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        log.debug("StringIO manager : start load");
        ArrayList<OlcbStringIO> arrayList = this.pendingStringIOs;
        synchronized (arrayList) {
            this.isLoading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        log.debug("StringIO manager : finish load");
        ArrayList<OlcbStringIO> arrayList = this.pendingStringIOs;
        synchronized (arrayList) {
            this.pendingStringIOs.forEach(OlcbStringIO::finishLoad);
            this.pendingStringIOs.clear();
            this.isLoading = false;
        }
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddStringIOEntryToolTip");
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        name = super.validateSystemNameFormat(name, locale);
        name = OlcbAddress.validateSystemNameFormat(name, locale, this.getSystemNamePrefix(), (CanSystemConnectionMemo)this.memo);
        return name;
    }
}

