/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.openlcb.OpenLcbLocoAddress;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.VersionedValueListener;
import org.openlcb.implementations.throttle.RemoteTrainNode;
import org.openlcb.implementations.throttle.TractionThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbThrottle
extends AbstractThrottle {
    final TractionThrottle ot;
    final DccLocoAddress address;
    VersionedValueListener<Float> speedListener;
    List<VersionedValueListener<Boolean>> fnListeners = new ArrayList<VersionedValueListener<Boolean>>();
    private static final Logger log = LoggerFactory.getLogger(OlcbThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlcbThrottle(DccLocoAddress address, SystemConnectionMemo memo) {
        super(memo);
        OlcbInterface iface = memo.get(OlcbInterface.class);
        OlcbThrottle olcbThrottle = this;
        synchronized (olcbThrottle) {
            this.speedSetting = 0.0f;
            this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        }
        this.isForward = true;
        this.address = address;
        if (iface.getNodeStore() == null) {
            log.error("Failed to access Mimic Node Store");
        }
        if (iface.getDatagramService() == null) {
            log.error("Failed to access Datagram Service");
        }
        this.ot = new TractionThrottle(iface);
        NodeID nid = address instanceof OpenLcbLocoAddress ? ((OpenLcbLocoAddress)address).getNode() : OlcbThrottle.guessDCCNodeID(this.address.isLongAddress(), this.address.getNumber());
        this.ot.start(new RemoteTrainNode(nid, iface));
        this.speedListener = new VersionedValueListener<Float>(this.ot.getSpeed()){

            public void update(Float speedAndDir) {
                OlcbThrottle.this.updateSpeedAndDirFromNetwork(speedAndDir);
            }
        };
        int i = 0;
        while (i <= 28) {
            final int finalI = i++;
            this.fnListeners.add(new VersionedValueListener<Boolean>(this.ot.getFunction(finalI)){

                public void update(Boolean state) {
                    OlcbThrottle.this.updateFunction(finalI, state);
                }
            });
        }
    }

    public static NodeID guessDCCNodeID(boolean isLong, int dccAddress) {
        if (isLong) {
            return new NodeID(new byte[]{6, 1, 0, 0, (byte)(dccAddress >> 8 & 0xFF | 0xC0), (byte)(dccAddress & 0xFF)});
        }
        return new NodeID(new byte[]{6, 1, 0, 0, 0, (byte)(dccAddress & 0xFF)});
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        if ((double)speed > 1.0) {
            log.warn("Speed was set too high: {}", (Object)Float.valueOf(speed));
        }
        this.speedSetting = speed;
        if ((double)speed >= 0.0) {
            this.speedListener.setFromOwner((Object)Float.valueOf(this.getSpeedAndDir()));
        } else {
            this.speedListener.setFromOwner((Object)Float.valueOf(Float.NaN));
        }
        log.debug("Speed set update old {} new {} int", (Object)Float.valueOf(oldSpeed), (Object)Float.valueOf(this.speedSetting));
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpeedAndDirFromNetwork(Float speedAndDir) {
        float newSpeed;
        float direction = Math.copySign(1.0f, speedAndDir.floatValue());
        if (speedAndDir.isNaN()) {
            newSpeed = -1.0f;
            direction = this.isForward ? 1.0f : -1.0f;
        } else {
            newSpeed = speedAndDir.floatValue() / 56.327038f;
            if (direction < 0.0f) {
                newSpeed = -newSpeed;
            }
        }
        OlcbThrottle olcbThrottle = this;
        synchronized (olcbThrottle) {
            float oldSpeed = this.speedSetting;
            boolean oldDir = this.isForward;
            this.speedSetting = newSpeed;
            this.isForward = direction > 0.0f;
            log.debug("Speed listener update old {} new {}", (Object)Float.valueOf(oldSpeed), (Object)Float.valueOf(this.speedSetting));
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
            if (oldDir != this.isForward) {
                this.firePropertyChange("IsForward", oldDir, this.isForward);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        OlcbThrottle olcbThrottle = this;
        synchronized (olcbThrottle) {
            this.speedListener.setFromOwner((Object)Float.valueOf(this.getSpeedAndDir()));
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    private float getSpeedAndDir() {
        float sp = this.speedSetting * 126.0f * 0.44704f;
        if (this.speedSetting < 0.0f) {
            sp = 0.0f;
        }
        return Math.copySign(sp, this.isForward ? 1.0f : -1.0f);
    }

    @Override
    public void setFunction(int functionNum, boolean newState) {
        this.updateFunction(functionNum, newState);
        if (functionNum >= 0 && functionNum < this.fnListeners.size()) {
            this.fnListeners.get(functionNum).setFromOwner((Object)newState);
        }
    }

    @Override
    public void throttleDispose() {
        log.debug("throttleDispose() called for address {}", (Object)this.address);
        this.speedListener.release();
        for (VersionedValueListener<Boolean> l : this.fnListeners) {
            l.release();
        }
        this.ot.release();
        this.finishRecord();
    }
}

