/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.NamedBean;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.Bundle;
import jmri.jmrix.openlcb.OlcbAddress;
import jmri.jmrix.openlcb.OlcbUtils;
import org.openlcb.EventID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.EventTable;
import org.openlcb.implementations.VersionedValueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbTurnout
extends AbstractTurnout {
    OlcbAddress addrThrown;
    OlcbAddress addrClosed;
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;
    VersionedValueListener<Boolean> turnoutListener;
    BitProducerConsumer pc;
    EventTable.EventTableEntryHolder thrownEventTableEntryHolder = null;
    EventTable.EventTableEntryHolder closedEventTableEntryHolder = null;
    static final boolean DEFAULT_IS_AUTHORITATIVE = true;
    static final boolean DEFAULT_LISTEN = true;
    private static final String[] validFeedbackNames = new String[]{"MONITORING", "ONESENSOR", "TWOSENSOR", "DIRECT"};
    private static final int[] validFeedbackModes = new int[]{8, 16, 32, 1};
    private static final int validFeedbackTypes = 57;
    private static final int defaultFeedbackType = 8;
    private static final Logger log = LoggerFactory.getLogger(OlcbTurnout.class);

    protected OlcbTurnout(String prefix, String address, CanSystemConnectionMemo memo) {
        super(prefix + "T" + address);
        this.memo = memo;
        this.iface = memo != null ? memo.get(OlcbInterface.class) : null;
        this._validFeedbackNames = validFeedbackNames;
        this._validFeedbackModes = validFeedbackModes;
        this._validFeedbackTypes = 57;
        this._activeFeedbackType = 8;
        this.init(address);
    }

    private void init(String address) {
        OlcbAddress a = new OlcbAddress(address, this.memo);
        OlcbAddress[] v = a.split(this.memo);
        if (v == null) {
            log.error("Did not find usable system name: {}", (Object)address);
            return;
        }
        if (v.length == 2) {
            this.addrThrown = v[0];
            this.addrClosed = v[1];
        } else {
            log.error("Can't parse OpenLCB Turnout system name: {}", (Object)address);
        }
    }

    public void finishLoad() {
        int flags;
        this.disposePc();
        switch (this._activeFeedbackType) {
            default: {
                flags = 30;
                break;
            }
            case 1: {
                flags = 2;
            }
        }
        flags = OlcbUtils.overridePCFlagsFromProperties(this, flags);
        this.pc = new BitProducerConsumer(this.iface, this.addrThrown.toEventID(), this.addrClosed.toEventID(), flags);
        this.turnoutListener = new VersionedValueListener<Boolean>(this.pc.getValue()){

            public void update(Boolean value) {
                int s;
                int n = s = value ^ OlcbTurnout.this.getInverted() ? 4 : 2;
                if (OlcbTurnout.this._activeFeedbackType != 1) {
                    OlcbTurnout.this.newCommandedState(s);
                    if (OlcbTurnout.this._activeFeedbackType == 8) {
                        OlcbTurnout.this.newKnownState(s);
                    }
                }
            }
        };
        if (this.thrownEventTableEntryHolder != null) {
            this.thrownEventTableEntryHolder.release();
            this.thrownEventTableEntryHolder = null;
        }
        if (this.closedEventTableEntryHolder != null) {
            this.closedEventTableEntryHolder.release();
            this.closedEventTableEntryHolder = null;
        }
        this.thrownEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrThrown.toEventID(), this.getEventName(true));
        this.closedEventTableEntryHolder = this.iface.getEventTable().addEvent(this.addrClosed.toEventID(), this.getEventName(false));
    }

    public String getEventName(boolean isThrown) {
        String name = this.getUserName();
        if (name == null) {
            name = this.mSystemName;
        }
        String msgName = isThrown ? "TurnoutThrownEventName" : "TurnoutClosedEventName";
        return Bundle.getMessage(msgName, name);
    }

    public EventID getEventID(boolean isThrown) {
        if (isThrown) {
            return this.addrThrown.toEventID();
        }
        return this.addrClosed.toEventID();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getRecommendedToolTip() {
        return this.addrClosed.toDottedString() + ";" + this.addrThrown.toDottedString();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        super.setUserName(s);
        if (this.thrownEventTableEntryHolder != null) {
            this.thrownEventTableEntryHolder.getEntry().updateDescription(this.getEventName(true));
        }
        if (this.closedEventTableEntryHolder != null) {
            this.closedEventTableEntryHolder.getEntry().updateDescription(this.getEventName(false));
        }
    }

    @Override
    public void setFeedbackMode(int mode) throws IllegalArgumentException {
        boolean recreate = mode != this._activeFeedbackType && this.pc != null;
        super.setFeedbackMode(mode);
        if (recreate) {
            this.finishLoad();
        }
    }

    @Override
    public void setProperty(@Nonnull String key, Object value) {
        Object old = this.getProperty(key);
        super.setProperty(key, value);
        if (value.equals(old)) {
            return;
        }
        if (this.pc == null) {
            return;
        }
        this.finishLoad();
    }

    @Override
    protected void forwardCommandChangeToLayout(int s) {
        if (s == 4) {
            this.turnoutListener.setFromOwnerWithForceNotify((Object)(true ^ this.getInverted()));
            if (this._activeFeedbackType == 8) {
                this.newKnownState(4);
            }
        } else if (s == 2) {
            this.turnoutListener.setFromOwnerWithForceNotify((Object)(false ^ this.getInverted()));
            if (this._activeFeedbackType == 8) {
                this.newKnownState(2);
            }
        } else if (s == 1) {
            if (this.pc != null) {
                this.pc.resetToDefault();
            }
            this.newKnownState(1);
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this._activeFeedbackType == 8 && this.pc != null) {
            this.pc.resetToDefault();
            this.pc.sendQuery();
        }
        super.requestUpdateFromLayout();
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean locked) {
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.thrownEventTableEntryHolder != null) {
            this.thrownEventTableEntryHolder.release();
            this.thrownEventTableEntryHolder = null;
        }
        if (this.closedEventTableEntryHolder != null) {
            this.closedEventTableEntryHolder.release();
            this.closedEventTableEntryHolder = null;
        }
        this.disposePc();
        super.dispose();
    }

    private void disposePc() {
        if (this.turnoutListener != null) {
            this.turnoutListener.release();
        }
        if (this.pc != null) {
            this.pc.release();
        }
        this.turnoutListener = null;
        this.pc = null;
    }

    public void setAuthoritative(boolean authoritative) {
        boolean recreate = authoritative != this.isAuthoritative() && this.pc != null;
        this.setProperty("IsAuthoritative", authoritative);
        if (recreate) {
            this.finishLoad();
        }
    }

    public boolean isAuthoritative() {
        Boolean value = (Boolean)this.getProperty("IsAuthoritative");
        if (value != null) {
            return value;
        }
        return true;
    }

    public boolean isListeningToStateMessages() {
        Boolean value = (Boolean)this.getProperty("ListenStateMessages");
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setListeningToStateMessages(boolean listen) {
        boolean recreate = listen != this.isListeningToStateMessages() && this.pc != null;
        this.setProperty("ListenStateMessages", listen);
        if (recreate) {
            this.finishLoad();
        }
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return OlcbAddress.compareSystemNameSuffix(suffix1, suffix2, this.memo);
    }
}

