/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import jmri.NamedBean;

public final class OlcbUtils {
    public static final String PROPERTY_IS_AUTHORITATIVE = "IsAuthoritative";
    public static final String PROPERTY_IS_PRODUCER = "IsProducer";
    public static final String PROPERTY_IS_CONSUMER = "IsConsumer";
    public static final String PROPERTY_QUERY_AT_STARTUP = "QueryAtStartup";
    public static final String PROPERTY_LISTEN = "ListenStateMessages";
    public static final String PROPERTY_LISTEN_INVALID = "ListenInvalidStateMessages";

    private OlcbUtils() {
    }

    private static int updateBooleanProperty(int flags, NamedBean parent, String propertyKey, int flagValue) {
        Object propValue = parent.getProperty(propertyKey);
        if (propValue == null) {
            return flags;
        }
        if (!(propValue instanceof Boolean)) {
            boolean v = Boolean.parseBoolean((String)propValue);
            parent.setProperty(propertyKey, v);
            propValue = v;
        }
        boolean prop = (Boolean)propValue;
        if (flagValue < 0) {
            prop = !prop;
            flagValue = -flagValue;
        }
        if (prop) {
            return flags | flagValue;
        }
        return flags & ~flagValue;
    }

    static int overridePCFlagsFromProperties(NamedBean parent, int defaultFlags) {
        int ret = defaultFlags;
        ret = OlcbUtils.updateBooleanProperty(ret, parent, PROPERTY_IS_AUTHORITATIVE, -32);
        ret = OlcbUtils.updateBooleanProperty(ret, parent, PROPERTY_IS_PRODUCER, 2);
        ret = OlcbUtils.updateBooleanProperty(ret, parent, PROPERTY_IS_CONSUMER, 4);
        ret = OlcbUtils.updateBooleanProperty(ret, parent, PROPERTY_QUERY_AT_STARTUP, 8);
        ret = OlcbUtils.updateBooleanProperty(ret, parent, PROPERTY_LISTEN, 16);
        ret = OlcbUtils.updateBooleanProperty(ret, parent, PROPERTY_LISTEN_INVALID, 64);
        return ret;
    }

    static boolean isOlcbBean(NamedBean b) {
        return b.getClass().getName().contains("Olcb");
    }
}

