/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.configurexml;

import java.util.Map;
import jmri.jmrix.PortAdapter;
import jmri.jmrix.can.CanSystemConnectionMemo;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    public static void maybeLoadOlcbProfileSettings(Element shared, Element perNode, PortAdapter adapter) {
        CanSystemConnectionMemo sc = ConnectionConfigXml.isOpenLCBProtocol(adapter);
        if (sc == null) {
            return;
        }
        ConnectionConfigXml.loadSettingsElement(sc, shared);
        ConnectionConfigXml.loadSettingsElement(sc, perNode);
    }

    private static void loadSettingsElement(CanSystemConnectionMemo sc, Element xmlNode) {
        for (Element n : xmlNode.getChildren("node")) {
            String protocol = n.getAttributeValue("name");
            for (Element p : n.getChildren("parameter")) {
                String optionName = p.getAttributeValue("name");
                String value = p.getTextTrim();
                sc.setProtocolOption(protocol, optionName, value);
            }
        }
    }

    public static void maybeSaveOlcbProfileSettings(Element element, PortAdapter adapter) {
        CanSystemConnectionMemo sc = ConnectionConfigXml.isOpenLCBProtocol(adapter);
        if (sc == null) {
            return;
        }
        for (String protocol : sc.getProtocolsWithOptions()) {
            Element n = new Element("node");
            n.setAttribute("name", protocol);
            element.addContent((Content)n);
            Map<String, String> params = sc.getProtocolAllOptions(protocol);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                Element p = new Element("parameter");
                p.setAttribute("name", entry.getKey());
                p.addContent(entry.getValue());
                n.addContent((Content)p);
            }
        }
    }

    public static CanSystemConnectionMemo isOpenLCBProtocol(PortAdapter adapter) {
        CanSystemConnectionMemo sc = (CanSystemConnectionMemo)adapter.getSystemConnectionMemo();
        if (sc == null) {
            log.error("Adapter is expected to have a CanSystemConnectionMemo to be used for OpenLCB protocol.");
            return null;
        }
        if (!"OpenLCB".equals(adapter.getOptionState("Protocol"))) {
            log.debug("Skipping OpenLCB protocol properties action, because protocol is not OpenLCB, but {}", (Object)adapter.getOptionState("Protocol"));
            return null;
        }
        return sc;
    }
}

