/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrix.openlcb.OlcbEventNameStore;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.openlcb.EventID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbEventNameStoreXml
extends XmlFile {
    OlcbEventNameStore nameStore;
    String baseFileName;
    private static final String EVENT_NAMES_DIRECTORY_NAME = "eventnames";
    private static final Logger log = LoggerFactory.getLogger(OlcbEventNameStoreXml.class);

    public OlcbEventNameStoreXml(OlcbEventNameStore nameStore, String baseFileName) {
        this.nameStore = nameStore;
        this.baseFileName = baseFileName;
        this.migrateFromIdTagStore();
    }

    private void migrateFromIdTagStore() {
        File file = this.findFile(this.getDefaultEventNameFileName());
        if (file != null) {
            return;
        }
        IdTagManager tagmgr = InstanceManager.getDefault(IdTagManager.class);
        log.debug("*** Starting event name migration");
        SortedSet tagSet = tagmgr.getNamedBeanSet();
        HashSet localSet = new HashSet(tagSet);
        for (IdTag tag : localSet) {
            log.debug("  Process tag {}", (Object)tag);
            if (!tag.getSystemName().startsWith("IDOpenLCB$")) continue;
            String eid = tag.getSystemName().substring("IDOpenLCB$".length());
            log.info("    Migrating event name '{}' event ID '{}' from IdTag table", (Object)tag.getUserName(), (Object)eid);
            this.nameStore.addMatch(new EventID(eid), tag.getUserName());
            tagmgr.deregister(tag);
            tag.dispose();
        }
        log.debug("*** Ending event name migration");
    }

    public void store() throws IOException {
        log.debug("Storing using file: {}", (Object)this.getDefaultEventNameFileName());
        this.createFile(this.getDefaultEventNameFileName(), true);
        try {
            this.writeFile(this.getDefaultEventNameFileName());
        }
        catch (FileNotFoundException ex) {
            log.error("File not found while writing Event Name file, may not be complete", (Throwable)ex);
        }
    }

    public void load() {
        log.debug("Loading...");
        boolean wasDirty = this.nameStore.dirty;
        try {
            this.readFile(this.getDefaultEventNameFileName());
        }
        catch (IOException | JDOMException ex) {
            log.error("Exception during IdTag file reading", ex);
        }
        this.nameStore.dirty = wasDirty;
    }

    private File createFile(String fileName, boolean backup) {
        if (backup) {
            this.makeBackupFile(fileName);
        }
        File file = null;
        try {
            if (!this.checkFile(fileName)) {
                file = new File(fileName);
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("New file created");
                }
            } else {
                file = new File(fileName);
            }
        }
        catch (IOException ex) {
            log.error("Exception while creating Event Name file, may not be complete", (Object)ex);
        }
        return file;
    }

    private void writeFile(String fileName) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)fileName);
        File file = this.findFile(fileName);
        if (file == null) {
            file = new File(fileName);
        }
        Element root = new Element("eventNameStore");
        Document doc = OlcbEventNameStoreXml.newDocument(root);
        Element values = new Element("names");
        root.addContent((Content)values);
        for (EventID eid : this.nameStore.getMatches()) {
            String name = this.nameStore.getEventName(eid);
            log.debug("Writing event name: {} event {}", (Object)name, (Object)eid);
            Element element = new Element("entry");
            Element nameElement = new Element("name");
            nameElement.addContent(name);
            Element eventIdElement = new Element("eventID");
            eventIdElement.addContent(eid.toShortString());
            element.addContent((Content)eventIdElement);
            element.addContent((Content)nameElement);
            values.addContent((Content)element);
        }
        this.writeXML(file, doc);
    }

    private String getDefaultEventNameFileName() {
        return this.getFileLocation() + this.getEventNameDirectoryName() + File.separator + this.getEventNameFileName();
    }

    private String getFileLocation() {
        return FileUtil.getUserFilesPath();
    }

    private String getEventNameDirectoryName() {
        return EVENT_NAMES_DIRECTORY_NAME;
    }

    private String getEventNameFileName() {
        return "eventNames.xml";
    }

    private void readFile(String fileName) throws JDOMException, IOException, IllegalArgumentException {
        if (this.findFile(fileName) == null) {
            log.debug("{} file could not be found", (Object)fileName);
            return;
        }
        Element root = this.rootFromName(fileName);
        if (root == null) {
            log.debug("{} file could not be read", (Object)fileName);
            return;
        }
        if (root.getChild("names") != null) {
            List l = root.getChild("names").getChildren("entry");
            log.debug("readFile sees {} event names", (Object)l.size());
            for (Element e : l) {
                String eid = e.getChild("eventID").getText();
                String name = e.getChild("name").getText();
                log.debug("read EventID {}", (Object)eid);
                this.nameStore.addMatch(new EventID(eid), name);
            }
        }
    }
}

