/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.configurexml;

import jmri.Meter;
import jmri.MeterManager;
import jmri.jmrix.openlcb.OlcbMeterManager;
import jmri.managers.configurexml.AbstractMeterManagerXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbMeterManagerXml
extends AbstractMeterManagerXml {
    private static final Logger log = LoggerFactory.getLogger(OlcbMeterManagerXml.class);

    @Override
    public void setStoreElementClass(Element meters) {
        meters.setAttribute("class", this.getClass().getName());
    }

    @Override
    protected Element storeMeter(Meter m) {
        String mName = m.getSystemName();
        Element elem = new Element("meter");
        elem.addContent((Content)new Element("systemName").addContent(mName));
        elem.setAttribute("class", m.getClass().getName());
        this.storeCommon(m, elem);
        return elem;
    }

    @Override
    protected void loadMeter(String sysName, String userName, Element el, MeterManager mm) {
        log.debug("get Meter: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
        Meter m = (Meter)mm.getBySystemName(sysName);
        if (m == null) {
            if (el.getAttributeValue("class").contains("Voltage")) {
                m = OlcbMeterManager.createVoltageMeter(sysName);
            } else if (el.getAttributeValue("class").contains("Current")) {
                m = OlcbMeterManager.createCurrentMeter(sysName);
            } else {
                log.error("Unexpected class when restoring OpenLCB meter: {}", (Object)el.getChild("class").getContent());
                return;
            }
        }
        m.setUserName(userName);
        this.loadCommon(m, el);
    }
}

