/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jmri.Application;
import jmri.jmrit.XmlFile;
import jmri.jmrix.openlcb.OlcbNodeGroupStore;
import jmri.util.FileUtil;
import jmri.util.LoggingUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.openlcb.NodeID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbNodeGroupStoreXml
extends XmlFile {
    OlcbNodeGroupStore store;
    private static final String DIRECTORY_NAME = "idtags";
    private String BASE_FILENAME = "NodeGroupAssociations.xml";
    private final String FILE_LOCATION = FileUtil.getUserFilesPath();
    private final Logger log = LoggerFactory.getLogger(OlcbNodeGroupStoreXml.class);

    public OlcbNodeGroupStoreXml(OlcbNodeGroupStore store, String baseFileName) {
        this.store = store;
        this.BASE_FILENAME = baseFileName;
    }

    public void store() throws IOException {
        this.log.debug("Storing using file: {}", (Object)this.getDefaultFileName());
        this.createFile(this.getDefaultFileName(), true);
        try {
            this.log.debug("about to call writeFile");
            this.writeFile(this.getDefaultFileName());
        }
        catch (FileNotFoundException ex) {
            this.log.error("File not found while writing node group file, may not be complete", (Throwable)ex);
        }
    }

    public void load() {
        this.log.debug("Loading...");
        try {
            this.readFile(this.getDefaultFileName());
        }
        catch (IOException | JDOMException ex) {
            this.log.error("Exception during node group file reading", ex);
        }
        this.log.debug("load complete...");
    }

    private File createFile(String fileName, boolean backup) {
        if (backup) {
            this.makeBackupFile(fileName);
        }
        File file = null;
        try {
            if (!this.checkFile(fileName)) {
                this.log.debug("file check done");
                file = new File(fileName);
                File parentDir = file.getParentFile();
                this.log.debug("before exists {}", (Object)parentDir);
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    this.log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    this.log.debug("New file created");
                }
            } else {
                file = new File(fileName);
            }
        }
        catch (IOException ex) {
            this.log.error("Exception while creating IdTag file, may not be complete", (Object)ex);
        }
        return file;
    }

    private void writeFile(String fileName) throws FileNotFoundException, IOException {
        this.log.debug("writeFile {}", (Object)fileName);
        File file = this.findFile(fileName);
        if (file == null) {
            file = new File(fileName);
        }
        Element root = new Element("nodegroupassociations");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/nodegroupassociations.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = OlcbNodeGroupStoreXml.newDocument(root);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/nodegroupassociations.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        for (String group : this.store.getGroupNames()) {
            for (NodeID node : this.store.getGroupNodes(group)) {
                Element values = new Element("association");
                root.addContent((Content)values);
                values.addContent((Content)new Element("node").addContent(node.toString()));
                values.addContent((Content)new Element("group").addContent(group));
            }
        }
        this.log.debug("write to {}", (Object)file);
        this.writeXML(file, doc);
    }

    private void readFile(String fileName) throws JDOMException, IOException, IllegalArgumentException {
        if (this.findFile(fileName) == null) {
            this.log.debug("{} file could not be found", (Object)fileName);
            return;
        }
        Element root = this.rootFromName(fileName);
        if (root == null) {
            this.log.warn("{} file could not be read", (Object)fileName);
            return;
        }
        List l = root.getChildren("association");
        for (Element e : l) {
            NodeID node = new NodeID(e.getChild("node").getText());
            String group = e.getChild("group").getText();
            this.log.trace("load entry {} {}", (Object)node, (Object)group);
            this.store.addNodeToGroup(node, group);
        }
    }

    public String getDefaultFileName() {
        return this.getFileLocation() + this.getDirectoryName() + File.separator + this.getFileName();
    }

    public String getDirectoryName() {
        return DIRECTORY_NAME;
    }

    public String getFileName() {
        String appName = Application.getApplicationName();
        if (appName.equals("LccPro")) {
            appName = "PanelPro";
        }
        String retval = appName + this.BASE_FILENAME;
        LoggingUtil.infoOnce(this.log, "Using " + retval + " for LCC node group storage", new Object[0]);
        return retval;
    }

    public String getFileLocation() {
        return this.FILE_LOCATION;
    }
}

