/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.configurexml;

import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalAppearanceMap;
import jmri.SignalMastManager;
import jmri.jmrix.openlcb.OlcbSignalMast;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbSignalMastXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(OlcbSignalMastXml.class);

    @Override
    public Element store(Object o) {
        List<String> disabledAspects;
        OlcbSignalMast p = (OlcbSignalMast)o;
        Element e = new Element("olcbsignalmast");
        e.setAttribute("class", this.getClass().getName());
        e.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, e);
        Element lit = new Element("lit");
        lit.addContent((Content)new Element("lit").addContent(p.getLitEventId()));
        lit.addContent((Content)new Element("notlit").addContent(p.getNotLitEventId()));
        e.addContent((Content)lit);
        Element held = new Element("held");
        held.addContent((Content)new Element("held").addContent(p.getHeldEventId()));
        held.addContent((Content)new Element("notheld").addContent(p.getNotHeldEventId()));
        e.addContent((Content)held);
        SignalAppearanceMap appMap = p.getAppearanceMap();
        if (appMap != null) {
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                Element el = new Element("aspect");
                el.setAttribute("defines", key);
                el.addContent((Content)new Element("event").addContent(p.getOutputForAppearance(key)));
                e.addContent((Content)el);
            }
        }
        if ((disabledAspects = p.getDisabledAspects()) != null) {
            Element el = new Element("disabledAspects");
            for (String aspect : disabledAspects) {
                Element ele = new Element("disabledAspect");
                ele.addContent(aspect);
                el.addContent((Content)ele);
            }
            if (disabledAspects.size() != 0) {
                e.addContent((Content)el);
            }
        }
        return e;
    }

    @Override
    public boolean load(@Nonnull Element shared, Element perNode) {
        OlcbSignalMast m;
        String sys = this.getSystemName(shared);
        try {
            m = (OlcbSignalMast)InstanceManager.getDefault(SignalMastManager.class).provideCustomSignalMast(sys, OlcbSignalMast.class);
        }
        catch (JmriException e) {
            log.error("Failed to load OlcbSignalMast {}", (Object)sys, (Object)e);
            return false;
        }
        if (this.getUserName(shared) != null) {
            m.setUserName(this.getUserName(shared));
        }
        return this.loadCommonOlcbMast(m, shared);
    }

    protected boolean loadCommonOlcbMast(OlcbSignalMast m, Element element) {
        this.loadCommon(m, element);
        if (element.getChild("lit") != null) {
            Element lit = element.getChild("lit");
            m.setLitEventId(lit.getChild("lit").getValue());
            m.setNotLitEventId(lit.getChild("notlit").getValue());
        }
        if (element.getChild("held") != null) {
            Element held = element.getChild("held");
            m.setHeldEventId(held.getChild("held").getValue());
            m.setNotHeldEventId(held.getChild("notheld").getValue());
        }
        List list = element.getChildren("aspect");
        for (Element e : list) {
            String aspect = e.getAttribute("defines").getValue();
            String event = e.getChild("event").getValue();
            m.setOutputForAppearance(aspect, event);
        }
        Element e = element.getChild("disabledAspects");
        if (e != null) {
            list = e.getChildren("disabledAspect");
            for (String aspect : list) {
                m.setAspectDisabled(aspect.getText());
            }
        }
        return true;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

