/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.Turnout;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbEventNameStore;
import jmri.jmrix.openlcb.swing.Bundle;
import jmri.jmrix.openlcb.swing.NamedEventIdTextField;
import jmri.jmrix.openlcb.swing.NodeSpecificFrame;
import jmri.util.swing.WrapLayout;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.cdi.swing.CdiPanel;
import org.openlcb.swing.EventIdTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientActions {
    private final OlcbInterface iface;
    private final CanSystemConnectionMemo memo;
    CdiPanel cdiPanel;
    ShutDownTask shutDownTask;
    private static final Logger log = LoggerFactory.getLogger(ClientActions.class);

    public ClientActions(OlcbInterface iface, CanSystemConnectionMemo memo) {
        this.iface = iface;
        this.memo = memo;
    }

    public void openCdiWindow(NodeID destNode, String description) {
        final ArrayList sensorButtonList = new ArrayList();
        final ArrayList turnoutButtonList = new ArrayList();
        NodeSpecificFrame f = new NodeSpecificFrame(destNode);
        f.setTitle(Bundle.getMessage("CdiPanelConfigure", description));
        f.setLayout(new BoxLayout(f.getContentPane(), 1));
        f.addHelpMenu("package.jmri.jmrix.openlcb.swing.networktree.NetworkTreePane_CDItool", true);
        this.cdiPanel = new CdiPanel(){

            protected void targetWindowClosingEvent(WindowEvent evt) {
                log.trace("overridden targetWindowClosingEvent runs");
                super.targetWindowClosingEvent(evt);
            }

            public void release() {
                super.release();
                InstanceManager.getDefault(ShutDownManager.class).deregister(ClientActions.this.shutDownTask);
            }
        };
        f.add((Component)this.cdiPanel);
        this.cdiPanel.setEventTable(this.iface.getNodeStore().getSimpleNodeIdent(destNode).getUserName(), this.iface.getEventTable());
        this.shutDownTask = new ShutDownTask(){

            @Override
            public String getName() {
                return "CDI Window Check";
            }

            @Override
            public Boolean call() {
                log.trace("call( checks contents)");
                boolean result = ClientActions.this.cdiPanel.checkOnWindowClosing();
                if (result) {
                    ClientActions.this.cdiPanel.setWindowCloseCheckAlreadyHandled();
                }
                return result;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
            }

            @Override
            public void run() {
            }
        };
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        CdiPanel.GuiItemFactory factory = new CdiPanel.GuiItemFactory(){
            private boolean haveButtons = false;
            JPanel gpane = null;
            JTextField desc = null;
            JTextComponent evt1 = null;
            JTextComponent evt2 = null;

            public JButton handleReadButton(JButton button) {
                return button;
            }

            public JButton handleWriteButton(JButton button) {
                return button;
            }

            public void handleGroupPaneStart(JPanel pane) {
                this.gpane = pane;
                this.evt1 = null;
                this.evt2 = null;
                this.desc = null;
            }

            public void handleGroupPaneEnd(JPanel pane) {
                if (this.gpane != null && this.evt1 != null && this.evt2 != null && this.desc != null) {
                    JPanel p = new JPanel();
                    p.setLayout(new WrapLayout());
                    p.setAlignmentX(-1.0f);
                    pane.add(p);
                    JButton button = new JButton(Bundle.getMessage("CdiPanelMakeSensor"));
                    p.add(button);
                    sensorButtonList.add(button);
                    button.addActionListener(new ActionListener(){
                        final JTextField mdesc;
                        final JTextComponent mevt1;
                        final JTextComponent mevt2;
                        {
                            this.mdesc = desc;
                            this.mevt1 = evt1;
                            this.mevt2 = evt2;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(ClientActions.this.memo.getSystemPrefix() + "S" + this.mevt1.getText() + ";" + this.mevt2.getText());
                            if (this.mdesc.getText().length() > 0) {
                                sensor.setUserName(this.mdesc.getText());
                            }
                            log.info("make sensor MS{};{} [{}]", new Object[]{this.mevt1.getText(), this.mevt2.getText(), this.mdesc.getText()});
                        }
                    });
                    button = new JButton(Bundle.getMessage("CdiPanelMakeTurnout"));
                    p.add(button);
                    turnoutButtonList.add(button);
                    button.addActionListener(new ActionListener(){
                        final JTextField mdesc;
                        final JTextComponent mevt1;
                        final JTextComponent mevt2;
                        {
                            this.mdesc = desc;
                            this.mevt1 = evt1;
                            this.mevt2 = evt2;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Turnout turnout = InstanceManager.turnoutManagerInstance().provideTurnout(ClientActions.this.memo.getSystemPrefix() + "T" + this.mevt1.getText() + ";" + this.mevt2.getText());
                            if (this.mdesc.getText().length() > 0) {
                                turnout.setUserName(this.mdesc.getText());
                            }
                            log.info("make turnout MT{};{} [{}]", new Object[]{this.mevt1.getText(), this.mevt2.getText(), this.mdesc.getText()});
                        }
                    });
                    if (!this.haveButtons) {
                        this.haveButtons = true;
                        ClientActions.this.cdiPanel.addButtonToFooter((JComponent)ClientActions.this.buttonForList(sensorButtonList, Bundle.getMessage("CdiPanelMakeAllSensors")));
                        ClientActions.this.cdiPanel.addButtonToFooter((JComponent)ClientActions.this.buttonForList(turnoutButtonList, Bundle.getMessage("CdiPanelMakeAllTurnouts")));
                    }
                    this.gpane = null;
                    this.evt1 = null;
                    this.evt2 = null;
                    this.desc = null;
                }
            }

            public JTextComponent handleEventIdTextField(EventIdTextField input) {
                NamedEventIdTextField field = new NamedEventIdTextField(ClientActions.this.memo);
                if (this.evt1 == null) {
                    this.evt1 = field;
                } else if (this.evt2 == null) {
                    this.evt2 = field;
                } else {
                    this.gpane = null;
                }
                return field;
            }

            public JTextField handleStringValue(JTextField value) {
                this.desc = value;
                return value;
            }

            public void makeSensor(String ev, String mdesc) {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(ClientActions.this.memo.getSystemPrefix() + "S" + ev);
                if (mdesc.length() > 0) {
                    sensor.setUserName(mdesc);
                }
                log.debug("make sensor MS{} [{}]", (Object)ev, (Object)mdesc);
            }
        };
        ConfigRepresentation rep = this.iface.getConfigForNode(destNode);
        rep.eventNameStore = this.memo.get(OlcbEventNameStore.class);
        this.cdiPanel.initComponents(rep, factory);
        f.pack();
        f.setVisible(true);
    }

    JButton buttonForList(ArrayList<JButton> list, String label) {
        JButton b = new JButton(label);
        b.addActionListener(e -> {
            int delay = 0;
            for (final JButton b1 : list) {
                ActionListener taskPerformer = new ActionListener(){
                    final JButton target;
                    {
                        this.target = b1;
                    }

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        this.target.doClick();
                    }
                };
                Timer t = new Timer(delay, taskPerformer);
                t.setRepeats(false);
                t.start();
                delay += 150;
            }
        });
        return b;
    }
}

