/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing;

import java.awt.event.WindowEvent;
import java.util.List;
import jmri.jmrix.openlcb.swing.Bundle;
import jmri.jmrix.openlcb.swing.NodeSpecificFrame;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropCdiCache {
    private static final Logger log = LoggerFactory.getLogger(DropCdiCache.class);

    public static void drop(NodeID destNodeID, OlcbInterface iface) {
        boolean first = true;
        List<JmriJFrame> frames = JmriJFrame.getFrameList();
        for (JmriJFrame frame : frames) {
            log.trace("frame: {} type:{}", (Object)frame, frame.getClass());
            if (!(frame instanceof NodeSpecificFrame) || !((NodeSpecificFrame)frame).getNodeID().equals((Object)destNodeID)) continue;
            if (first) {
                int decision = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("OpenWindowMessage"), "Close CDI Window?", 2);
                if (decision == 2) {
                    return;
                }
                first = false;
            }
            ThreadingUtil.runOnGUI(() -> frame.dispatchEvent(new WindowEvent(frame, 201)));
            if (!JmriJFrame.getFrameList().contains(frame)) continue;
            return;
        }
        iface.dropConfigForNode(destNodeID);
    }
}

