/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.SystemConnectionMemo;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbSignalMast;
import jmri.jmrix.openlcb.swing.Bundle;
import jmri.jmrix.openlcb.swing.NamedEventIdTextField;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.javaworld.GridLayout2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbSignalMastAddPane
extends SignalMastAddPane {
    final JCheckBox allowUnLit = new JCheckBox();
    CanSystemConnectionMemo memo = InstanceManager.getDefault(CanSystemConnectionMemo.class);
    LinkedHashMap<String, JCheckBox> allAspectsCheckBoxes = new LinkedHashMap(12);
    final LinkedHashMap<String, NamedEventIdTextField> aspectEventIDs = new LinkedHashMap(12);
    final JPanel allAspectsPanel = new JPanel();
    final NamedEventIdTextField litEventID = new NamedEventIdTextField(this.memo);
    final NamedEventIdTextField notLitEventID = new NamedEventIdTextField(this.memo);
    final NamedEventIdTextField heldEventID = new NamedEventIdTextField(this.memo);
    final NamedEventIdTextField notHeldEventID = new NamedEventIdTextField(this.memo);
    JComboBox<String> connSelectionBox = new JComboBox();
    OlcbSignalMast currentMast = null;
    ArrayList<String> olcbConnections = null;
    final DecimalFormat paddedNumber = new DecimalFormat("0000");
    private static final Logger log = LoggerFactory.getLogger(OlcbSignalMastAddPane.class);

    public OlcbSignalMastAddPane() {
        JPanel p;
        this.setLayout(new BoxLayout(this, 1));
        this.litEventID.setText("00.00.00.00.00.00.00.00");
        this.notLitEventID.setText("00.00.00.00.00.00.00.00");
        this.heldEventID.setText("00.00.00.00.00.00.00.00");
        this.notHeldEventID.setText("00.00.00.00.00.00.00.00");
        this.getOlcbConnections();
        if (this.olcbConnections != null && this.olcbConnections.size() > 1) {
            p = new JPanel();
            TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
            border.setTitle(Bundle.getMessage("OlcbConnection"));
            p.setBorder(border);
            p.setLayout(new GridLayout2(3, 1));
            p.add(this.connSelectionBox);
            this.add(p);
        }
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("AllowUnLitLabel") + ": "));
        p.add(this.allowUnLit);
        p.setAlignmentX(0.0f);
        this.add(p);
        TitledBorder aspectsBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        aspectsBorder.setTitle(Bundle.getMessage("EnterAspectsLabel"));
        JScrollPane allAspectsScroll = new JScrollPane(this.allAspectsPanel);
        allAspectsScroll.setBorder(aspectsBorder);
        this.add(allAspectsScroll);
        TitledBorder litborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        litborder.setTitle(Bundle.getMessage("LitUnLit"));
        JPanel pLit = new JPanel();
        pLit.setBorder(litborder);
        pLit.setLayout(new BoxLayout(pLit, 1));
        JPanel p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("LitLabel")));
        p5.add(Box.createHorizontalGlue());
        pLit.add(p5);
        pLit.add(this.litEventID);
        p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("NotLitLabel")));
        p5.add(Box.createHorizontalGlue());
        pLit.add(p5);
        pLit.add(this.notLitEventID);
        this.add(pLit);
        TitledBorder heldborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        heldborder.setTitle(Bundle.getMessage("HeldUnHeld"));
        JPanel pHeld = new JPanel();
        pHeld.setBorder(heldborder);
        pHeld.setLayout(new BoxLayout(pHeld, 1));
        p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("HeldLabel")));
        p5.add(Box.createHorizontalGlue());
        pHeld.add(p5);
        pHeld.add(this.heldEventID);
        p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.add(new JLabel(Bundle.getMessage("NotHeldLabel")));
        p5.add(Box.createHorizontalGlue());
        pHeld.add(p5);
        pHeld.add(this.notHeldEventID);
        this.add(pHeld);
        this.populateConnSelectionBox();
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("OlcbSignalMastPane");
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap map, @Nonnull SignalSystem sigSystem) {
        Enumeration<String> aspectNames = map.getAspects();
        this.allAspectsCheckBoxes = new LinkedHashMap(12);
        this.allAspectsPanel.removeAll();
        while (aspectNames.hasMoreElements()) {
            String aspectName = aspectNames.nextElement();
            JCheckBox disabled = new JCheckBox(aspectName);
            this.allAspectsCheckBoxes.put(aspectName, disabled);
            NamedEventIdTextField eventID = new NamedEventIdTextField(this.memo);
            eventID.setText("00.00.00.00.00.00.00.00");
            this.aspectEventIDs.put(aspectName, eventID);
        }
        this.allAspectsPanel.setLayout(new BoxLayout(this.allAspectsPanel, 1));
        for (Map.Entry<String, JCheckBox> entry : this.allAspectsCheckBoxes.entrySet()) {
            JPanel p1 = new JPanel();
            TitledBorder p1border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
            p1border.setTitle(entry.getKey());
            p1.setBorder(p1border);
            p1.setLayout(new BoxLayout(p1, 0));
            String iconLink = map.getImageLink(entry.getKey(), "default");
            if (iconLink == null || iconLink.isEmpty()) {
                log.debug("Got empty image link for {}", (Object)entry.getKey());
            } else {
                log.debug("Image link for {} is {}", (Object)entry.getKey(), (Object)iconLink);
                if (!iconLink.contains("preference:")) {
                    iconLink = iconLink.substring(iconLink.indexOf("resources"));
                }
                NamedIcon n = null;
                try {
                    n = new NamedIcon(iconLink, iconLink);
                    log.debug("Loaded icon {}", (Object)iconLink);
                }
                catch (Exception e) {
                    log.debug("Got exception trying to load icon link {}: {}", (Object)iconLink, (Object)e.getMessage());
                }
                if (n != null) {
                    p1.add(new JLabel(n));
                }
            }
            JPanel p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, 1));
            p2.add(this.aspectEventIDs.get(entry.getKey()));
            p2.add(entry.getValue());
            entry.getValue().setName(entry.getKey());
            entry.getValue().setText(Bundle.getMessage("DisableAspect"));
            p1.add(p2);
            this.allAspectsPanel.add(p1);
        }
        this.populateConnSelectionBox();
        this.litEventID.setText("00.00.00.00.00.00.00.00");
        this.notLitEventID.setText("00.00.00.00.00.00.00.00");
        this.heldEventID.setText("00.00.00.00.00.00.00.00");
        this.notHeldEventID.setText("00.00.00.00.00.00.00.00");
        this.allAspectsPanel.revalidate();
    }

    private void getOlcbConnections() {
        this.olcbConnections = null;
        ConnectionConfig[] conns = null;
        try {
            conns = InstanceManager.getDefault(ConnectionConfigManager.class).getConnections();
        }
        catch (Exception e) {
            log.info("No ConnectionConfigManager installed: Using default Olcb Connections");
        }
        if (conns == null || conns.length == 0) {
            log.debug("Found null or empty connections list");
            return;
        }
        for (int x = 0; x < conns.length; ++x) {
            ConnectionConfig cc = conns[x];
            log.debug("conns[{}]: name={} info={} adapter={} conn={}  man={}", new Object[]{x, cc.name(), cc.getInfo(), cc.getAdapter(), cc.getConnectionName(), cc.getManufacturer()});
            String man = cc.getManufacturer();
            String name = cc.getConnectionName();
            if (man == null || name == null || name.isEmpty() || !man.equals("OpenLCB") && !man.equals("LCC")) continue;
            if (this.olcbConnections == null) {
                this.olcbConnections = new ArrayList();
            }
            this.olcbConnections.add(name);
        }
    }

    private void populateConnSelectionBox() {
        this.connSelectionBox.removeAllItems();
        if (this.olcbConnections == null || this.olcbConnections.size() < 2) {
            return;
        }
        for (String conn : this.olcbConnections) {
            this.connSelectionBox.addItem(conn);
        }
        if (this.currentMast == null) {
            this.connSelectionBox.setEnabled(true);
            return;
        }
        String mastPrefix = this.currentMast.getSystemPrefix();
        if (mastPrefix != null) {
            for (String conn : this.olcbConnections) {
                String connectionPrefix = ConnectionNameFromSystemName.getPrefixFromName(conn);
                if (connectionPrefix == null || !connectionPrefix.equals(mastPrefix)) continue;
                this.connSelectionBox.setSelectedItem(conn);
                break;
            }
        }
        this.connSelectionBox.setEnabled(false);
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast instanceof OlcbSignalMast;
    }

    @Override
    public void setMast(SignalMast mast) {
        if (mast == null) {
            this.currentMast = null;
            this.populateConnSelectionBox();
            return;
        }
        if (!(mast instanceof OlcbSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            return;
        }
        this.currentMast = (OlcbSignalMast)mast;
        List<String> disabledList = this.currentMast.getDisabledAspects();
        if (disabledList != null) {
            for (String aspect : disabledList) {
                if (!this.allAspectsCheckBoxes.containsKey(aspect)) continue;
                this.allAspectsCheckBoxes.get(aspect).setSelected(true);
            }
        }
        for (String aspect : this.currentMast.getAllKnownAspects()) {
            if (this.aspectEventIDs.get(aspect) == null) {
                NamedEventIdTextField eventID = new NamedEventIdTextField(this.memo);
                eventID.setText("00.00.00.00.00.00.00.00");
                this.aspectEventIDs.put(aspect, eventID);
            }
            if (this.currentMast.isOutputConfigured(aspect)) {
                this.aspectEventIDs.get(aspect).setText(this.currentMast.getOutputForAppearance(aspect));
                continue;
            }
            this.aspectEventIDs.get(aspect).setText("00.00.00.00.00.00.00.00");
        }
        this.litEventID.setText(this.currentMast.getLitEventId());
        this.notLitEventID.setText(this.currentMast.getNotLitEventId());
        this.heldEventID.setText(this.currentMast.getHeldEventId());
        this.notHeldEventID.setText(this.currentMast.getNotHeldEventId());
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        this.populateConnSelectionBox();
        log.debug("setMast({})", (Object)mast);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        if (this.currentMast == null) {
            String selItem = (String)this.connSelectionBox.getSelectedItem();
            String connectionPrefix = ConnectionNameFromSystemName.getPrefixFromName(selItem);
            log.debug("selected name={}, prefix={}", (Object)selItem, (Object)connectionPrefix);
            if (connectionPrefix == null || connectionPrefix.isEmpty()) {
                connectionPrefix = "M";
            }
            String type = mastname.substring(11, mastname.length() - 4);
            String name = connectionPrefix + "F$olm:" + sigsysname + ":" + type;
            name = name + "($" + this.paddedNumber.format(OlcbSignalMast.getLastRef() + 1) + ")";
            log.debug("Creating mast: {}", (Object)name);
            this.currentMast = new OlcbSignalMast(name);
            if (!username.equals("")) {
                this.currentMast.setUserName(username);
            }
            this.currentMast.setMastType(type);
            InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
        }
        for (Map.Entry<String, JCheckBox> entry : this.allAspectsCheckBoxes.entrySet()) {
            if (entry.getValue().isSelected()) {
                this.currentMast.setAspectDisabled(entry.getKey());
            } else {
                this.currentMast.setAspectEnabled(entry.getKey());
            }
            this.currentMast.setOutputForAppearance(entry.getKey(), this.aspectEventIDs.get(entry.getKey()).getText());
        }
        this.currentMast.setLitEventId(this.litEventID.getText());
        this.currentMast.setNotLitEventId(this.notLitEventID.getText());
        this.currentMast.setHeldEventId(this.heldEventID.getText());
        this.currentMast.setNotHeldEventId(this.notHeldEventID.getText());
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        return true;
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        public boolean isAvailable() {
            for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
                if (!(memo instanceof CanSystemConnectionMemo)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("OlcbSignalMastPane");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new OlcbSignalMastAddPane();
        }
    }
}

