/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing;

import javax.swing.JLabel;
import javax.swing.Timer;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.util.ThreadingUtil;

public class TrafficStatusLabel
extends JLabel
implements CanListener {
    private static final int INTERVAL = 200;
    CanSystemConnectionMemo memo;
    Timer timer;
    boolean active;

    public TrafficStatusLabel(CanSystemConnectionMemo memo) {
        super("Active");
        this.setEnabled(false);
        this.memo = memo;
        this.active = false;
        memo.getTrafficController().addCanConsoleListener(this);
        this.displayActive();
    }

    void traffic() {
        this.timer.stop();
        this.active = true;
        this.displayActive();
    }

    void displayActive() {
        if (this.active != this.isEnabled()) {
            this.setEnabled(this.active);
        }
        this.timer = ThreadingUtil.runOnLayoutDelayed(() -> {
            this.active = false;
            this.displayActive();
        }, 200);
    }

    @Override
    public synchronized void message(CanMessage l) {
        this.traffic();
    }

    @Override
    public synchronized void reply(CanReply l) {
        this.traffic();
    }
}

