/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.downloader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.MemoryContents;
import jmri.jmrix.AbstractLoaderPane;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.DropCdiCache;
import jmri.jmrix.openlcb.swing.downloader.Bundle;
import jmri.jmrix.openlcb.swing.downloader.LoaderAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WrapLayout;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.openlcb.Connection;
import org.openlcb.LoaderClient;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.MemorySpaceSelector;
import org.openlcb.swing.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderPane
extends AbstractLoaderPane
implements CanPanelInterface {
    protected CanSystemConnectionMemo memo;
    Connection connection;
    MemoryConfigurationService mcs;
    DatagramService dcs;
    MimicNodeStore store;
    NodeSelector nodeSelector;
    JPanel selectorPane;
    MemorySpaceSelector spaceField;
    JCheckBox lockNode;
    LoaderClient loaderClient;
    NodeID nid;
    OlcbInterface iface;
    byte[] fdata;
    private static final Logger log = LoggerFactory.getLogger(LoaderPane.class);

    public String getTitle(String menuTitle) {
        return Bundle.getMessage("TitleLoader");
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        this.connection = memo.get(Connection.class);
        this.mcs = memo.get(MemoryConfigurationService.class);
        this.dcs = memo.get(DatagramService.class);
        this.store = memo.get(MimicNodeStore.class);
        this.nodeSelector = new NodeSelector(this.store, Integer.MAX_VALUE);
        this.loaderClient = memo.get(LoaderClient.class);
        this.nid = memo.get(NodeID.class);
        this.iface = memo.get(OlcbInterface.class);
        this.loadButton.setText("Load");
        this.loadButton.setToolTipText("Start Load Process");
        JPanel p = new JPanel();
        p.setLayout(new WrapLayout());
        p.add(new JLabel("Target Node ID: "));
        p.add((Component)this.nodeSelector);
        this.selectorPane.add(p);
        p = new JPanel();
        p.setLayout(new WrapLayout());
        p.add(new JLabel("Address Space: "));
        this.spaceField = new MemorySpaceSelector(239);
        p.add((Component)this.spaceField);
        this.selectorPane.add(p);
        this.spaceField.setToolTipText("The number of the address space, e.g. 239 or 0xEF");
        p = new JPanel();
        p.setLayout(new WrapLayout());
        this.lockNode = new JCheckBox("Lock Node");
        p.add(this.lockNode);
        this.selectorPane.add(p);
        this.verifyButton.setVisible(false);
    }

    @Override
    protected void addChooserFilters(JFileChooser chooser) {
    }

    @Override
    public void doRead(JFileChooser chooser) {
        if (chooser == null || chooser.getSelectedFile() == null) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        this.readFile(fn);
        this.bar.setValue(0);
        this.loadButton.setEnabled(true);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.downloader.LoaderFrame";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return this.memo.getUserName() + " Firmware Downloader";
        }
        return this.getTitle(Bundle.getMessage("TitleLoader"));
    }

    @Override
    protected void addOptionsPanel() {
        this.selectorPane = new JPanel();
        this.selectorPane.setLayout(new BoxLayout(this.selectorPane, 1));
        this.add(this.selectorPane);
    }

    @Override
    protected void handleOptionsInFileContent(MemoryContents inputContent) {
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        DropCdiCache.drop(this.destNodeID(), this.memo.get(OlcbInterface.class));
        this.setOperationAborted(false);
        int ispace = this.spaceField.getMemorySpace();
        long addr = 0L;
        this.loaderClient.doLoad(this.nid, this.destNodeID(), ispace, addr, this.fdata, new LoaderClient.LoaderStatusReporter(){

            public void onProgress(float percent) {
                LoaderPane.this.updateGUI(Math.round(percent));
            }

            @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="message String also used in status JLabel")
            public void onDone(int errorCode, String errorString) {
                if (errorCode == 0) {
                    LoaderPane.this.updateGUI(100);
                    if (errorString.isEmpty()) {
                        LoaderPane.this.status.setText(Bundle.getMessage("StatusDownloadOk"));
                    } else {
                        LoaderPane.this.status.setText(Bundle.getMessage("StatusDownloadOkWithMessage", errorString));
                    }
                    LoaderPane.this.setOperationAborted(false);
                } else {
                    String msg = Bundle.getMessage("StatusDownloadFailed", Integer.toHexString(errorCode), errorString);
                    LoaderPane.this.status.setText(msg);
                    LoaderPane.this.setOperationAborted(true);
                    log.info(msg);
                }
                LoaderPane.this.enableDownloadVerifyButtons();
            }
        });
    }

    void updateGUI(int value) {
        SwingUtilities.invokeLater(() -> {
            log.debug("updateGUI with {}", (Object)value);
            this.bar.setValue(value);
        });
    }

    NodeID destNodeID() {
        return this.nodeSelector.getSelectedNodeID();
    }

    void setDestNodeID(NodeID nodeID) {
        this.nodeSelector.setSelectedNodeID(nodeID);
    }

    @Override
    protected void setDefaultFieldValues() {
        log.debug("setDefaultFieldValues leaves fields unchanged");
    }

    public void readFile(String filename) {
        File file = new File(filename);
        try (FileInputStream fis = new FileInputStream(file);){
            int content;
            log.info("Total file size to read (in bytes) : {}", (Object)fis.available());
            this.fdata = new byte[fis.available()];
            int i = 0;
            while ((content = fis.read()) != -1) {
                this.fdata[i++] = (byte)content;
            }
        }
        catch (IOException e) {
            log.error("Unable to read {}", (Object)filename, (Object)e);
        }
    }

    @Override
    protected boolean parametersAreValid() {
        return true;
    }

    public static class Default
    extends CanNamedPaneAction {
        NodeID nodeID;

        public Default() {
            super("LCC Firmware Download", new JmriJFrameInterface(), LoaderAction.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }

        public Default(NodeID nodeID) {
            super("LCC Firmware Download", new JmriJFrameInterface(), LoaderPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
            this.nodeID = nodeID;
        }

        @Override
        public JmriPanel makePanel() {
            LoaderPane panel = (LoaderPane)super.makePanel();
            panel.setDestNodeID(this.nodeID);
            return panel;
        }
    }
}

