/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.eventtable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.OlcbEventNameStore;
import jmri.jmrix.openlcb.OlcbNodeGroupStore;
import jmri.jmrix.openlcb.OlcbSensor;
import jmri.jmrix.openlcb.OlcbTurnout;
import jmri.jmrix.openlcb.swing.eventtable.Bundle;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.SystemType;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.MultiLineCellRenderer;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.WrapLayout;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.ConsumerRangeIdentifiedMessage;
import org.openlcb.EventID;
import org.openlcb.IdentifyEventsAddressedMessage;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.ProducerRangeIdentifiedMessage;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.implementations.EventTable;
import org.openlcb.swing.EventIdTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTablePane
extends JmriPanel
implements CanPanelInterface {
    protected CanSystemConnectionMemo memo;
    Connection connection;
    NodeID nid;
    OlcbEventNameStore nameStore;
    OlcbNodeGroupStore groupStore;
    MimicNodeStore mimcStore;
    EventTableDataModel model;
    JTable table;
    Monitor monitor;
    JComboBox<String> matchGroupName;
    JCheckBox showRequiresLabel;
    JCheckBox showRequiresMatch;
    JCheckBox popcorn;
    JFormattedTextField findID;
    JTextField findTextID;
    private transient TableRowSorter<EventTableDataModel> sorter;
    static JFileChooser fileChooser = null;
    private static final Logger log = LoggerFactory.getLogger(EventTablePane.class);

    public String getTitle(String menuTitle) {
        return Bundle.getMessage("TitleEventTable");
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        this.connection = memo.get(Connection.class);
        this.nid = memo.get(NodeID.class);
        this.nameStore = memo.get(OlcbEventNameStore.class);
        this.groupStore = InstanceManager.getDefault(OlcbNodeGroupStore.class);
        this.mimcStore = memo.get(MimicNodeStore.class);
        EventTable stdEventTable = memo.get(OlcbInterface.class).getEventTable();
        if (stdEventTable == null) {
            log.warn("no OLCB EventTable found");
        }
        this.model = new EventTableDataModel(this.mimcStore, stdEventTable, this.nameStore);
        this.sorter = new TableRowSorter<EventTableDataModel>(this.model);
        this.setLayout(new BoxLayout(this, 1));
        this.model.table = this.table = new JTable(this.model);
        this.model.sorter = this.sorter;
        this.table.setAutoCreateRowSorter(true);
        this.table.setRowSorter(this.sorter);
        this.table.setDefaultRenderer(String.class, new MultiLineCellRenderer());
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.BLACK);
        this.table.getTableHeader().setBackground(Color.LIGHT_GRAY);
        this.table.setName("jmri.jmrix.openlcb.swing.eventtable.EventTablePane.table");
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        Font defaultFont = this.table.getFont();
        Font fixedFont = new Font("Monospaced", 0, defaultFont.getSize());
        this.table.setFont(fixedFont);
        JScrollPane scrollPane = new JScrollPane(this.table);
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> {
            tpm.resetState(this.table);
            tpm.persist(this.table);
        });
        this.add(scrollPane);
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setLayout(new WrapLayout());
        this.add(buttonPanel);
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        updateButton.addActionListener(this::sendRequestEvents);
        updateButton.setToolTipText("Query the network and load results into the table");
        buttonPanel.add(updateButton);
        this.matchGroupName = new JComboBox();
        this.updateMatchGroupName();
        this.matchGroupName.addActionListener(e -> this.filter());
        this.groupStore.addPropertyChangeListener(evt -> this.updateMatchGroupName());
        buttonPanel.add(this.matchGroupName);
        this.showRequiresLabel = new JCheckBox(Bundle.getMessage("BoxShowRequiresLabel"));
        this.showRequiresLabel.addActionListener(e -> this.filter());
        this.showRequiresLabel.setToolTipText("When checked, only events that you've given names will be shown");
        buttonPanel.add(this.showRequiresLabel);
        this.showRequiresMatch = new JCheckBox(Bundle.getMessage("BoxShowRequiresMatch"));
        this.showRequiresMatch.addActionListener(e -> this.filter());
        this.showRequiresMatch.setToolTipText("When checked, only events with both producers and consumers will be shown.");
        buttonPanel.add(this.showRequiresMatch);
        this.popcorn = new JCheckBox(Bundle.getMessage("BoxPopcorn"));
        this.popcorn.addActionListener(e -> this.popcornButtonChanged());
        buttonPanel.add(this.popcorn);
        JPanel findpanel = new JPanel();
        findpanel.setToolTipText("This finds matches in the Event ID column");
        buttonPanel.add(findpanel);
        JLabel find = new JLabel("Find Event: ");
        findpanel.add(find);
        this.findID = new EventIdTextField();
        this.findID.addActionListener(this::findRequested);
        this.findID.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                log.trace("keyTyped {} content {}", (Object)keyEvent.getKeyCode(), (Object)EventTablePane.this.findTextID.getText());
                EventTablePane.this.findRequested(null);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        findpanel.add(this.findID);
        JButton addButton = new JButton("Add");
        addButton.addActionListener(this::addRequested);
        addButton.setToolTipText("This adds the EventID to the left into the table.  Use when you don't find an event ID you want to name.");
        findpanel.add(addButton);
        findpanel = new JPanel();
        findpanel.setToolTipText("This finds matches in the event name, producer node name, consumer node name and also-known-as columns");
        buttonPanel.add(findpanel);
        JLabel findText = new JLabel("Find Name: ");
        findpanel.add(findText);
        this.findTextID = new JTextField(16);
        this.findTextID.addActionListener(this::findTextRequested);
        this.findTextID.setToolTipText("This finds matches in the event name, producer node name, consumer node name and also-known-as columns");
        this.findTextID.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                log.trace("keyTyped {} content {}", (Object)keyEvent.getKeyCode(), (Object)EventTablePane.this.findTextID.getText());
                EventTablePane.this.findTextRequested(null);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        findpanel.add(this.findTextID);
        JButton sensorButton = new JButton("Names from Sensors");
        sensorButton.addActionListener(this::sensorRequested);
        sensorButton.setToolTipText("This fills empty cells in the event name column from JMRI Sensor names");
        buttonPanel.add(sensorButton);
        JButton turnoutButton = new JButton("Names from Turnouts");
        turnoutButton.addActionListener(this::turnoutRequested);
        turnoutButton.setToolTipText("This fills empty cells in the event name column from JMRI Turnout names");
        buttonPanel.add(turnoutButton);
        buttonPanel.setMaximumSize(buttonPanel.getPreferredSize());
        this.monitor = new Monitor(this.model);
        memo.get(OlcbInterface.class).registerMessageListener((Connection)this.monitor);
    }

    protected void updateMatchGroupName() {
        this.matchGroupName.removeAllItems();
        this.matchGroupName.addItem("(All Groups)");
        List<String> list = this.groupStore.getGroupNames();
        for (String group : list) {
            this.matchGroupName.addItem(group);
        }
        this.matchGroupName.setVisible(this.matchGroupName.getItemCount() > 1);
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.table));
        this.memo.get(OlcbInterface.class).unRegisterMessageListener((Connection)this.monitor);
        this.model = null;
        this.monitor = null;
        super.dispose();
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> retval = new ArrayList<JMenu>();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem csvWriteItem = new JMenuItem("Save to CSV...", 83);
        KeyStroke ctrlSKeyStroke = KeyStroke.getKeyStroke("control S");
        if (SystemType.isMacOSX()) {
            ctrlSKeyStroke = KeyStroke.getKeyStroke("meta S");
        }
        csvWriteItem.setAccelerator(ctrlSKeyStroke);
        csvWriteItem.addActionListener(this::writeToCsvFile);
        fileMenu.add(csvWriteItem);
        JMenuItem csvReadItem = new JMenuItem("Read from CSV...", 79);
        KeyStroke ctrlOKeyStroke = KeyStroke.getKeyStroke("control O");
        if (SystemType.isMacOSX()) {
            ctrlOKeyStroke = KeyStroke.getKeyStroke("meta O");
        }
        csvReadItem.setAccelerator(ctrlOKeyStroke);
        csvReadItem.addActionListener(this::readFromCsvFile);
        fileMenu.add(csvReadItem);
        retval.add(fileMenu);
        return retval;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.eventtable.EventTablePane";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return this.memo.getUserName() + " Event Table";
        }
        return this.getTitle(Bundle.getMessage("TitleEventTable"));
    }

    public void sendRequestEvents(ActionEvent e) {
        this.model.clear();
        this.model.loadIdTagEventIDs();
        this.model.handleTableUpdate(-1, -1);
        int IDENTIFY_EVENTS_DELAY = 125;
        int nextDelay = 0;
        for (MimicNodeStore.NodeMemo memo : this.mimcStore.getNodeMemos()) {
            ThreadingUtil.runOnLayoutDelayed(() -> {
                NodeID destNodeID = memo.getNodeID();
                log.trace("send IdentifyEventsAddressedMessage {} {}", (Object)this.nid, (Object)destNodeID);
                IdentifyEventsAddressedMessage m = new IdentifyEventsAddressedMessage(this.nid, destNodeID);
                this.connection.put((Message)m, null);
            }, nextDelay);
            nextDelay += 125;
        }
        int REFRESH_INTERVAL = 1000;
        ThreadingUtil.runOnGUIDelayed(() -> this.model.handleTableUpdate(-1, -1), nextDelay + 1000);
        ThreadingUtil.runOnGUIDelayed(() -> this.model.handleTableUpdate(-1, -1), nextDelay + 2000);
        ThreadingUtil.runOnGUIDelayed(() -> this.model.handleTableUpdate(-1, -1), nextDelay + 4000);
    }

    void popcornButtonChanged() {
        this.model.popcornModeActive = this.popcorn.isSelected();
        log.debug("Popcorn mode {}", (Object)this.model.popcornModeActive);
    }

    public void findRequested(ActionEvent e) {
        String text = this.findID.getText();
        text = text.strip().replaceAll("(.00)*$", "");
        log.debug("Request find event [{}]", (Object)text);
        this.table.clearSelection();
        if (this.findTextSearch(text, 0)) {
            return;
        }
    }

    public void findTextRequested(ActionEvent e) {
        String text = this.findTextID.getText();
        log.debug("Request find text {}", (Object)text);
        this.table.clearSelection();
        if (this.findTextSearch(text, 1)) {
            return;
        }
        if (this.findTextSearch(text, 6)) {
            return;
        }
        if (this.findTextSearch(text, 3)) {
            return;
        }
        if (this.findTextSearch(text, 5)) {
            return;
        }
    }

    protected boolean findTextSearch(String text, int column) {
        text = text.toUpperCase();
        try {
            for (int row = 0; row < this.model.getRowCount(); ++row) {
                String value;
                Object cell = this.table.getValueAt(row, column);
                if (cell == null || !(value = cell.toString().toUpperCase()).startsWith(text)) continue;
                this.table.changeSelection(row, column, false, false);
                return true;
            }
        }
        catch (RuntimeException e) {
            log.debug("unexpected AIOOBE");
        }
        return false;
    }

    public void addRequested(ActionEvent e) {
        String text = this.findID.getText();
        EventID eventID = new EventID(text);
        EventTableDataModel.TripleMemo memo = new EventTableDataModel.TripleMemo(eventID, "", null, "", null, "");
        boolean found = false;
        for (EventTableDataModel.TripleMemo check : EventTableDataModel.memos) {
            if (!memo.eventID.equals((Object)check.eventID)) continue;
            found = true;
            break;
        }
        if (!found) {
            EventTableDataModel.memos.add(memo);
        }
        this.model.fireTableDataChanged();
        this.findRequested(e);
    }

    public void sensorRequested(ActionEvent e) {
        SortedSet beans = InstanceManager.getDefault(SensorManager.class).getNamedBeanSet();
        for (NamedBean bean : beans) {
            if (!(bean instanceof OlcbSensor)) continue;
            this.oneSensorToTag(true, bean);
            this.oneSensorToTag(false, bean);
        }
    }

    private void oneSensorToTag(boolean isActive, NamedBean bean) {
        OlcbSensor sensor = (OlcbSensor)bean;
        EventID sensorID = sensor.getEventID(isActive);
        if (!this.isEventNamePresent(sensorID)) {
            this.nameStore.addMatch(sensorID, sensor.getEventName(isActive));
        }
    }

    public void turnoutRequested(ActionEvent e) {
        SortedSet beans = InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet();
        for (NamedBean bean : beans) {
            if (!(bean instanceof OlcbTurnout)) continue;
            this.oneTurnoutToTag(true, bean);
            this.oneTurnoutToTag(false, bean);
        }
    }

    private void oneTurnoutToTag(boolean isThrown, NamedBean bean) {
        OlcbTurnout turnout = (OlcbTurnout)bean;
        EventID turnoutID = turnout.getEventID(isThrown);
        if (!this.isEventNamePresent(turnoutID)) {
            this.nameStore.addMatch(turnoutID, turnout.getEventName(isThrown));
        }
    }

    public void writeToCsvFile(ActionEvent e) {
        if (fileChooser == null) {
            fileChooser = new JmriJFileChooser();
        }
        fileChooser.setDialogTitle("Save CSV file");
        fileChooser.rescanCurrentDirectory();
        fileChooser.setSelectedFile(new File("eventtable.csv"));
        int retVal = fileChooser.showSaveDialog(this);
        if (retVal == 0) {
            File file = fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to export to CSV file {}", (Object)file);
            }
            try (CSVPrinter str = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CSVFormat.DEFAULT);){
                str.printRecord(new Object[]{"Event ID", "Event Name", "Producer Node", "Producer Node Name", "Consumer Node", "Consumer Node Name", "Paths"});
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    String[] contexts;
                    str.print(this.model.getValueAt(i, 0));
                    str.print(this.model.getValueAt(i, 1));
                    str.print(this.model.getValueAt(i, 2));
                    str.print(this.model.getValueAt(i, 3));
                    str.print(this.model.getValueAt(i, 4));
                    str.print(this.model.getValueAt(i, 5));
                    for (String context : contexts = this.model.getValueAt(i, 6).toString().split("\n")) {
                        str.print((Object)context);
                    }
                    str.println();
                }
                str.flush();
            }
            catch (IOException ex) {
                log.error("Error writing file", (Throwable)ex);
            }
        }
    }

    public void readFromCsvFile(ActionEvent e) {
        if (fileChooser == null) {
            fileChooser = new JmriJFileChooser();
        }
        fileChooser.setDialogTitle("Open CSV file");
        fileChooser.rescanCurrentDirectory();
        int retVal = fileChooser.showOpenDialog(this);
        if (retVal == 0) {
            File file = fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to read from CSV file {}", (Object)file);
            }
            try (FileReader in = new FileReader(file);){
                CSVParser records = CSVFormat.RFC4180.parse((Reader)in);
                for (CSVRecord record : records) {
                    EventID eid;
                    String eventIDname = record.get(0);
                    try {
                        eid = new EventID(eventIDname);
                    }
                    catch (IllegalArgumentException e1) {
                        log.warn("Column 0 doesn't contain an EventID: {}", (Object)eventIDname);
                        continue;
                    }
                    if (this.isEventNamePresent(eid)) continue;
                    String eventName = record.get(1);
                    this.nameStore.addMatch(eid, eventName);
                }
                log.debug("File reading complete");
                this.model.fireTableDataChanged();
            }
            catch (IOException ex) {
                log.error("Error reading file", (Throwable)ex);
            }
        }
    }

    public boolean isEventNamePresent(EventID eventID) {
        return this.nameStore.hasEventName(eventID);
    }

    private void filter() {
        RowFilter<EventTableDataModel, Integer> rf = new RowFilter<EventTableDataModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends EventTableDataModel, ? extends Integer> entry) {
                int row = entry.getIdentifier();
                Object name = EventTablePane.this.model.getValueAt(row, 1);
                if (EventTablePane.this.showRequiresLabel.isSelected() && (name == null || name.toString().isEmpty())) {
                    return false;
                }
                if (EventTablePane.this.showRequiresMatch.isSelected()) {
                    EventTableDataModel.TripleMemo memo = EventTablePane.this.model.getTripleMemo(row);
                    if (memo.producer == null && !EventTablePane.this.model.producerPresent(memo.eventID)) {
                        return false;
                    }
                    if (memo.consumer == null && !EventTablePane.this.model.consumerPresent(memo.eventID)) {
                        return false;
                    }
                }
                if (EventTablePane.this.matchGroupName.getSelectedIndex() > 0) {
                    String group = EventTablePane.this.matchGroupName.getSelectedItem().toString();
                    EventTableDataModel.TripleMemo memo = EventTablePane.this.model.getTripleMemo(row);
                    if (!EventTablePane.this.groupStore.isNodeInGroup(memo.producer, group) && !EventTablePane.this.groupStore.isNodeInGroup(memo.consumer, group)) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.sorter.setRowFilter(rf);
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super("LCC Event Table", new JmriJFrameInterface(), EventTablePane.class.getName(), InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
        }

        public Default(String name, WindowInterface iface) {
            super(name, iface, EventTablePane.class.getName(), InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
        }

        public Default(String name, Icon icon, WindowInterface iface) {
            super(name, icon, iface, EventTablePane.class.getName(), InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
        }
    }

    static class Monitor
    extends MessageDecoder {
        EventTableDataModel model;

        Monitor(EventTableDataModel model) {
            this.model = model;
        }

        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            ThreadingUtil.runOnGUIEventually(() -> {
                NodeID nodeID = msg.getSourceNodeID();
                EventID eventID = msg.getEventID();
                this.model.recordProducer(eventID, nodeID, "");
                this.model.highlightProducer(eventID, nodeID);
            });
        }

        public void handleConsumerIdentified(ConsumerIdentifiedMessage msg, Connection sender) {
            ThreadingUtil.runOnGUIEventually(() -> {
                NodeID nodeID = msg.getSourceNodeID();
                EventID eventID = msg.getEventID();
                this.model.recordConsumer(eventID, nodeID, "");
            });
        }

        public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
            ThreadingUtil.runOnGUIEventually(() -> {
                NodeID nodeID = msg.getSourceNodeID();
                EventID eventID = msg.getEventID();
                this.model.recordProducer(eventID, nodeID, "");
            });
        }

        public void handleConsumerRangeIdentified(ConsumerRangeIdentifiedMessage msg, Connection sender) {
            ThreadingUtil.runOnGUIEventually(() -> {
                NodeID nodeID = msg.getSourceNodeID();
                EventID eventID = msg.getEventID();
                long rangeSuffix = eventID.rangeSuffix();
                EventID zeroedEID = new EventID(eventID.toLong() & (rangeSuffix ^ 0xFFFFFFFFFFFFFFFFL));
                this.model.recordConsumer(zeroedEID, nodeID, new EventID(eventID.toLong() | rangeSuffix).toShortString());
            });
        }

        public void handleProducerRangeIdentified(ProducerRangeIdentifiedMessage msg, Connection sender) {
            ThreadingUtil.runOnGUIEventually(() -> {
                NodeID nodeID = msg.getSourceNodeID();
                EventID eventID = msg.getEventID();
                long rangeSuffix = eventID.rangeSuffix();
                EventID zeroedEID = new EventID(eventID.toLong() & (rangeSuffix ^ 0xFFFFFFFFFFFFFFFFL));
                this.model.recordProducer(zeroedEID, nodeID, new EventID(eventID.toLong() | rangeSuffix).toShortString());
            });
        }
    }

    protected static class EventTableDataModel
    extends AbstractTableModel {
        static final int COL_EVENTID = 0;
        static final int COL_EVENTNAME = 1;
        static final int COL_PRODUCER_NODE = 2;
        static final int COL_PRODUCER_NAME = 3;
        static final int COL_CONSUMER_NODE = 4;
        static final int COL_CONSUMER_NAME = 5;
        static final int COL_CONTEXT_INFO = 6;
        static final int COL_COUNT = 7;
        MimicNodeStore store;
        EventTable stdEventTable;
        OlcbEventNameStore nameStore;
        IdTagManager tagManager;
        JTable table;
        TableRowSorter<EventTableDataModel> sorter;
        boolean popcornModeActive = false;
        int lineIncrement = -1;
        static ArrayList<TripleMemo> memos = new ArrayList();
        boolean pending = false;

        EventTableDataModel(MimicNodeStore store, EventTable stdEventTable, OlcbEventNameStore nameStore) {
            this.store = store;
            this.stdEventTable = stdEventTable;
            this.nameStore = nameStore;
            this.loadIdTagEventIDs();
        }

        TripleMemo getTripleMemo(int row) {
            if (row >= memos.size()) {
                return null;
            }
            return memos.get(row);
        }

        void loadIdTagEventIDs() {
            for (EventID eventID : this.nameStore.getMatches()) {
                TripleMemo memo = new TripleMemo(eventID, "", null, "", null, "");
                boolean found = false;
                for (TripleMemo check : memos) {
                    if (!memo.eventID.equals((Object)check.eventID)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                memos.add(memo);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= memos.size()) {
                log.warn("request out of range: {} greater than {}", (Object)row, (Object)memos.size());
                return "Illegal col " + row + " " + col;
            }
            TripleMemo memo = memos.get(row);
            switch (col) {
                case 0: {
                    Object retval = memo.eventID.toShortString();
                    if (!memo.rangeSuffix.isEmpty()) {
                        retval = (String)retval + " - " + memo.rangeSuffix;
                    }
                    return retval;
                }
                case 1: {
                    if (this.nameStore.hasEventName(memo.eventID)) {
                        return this.nameStore.getEventName(memo.eventID);
                    }
                    return "";
                }
                case 2: {
                    return memo.producer != null ? memo.producer.toString() : "";
                }
                case 3: {
                    return memo.producerName;
                }
                case 4: {
                    return memo.consumer != null ? memo.consumer.toString() : "";
                }
                case 5: {
                    return memo.consumerName;
                }
                case 6: {
                    int viewRow = this.sorter.convertRowIndexToView(row);
                    if (this.lineIncrement <= 0) {
                        this.lineIncrement = viewRow >= 0 ? this.table.getRowHeight(viewRow) : this.table.getFont().getSize() * 13 / 10;
                    }
                    StringBuilder result = new StringBuilder();
                    int height = this.lineIncrement / 3;
                    boolean first = true;
                    String interp = memo.eventID.parse();
                    if (interp != null && !interp.isEmpty()) {
                        height += this.lineIncrement;
                        result.append(interp);
                        first = false;
                    }
                    for (EventTable.EventTableEntry entry : this.stdEventTable.getEventInfo(memo.eventID).getAllEntries()) {
                        if (!first) {
                            result.append("\n");
                        }
                        first = false;
                        height += this.lineIncrement;
                        result.append(entry.getDescription());
                    }
                    if (viewRow >= 0) {
                        if (height < this.lineIncrement) {
                            height += this.lineIncrement;
                        }
                        this.table.setRowHeight(viewRow, height);
                    } else {
                        this.lineIncrement = -1;
                    }
                    return new String(result);
                }
            }
            return "Illegal row " + row + " " + col;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col != 1) {
                return;
            }
            if (row >= memos.size()) {
                log.warn("request out of range: {} greater than {}", (Object)row, (Object)memos.size());
                return;
            }
            TripleMemo memo = memos.get(row);
            this.nameStore.addMatch(memo.eventID, value.toString());
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Event ID";
                }
                case 1: {
                    return "Event Name";
                }
                case 2: {
                    return "Producer Node";
                }
                case 3: {
                    return "Producer Node Name";
                }
                case 4: {
                    return "Consumer Node";
                }
                case 5: {
                    return "Consumer Node Name";
                }
                case 6: {
                    return "Also Known As";
                }
            }
            return "ERROR " + col;
        }

        @Override
        public int getRowCount() {
            return memos.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
        void clear() {
            memos = new ArrayList();
            this.fireTableDataChanged();
        }

        void handleTableUpdate(int start, int end) {
            log.trace("handleTableUpdated");
            int DELAY = 500;
            if (!this.pending) {
                ThreadingUtil.runOnGUIDelayed(() -> {
                    this.pending = false;
                    log.debug("handleTableUpdated fires table changed");
                    this.fireTableDataChanged();
                }, 500);
                this.pending = true;
            }
        }

        void recordProducer(EventID eventID, NodeID nodeID, String rangeSuffix) {
            SimpleNodeIdent ident;
            log.debug("recordProducer of {} in {}", (Object)eventID, (Object)nodeID);
            if (memos.size() <= 1) {
                this.handleTableUpdate(-1, -1);
            }
            MimicNodeStore.NodeMemo nodeMemo = this.store.findNode(nodeID);
            Object name = "";
            if (nodeMemo != null && (ident = nodeMemo.getSimpleNodeIdent()) != null && ((String)(name = ident.getUserName())).isEmpty()) {
                name = ident.getMfgName() + " - " + ident.getModelName() + " - " + ident.getHardwareVersion();
            }
            TripleMemo empty = null;
            TripleMemo bestEmpty = null;
            TripleMemo sameNodeID = null;
            for (int i = 0; i < memos.size(); ++i) {
                TripleMemo memo = memos.get(i);
                if (!memo.eventID.equals((Object)eventID) || !memo.rangeSuffix.equals(rangeSuffix)) continue;
                if (nodeID.equals((Object)memo.producer)) {
                    if (!this.popcornModeActive) {
                        this.handleTableUpdate(i, i);
                    }
                    return;
                }
                if (memo.producer == null) {
                    empty = memo;
                    if (nodeID.equals((Object)memo.consumer)) {
                        bestEmpty = memo;
                    }
                }
                if (nodeID != memo.consumer) continue;
                sameNodeID = memo;
            }
            if (bestEmpty != null) {
                log.trace("   use bestEmpty");
                bestEmpty.producer = nodeID;
                bestEmpty.producerName = name;
                this.handleTableUpdate(-1, -1);
                return;
            }
            if (empty != null && sameNodeID == null) {
                log.trace("   reuse empty");
                empty.producer = nodeID;
                empty.producerName = name;
                this.handleTableUpdate(-1, -1);
                return;
            }
            if (sameNodeID != null) {
                log.trace("   switch to sameID");
                NodeID fromSaveNodeID = sameNodeID.producer;
                String fromSaveNodeIDName = sameNodeID.producerName;
                sameNodeID.producer = nodeID;
                sameNodeID.producerName = name;
                nodeID = fromSaveNodeID;
                name = fromSaveNodeIDName;
            }
            TripleMemo memo = new TripleMemo(eventID, rangeSuffix, nodeID, (String)name, null, "");
            memos.add(memo);
            this.handleTableUpdate(memos.size() - 1, memos.size() - 1);
        }

        void recordConsumer(EventID eventID, NodeID nodeID, String rangeSuffix) {
            SimpleNodeIdent ident;
            log.debug("recordConsumer of {} in {}", (Object)eventID, (Object)nodeID);
            if (memos.size() <= 1) {
                this.handleTableUpdate(-1, -1);
            }
            MimicNodeStore.NodeMemo nodeMemo = this.store.findNode(nodeID);
            Object name = "";
            if (nodeMemo != null && (ident = nodeMemo.getSimpleNodeIdent()) != null && ((String)(name = ident.getUserName())).isEmpty()) {
                name = ident.getMfgName() + " - " + ident.getModelName() + " - " + ident.getHardwareVersion();
            }
            TripleMemo empty = null;
            TripleMemo bestEmpty = null;
            TripleMemo sameNodeID = null;
            for (int i = 0; i < memos.size(); ++i) {
                TripleMemo memo = memos.get(i);
                if (!memo.eventID.equals((Object)eventID) || !memo.rangeSuffix.equals(rangeSuffix)) continue;
                if (nodeID.equals((Object)memo.consumer)) {
                    log.trace("    nodeDI == memo.consumer");
                    this.handleTableUpdate(i, i);
                    return;
                }
                if (memo.consumer == null) {
                    empty = memo;
                    if (nodeID.equals((Object)memo.producer)) {
                        bestEmpty = memo;
                    }
                }
                if (nodeID != memo.producer) continue;
                sameNodeID = memo;
            }
            if (bestEmpty != null) {
                log.trace("   use bestEmpty");
                bestEmpty.consumer = nodeID;
                bestEmpty.consumerName = name;
                this.handleTableUpdate(-1, -1);
                return;
            }
            if (empty != null && sameNodeID == null) {
                log.trace("   reuse empty");
                empty.consumer = nodeID;
                empty.consumerName = name;
                this.handleTableUpdate(-1, -1);
                return;
            }
            if (sameNodeID != null) {
                log.trace("   switch to sameID");
                NodeID fromSaveNodeID = sameNodeID.consumer;
                String fromSaveNodeIDName = sameNodeID.consumerName;
                sameNodeID.consumer = nodeID;
                sameNodeID.consumerName = name;
                nodeID = fromSaveNodeID;
                name = fromSaveNodeIDName;
            }
            log.trace("    make a new one");
            TripleMemo memo = new TripleMemo(eventID, rangeSuffix, null, "", nodeID, (String)name);
            memos.add(memo);
            this.handleTableUpdate(memos.size() - 1, memos.size() - 1);
        }

        void highlightProducer(EventID eventID, NodeID nodeID) {
            if (!this.popcornModeActive) {
                return;
            }
            log.trace("highlightProducer {} {}", (Object)eventID, (Object)nodeID);
            for (int i = 0; i < memos.size(); ++i) {
                TripleMemo memo = memos.get(i);
                if (!eventID.equals((Object)memo.eventID) || !memo.rangeSuffix.equals("") || !nodeID.equals((Object)memo.producer)) continue;
                try {
                    int viewRow = this.sorter.convertRowIndexToView(i);
                    log.trace("highlight event ID {} row {} viewRow {}", new Object[]{eventID, i, viewRow});
                    if (viewRow < 0) continue;
                    this.table.changeSelection(viewRow, 2, false, false);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.trace("failed to highlight event ID {} row {}", (Object)eventID.toShortString(), (Object)i);
                }
            }
        }

        void highlightEvent(EventID eventID) {
            log.trace("highlightEvent {}", (Object)eventID);
            this.table.clearSelection();
            for (int i = 0; i < memos.size(); ++i) {
                TripleMemo memo = memos.get(i);
                if (!eventID.equals((Object)memo.eventID) || !memo.rangeSuffix.equals("")) continue;
                try {
                    int viewRow = this.sorter.convertRowIndexToView(i);
                    log.trace("highlight event ID {} row {} viewRow {}", new Object[]{eventID, i, viewRow});
                    if (viewRow < 0) continue;
                    this.table.changeSelection(viewRow, 0, true, false);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.trace("failed to highlight event ID {} row {}", (Object)eventID.toShortString(), (Object)i);
                }
            }
        }

        boolean consumerPresent(EventID eventID) {
            for (TripleMemo memo : memos) {
                if (!memo.eventID.equals((Object)eventID) || !memo.rangeSuffix.equals("") || memo.consumer == null) continue;
                return true;
            }
            return false;
        }

        boolean producerPresent(EventID eventID) {
            for (TripleMemo memo : memos) {
                if (!memo.eventID.equals((Object)eventID) || !memo.rangeSuffix.equals("") || memo.producer == null) continue;
                return true;
            }
            return false;
        }

        static class TripleMemo {
            final EventID eventID;
            final String rangeSuffix;
            NodeID producer;
            String producerName;
            NodeID consumer;
            String consumerName;

            TripleMemo(EventID eventID, String rangeSuffix, NodeID producer, String producerName, NodeID consumer, String consumerName) {
                this.eventID = eventID;
                this.rangeSuffix = rangeSuffix;
                this.producer = producer;
                this.producerName = producerName;
                this.consumer = consumer;
                this.consumerName = consumerName;
            }
        }
    }
}

