/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.hub;

import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.adapters.gridconnect.GridConnectMessage;
import jmri.jmrix.can.adapters.gridconnect.GridConnectReply;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.hub.Bundle;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import jmri.util.zeroconf.ZeroConfService;
import jmri.util.zeroconf.ZeroConfServiceManager;
import org.openlcb.hub.Hub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubPane
extends JmriPanel
implements CanListener,
CanPanelInterface {
    private final UserPreferencesManager userPreferencesManager;
    private static final String USER_SAVED = ".UserSaved";
    private static final String USER_SEND_LINE_ENDINGS = ".SendLineTermination";
    private static final String USER_REQUIRE_LINE_ENDINGS = ".RequireLineTermination";
    private boolean _send_line_endings;
    CanSystemConnectionMemo memo;
    final transient Hub hub;
    private final TextArea textArea;
    Thread t;
    ArrayList<CanReply> workingReplySet = new ArrayList();
    ArrayList<CanMessage> workingMessageSet = new ArrayList();
    private ZeroConfService _zero_conf_service;
    protected String zero_conf_addr = "_openlcb-can._tcp.local.";
    private static final Logger log = LoggerFactory.getLogger(HubPane.class);

    public HubPane() {
        this(12021);
    }

    public HubPane(int port) {
        this(port, true);
    }

    public HubPane(int port, boolean sendLineEndings) {
        this.userPreferencesManager = InstanceManager.getDefault(UserPreferencesManager.class);
        this.textArea = new TextArea();
        this._send_line_endings = this.getSendLineEndingsFromUserPref(sendLineEndings);
        this.hub = new Hub(port, sendLineEndings, this.getRequireLineEndingsFromUserPref()){

            public void notifyOwner(String line) {
                SwingUtilities.invokeLater(() -> HubPane.this.textArea.append(System.lineSeparator() + DateFormat.getDateTimeInstance().format(new Date()) + " " + line));
            }
        };
    }

    private boolean getSendLineEndingsFromUserPref(boolean defaultValue) {
        if (this.userPreferencesManager.getSimplePreferenceState(this.getClass().getName() + USER_SAVED)) {
            return this.userPreferencesManager.getSimplePreferenceState(this.getClass().getName() + USER_SEND_LINE_ENDINGS);
        }
        return defaultValue;
    }

    private boolean getRequireLineEndingsFromUserPref() {
        return this.userPreferencesManager.getSimplePreferenceState(this.getClass().getName() + USER_REQUIRE_LINE_ENDINGS);
    }

    @Override
    public void initContext(Object context) {
        log.trace("initContext");
        if (context instanceof CanSystemConnectionMemo) {
            this.initComponents((CanSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        log.trace("initComponents");
        this.memo = memo;
        this.startHubThread(this.hub.getPort());
        this.setLayout(new BorderLayout());
        this.textArea.setEditable(false);
        this.add(new JScrollPane(this.textArea));
        this.add("Center", new JScrollPane(this.textArea));
        this.textArea.append(Bundle.getMessage("HubStarted", DateFormat.getDateTimeInstance().format(new Date()), this.getTitle()));
        this.textArea.append(System.lineSeparator() + Bundle.getMessage("SendLineTermination") + " : " + this._send_line_endings);
        this.textArea.append(System.lineSeparator() + Bundle.getMessage("RequireLineTermination") + " : " + this.getRequireLineEndingsFromUserPref());
        this.addInetAddresses();
        memo.getTrafficController().addCanListener(this);
    }

    private void addInetAddresses() {
        Thread t = ThreadingUtil.newThread(() -> {
            log.trace("start addInetAddresses");
            ZeroConfServiceManager manager = InstanceManager.getDefault(ZeroConfServiceManager.class);
            Set<InetAddress> addresses = manager.getAddresses(ZeroConfServiceManager.Protocol.All, true, true);
            for (InetAddress ha : addresses) {
                String hostName;
                String hostAddress = ha.getHostAddress();
                String hostNameDup = !hostAddress.equals(hostName = ha.getHostName()) ? hostName : "";
                String isLoopBack = ha.isLoopbackAddress() ? " Loopback" : "";
                String isLinkLocal = ha.isLinkLocalAddress() ? " LinkLocal" : "";
                String port = String.valueOf(this.hub.getPort());
                ThreadingUtil.runOnGUIEventually(() -> {
                    this.textArea.append(System.lineSeparator() + Bundle.getMessage("IpAddressLine", hostNameDup, isLoopBack, isLinkLocal, hostAddress, port));
                    log.trace("    added a line");
                });
            }
            log.trace("end addInetAddresses");
        }, this.memo.getUserName() + " Hub Thread");
        t.start();
    }

    void startHubThread(int port) {
        this.t = ThreadingUtil.newThread(() -> ((Hub)this.hub).start(), this.memo.getUserName() + " Hub Thread");
        this.t.setDaemon(true);
        this.hub.addForwarder(m -> {
            if (m.source == null) {
                log.trace("not forwarding {} back to JMRI due to null source", (Object)m.line);
                return;
            }
            GridConnectReply msg = this.getBlankReply();
            byte[] bytes = m.line.getBytes(StandardCharsets.US_ASCII);
            for (int i = 0; i < m.line.length(); ++i) {
                msg.setElement(i, bytes[i]);
            }
            CanReply workingReply = msg.createReply();
            this.workingReplySet.add(workingReply);
            CanMessage result = new CanMessage(workingReply.getNumDataElements(), workingReply.getHeader());
            for (int i = 0; i < workingReply.getNumDataElements(); ++i) {
                result.setElement(i, workingReply.getElement(i));
            }
            result.setExtended(workingReply.isExtended());
            this.workingMessageSet.add(result);
            log.trace("Hub forwarder create reply {}", (Object)workingReply);
            this.memo.getTrafficController().sendCanMessage(result, null);
            this.memo.getTrafficController().distributeOneReply(workingReply, this);
        });
        this.t.start();
        log.debug("hub thread started");
        this.advertise(port);
    }

    protected void advertise(int port) {
        log.trace("start advertise");
        this._zero_conf_service = ZeroConfService.create(this.zero_conf_addr, port);
        log.trace("start publish");
        this._zero_conf_service.publish();
        log.trace("end publish and advertise");
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return Bundle.getMessage("HubControl", this.memo.getUserName());
        }
        return "LCC / OpenLCB Hub Control";
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        menuList.add(this.getLineTerminationSettingsMenu());
        return menuList;
    }

    private JMenu getLineTerminationSettingsMenu() {
        JMenu menu = new JMenu(Bundle.getMessage("LineTermination"));
        JMenuItem sendLineFeedItem = new JMenuItem(Bundle.getMessage("SendLineTermination"));
        sendLineFeedItem.addActionListener(this::showSendTerminationDialog);
        menu.add(sendLineFeedItem);
        JMenuItem requireLineFeedItem = new JMenuItem(Bundle.getMessage("RequireLineTermination"));
        requireLineFeedItem.addActionListener(this::showRequireTerminationDialog);
        menu.add(requireLineFeedItem);
        return menu;
    }

    void showSendTerminationDialog(ActionEvent e) {
        JCheckBox checkbox = new JCheckBox(Bundle.getMessage("SendLineTermination"));
        checkbox.setSelected(this._send_line_endings);
        Object[] params = new Object[]{Bundle.getMessage("LineTermSettingDialog"), checkbox};
        int result = JmriJOptionPane.showConfirmDialog(this, params, Bundle.getMessage("SendLineTermination"), 2);
        if (result == 0) {
            this._send_line_endings = checkbox.isSelected();
            this.userPreferencesManager.setSimplePreferenceState(this.getClass().getName() + USER_SAVED, true);
            this.userPreferencesManager.setSimplePreferenceState(this.getClass().getName() + USER_SEND_LINE_ENDINGS, this._send_line_endings);
        }
    }

    void showRequireTerminationDialog(ActionEvent e) {
        JCheckBox checkbox = new JCheckBox(Bundle.getMessage("RequireLineTermination"));
        checkbox.setSelected(this.getRequireLineEndingsFromUserPref());
        Object[] params = new Object[]{Bundle.getMessage("LineTermSettingDialog"), checkbox};
        int result = JmriJOptionPane.showConfirmDialog(this, params, Bundle.getMessage("RequireLineTermination"), 2);
        if (result == 0) {
            this.userPreferencesManager.setSimplePreferenceState(this.getClass().getName() + USER_REQUIRE_LINE_ENDINGS, checkbox.isSelected());
        }
    }

    @Override
    public void dispose() {
        if (this.memo != null) {
            this.memo.getTrafficController().removeCanListener(this);
        }
        if (this._zero_conf_service != null) {
            this._zero_conf_service.stop();
        }
        this.hub.dispose();
    }

    @Override
    public synchronized void message(CanMessage l) {
        if (this.workingMessageSet.contains(l)) {
            this.workingMessageSet.remove(l);
            log.debug("suppress forward of message {} from JMRI; WMS={} items", (Object)l, (Object)this.workingMessageSet.size());
            return;
        }
        GridConnectMessage gm = this.getMessageFrom(l);
        log.debug("forward message {}", (Object)gm);
        this.hub.putLine(gm.toString());
    }

    protected GridConnectMessage getMessageFrom(CanMessage m) {
        return new GridConnectMessage(m);
    }

    protected GridConnectReply getBlankReply() {
        return new GridConnectReply();
    }

    @Override
    public synchronized void reply(CanReply reply) {
        if (this.workingReplySet.contains(reply)) {
            this.workingReplySet.remove(reply);
            log.trace("suppress forward of reply {} from JMRI; WRS={} items", (Object)reply, (Object)this.workingReplySet.size());
        } else {
            GridConnectMessage gm = this.getMessageFrom(new CanMessage(reply));
            log.debug("forward reply {} from JMRI, WRS={} items", (Object)gm, (Object)this.workingReplySet.size());
            this.hub.putLine(gm.toString());
        }
    }
}

