/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.idtool;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.idtool.Bundle;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WrapLayout;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.openlcb.Connection;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.EventTable;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdToolPane
extends JmriPanel
implements CanPanelInterface {
    protected CanSystemConnectionMemo memo;
    Connection connection;
    NodeID nid;
    MimicNodeStore store;
    MemoryConfigurationService service;
    NodeSelector nodeSelector;
    static final int CHUNKSIZE = 64;
    JButton gb;
    JButton cb;
    boolean cancelled = false;
    boolean running = false;
    int space = 255;
    NodeID farID = new NodeID("0.0.0.0.0.0");
    static final int PERIOD = 250;
    MemoryConfigurationService.McsReadHandler cbr = new MemoryConfigurationService.McsReadHandler(){

        public void handleFailure(int errorCode) {
            IdToolPane.this.setRunning(false);
            if (errorCode == 4226) {
                log.debug("Stopping read due to 0x1082 status");
            }
            if (errorCode == 4225) {
                log.error("Read failed. Address space not known");
            } else {
                log.error("Read failed. Error code is {}", (Object)String.format("%04X", errorCode));
            }
        }

        public void handleReadData(NodeID dest, int readSpace, long readAddress, byte[] readData) {
            log.trace("read succeed with {} bytes at {}", (Object)readData.length, (Object)readAddress);
            if (!IdToolPane.this.cancelled) {
                ThreadingUtil.runOnLayoutDelayed(() -> IdToolPane.this.service.requestRead(IdToolPane.this.farID, IdToolPane.this.space, 0L, 64, IdToolPane.this.cbr), 250);
            } else {
                IdToolPane.this.setRunning(false);
                IdToolPane.this.cancelled = false;
                log.debug("Complete");
            }
        }
    };
    byte[] bytes = new byte[64];
    int bytesRead;
    InputStream inputStream;
    int address;
    private static final Logger log = LoggerFactory.getLogger(IdToolPane.class);

    public String getTitle(String menuTitle) {
        return Bundle.getMessage("TitleIdTool");
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        this.connection = memo.get(Connection.class);
        this.nid = memo.get(NodeID.class);
        this.store = memo.get(MimicNodeStore.class);
        EventTable stdEventTable = memo.get(OlcbInterface.class).getEventTable();
        if (stdEventTable == null) {
            log.error("no OLCB EventTable found");
            return;
        }
        this.service = memo.get(MemoryConfigurationService.class);
        this.setLayout(new BoxLayout(this, 1));
        JPanel ns = new JPanel();
        ns.setLayout(new WrapLayout());
        this.add(ns);
        this.nodeSelector = new NodeSelector(this.store, Integer.MAX_VALUE);
        ns.add((Component)this.nodeSelector);
        JPanel bb = new JPanel();
        bb.setLayout(new WrapLayout());
        this.add(bb);
        this.gb = new JButton(Bundle.getMessage("ButtonId"));
        bb.add(this.gb);
        this.gb.addActionListener(this::pushedGetButton);
        this.cb = new JButton(Bundle.getMessage("ButtonCancel"));
        bb.add(this.cb);
        this.cb.addActionListener(this::pushedCancel);
        this.setRunning(false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.idtool.IdToolPane";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return this.memo.getUserName() + " Ident Tool";
        }
        return this.getTitle(Bundle.getMessage("TitleIdTool"));
    }

    void pushedCancel(ActionEvent e) {
        if (this.running) {
            this.cancelled = true;
        }
    }

    void setRunning(boolean t) {
        if (t) {
            this.gb.setEnabled(false);
            this.cb.setEnabled(true);
        } else {
            this.gb.setEnabled(true);
            this.cb.setEnabled(false);
        }
        this.running = t;
    }

    void pushedGetButton(ActionEvent e) {
        this.setRunning(true);
        this.farID = this.nodeSelector.getSelectedNodeID();
        this.service.requestRead(this.farID, this.space, 0L, 64, this.cbr);
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super("Openlcb Ident Tool", new JmriJFrameInterface(), IdToolPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

