/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.lccpro;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.RowFilter;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.ActiveSystemsMenu;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbNodeGroupStore;
import jmri.jmrix.openlcb.swing.DropCdiCache;
import jmri.jmrix.openlcb.swing.TrafficStatusLabel;
import jmri.jmrix.openlcb.swing.lccpro.LccProFrameAction;
import jmri.jmrix.openlcb.swing.lccpro.LccProTable;
import jmri.jmrix.openlcb.swing.lccpro.LccProTableModel;
import jmri.swing.ConnectionLabel;
import jmri.swing.JTablePersistenceManager;
import jmri.swing.RowSorterUtil;
import jmri.util.HelpUtil;
import jmri.util.WindowMenu;
import jmri.util.datatransfer.RosterEntrySelection;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.WrapLayout;
import jmri.util.swing.multipane.TwoPaneTBWindow;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProtocolIdentification;
import org.openlcb.SimpleNodeIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LccProFrame
extends TwoPaneTBWindow {
    static final ArrayList<LccProFrame> frameInstances = new ArrayList();
    protected boolean allowQuit = true;
    protected JmriAbstractAction newWindowAction;
    CanSystemConnectionMemo memo;
    MimicNodeStore nodestore;
    OlcbNodeGroupStore groupStore;
    final NodeInfoPane nodeInfoPane = new NodeInfoPane();
    final NodePipPane nodePipPane = new NodePipPane();
    JLabel firstHelpLabel;
    int groupSplitPaneLocation = 0;
    boolean hideGroups = false;
    final JTextPane id = new JTextPane();
    UserPreferencesManager prefsMgr;
    final ResourceBundle rb = ResourceBundle.getBundle("apps.AppsBundle");
    final JPanel bottomPanel = new JPanel();
    JSplitPane bottomLCPanel;
    JSplitPane bottomRPanel;
    JSplitPane rosterGroupSplitPane;
    LccProTable nodetable;
    JComboBox<String> matchGroupName;
    final JLabel statusField = new JLabel();
    static final Dimension summaryPaneDim = new Dimension(0, 170);
    private static final Logger log = LoggerFactory.getLogger(LccProFrame.class);

    public LccProFrame(String name) {
        this(name, InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
    }

    public LccProFrame(String name, CanSystemConnectionMemo memo) {
        this(name, "xml/config/parts/apps/gui3/lccpro/LccProFrameMenu.xml", "xml/config/parts/apps/gui3/lccpro/LccProFrameToolBar.xml", memo);
    }

    public LccProFrame(String name, String menubarFile, String toolbarFile) {
        this(name, menubarFile, toolbarFile, InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
    }

    public LccProFrame(String name, String menubarFile, String toolbarFile, CanSystemConnectionMemo memo) {
        super(name, menubarFile, toolbarFile);
        this.memo = memo;
        if (memo == null) {
            JOptionPane.showMessageDialog(this, "LccPro requires a configured LCC or OpenLCB connection, will quit now", "LccPro", 0);
            InstanceManager.getDefault(ShutDownManager.class).shutdown();
            return;
        }
        this.nodestore = memo.get(MimicNodeStore.class);
        this.groupStore = InstanceManager.getDefault(OlcbNodeGroupStore.class);
        this.allowInFrameServlet = false;
        this.prefsMgr = InstanceManager.getDefault(UserPreferencesManager.class);
        this.setTitle(name);
        this.buildWindow();
    }

    protected void additionsToToolBar() {
        this.getToolBar().add(Box.createHorizontalGlue());
    }

    protected void allowQuit(boolean quitAllowed) {
        if (this.allowQuit != quitAllowed) {
            this.newWindowAction = null;
            this.allowQuit = quitAllowed;
        }
        this.firePropertyChange("quit", "setEnabled", (Object)this.allowQuit);
        if (!this.allowQuit) {
            this.firePropertyChange("closewindow", "setEnabled", (Object)true);
        }
    }

    JPanel bottomRight() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(2.0f);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new WrapLayout());
        searchPanel.add(new JLabel("Search Node Names:"));
        JTextField searchField = new JTextField(12){

            @Override
            public Dimension getMaximumSize() {
                Dimension size = super.getMaximumSize();
                size.height = this.getPreferredSize().height;
                return size;
            }
        };
        searchField.getDocument().putProperty("filterNewlines", Boolean.TRUE);
        searchField.addKeyListener(new KeyListener(searchField){
            final /* synthetic */ 1 val$searchField;
            {
                this.val$searchField = var2_2;
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                log.debug("keyTyped {} content {}", (Object)keyEvent.getKeyCode(), (Object)this.val$searchField.getText());
                String search = this.val$searchField.getText().toLowerCase();
                int count = LccProFrame.this.nodetable.getModel().getRowCount();
                for (int row = 0; row < count; ++row) {
                    String value = ((String)LccProFrame.this.nodetable.getTable().getValueAt(row, 0)).toLowerCase();
                    if (!value.startsWith(search)) continue;
                    log.trace("  Hit value {} on {}", (Object)value, (Object)row);
                    LccProFrame.this.nodetable.getTable().setRowSelectionInterval(row, row);
                    LccProFrame.this.nodetable.getTable().scrollRectToVisible(LccProFrame.this.nodetable.getTable().getCellRect(row, 0, true));
                    return;
                }
                LccProFrame.this.nodetable.getTable().clearSelection();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        searchPanel.add(searchField);
        panel.add(searchPanel);
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new WrapLayout());
        JLabel display = new JLabel("Display Node Groups:");
        display.setToolTipText("Use the popup menu on a node's row to define node groups");
        groupPanel.add(display);
        this.matchGroupName = new JComboBox();
        this.updateMatchGroupName();
        this.matchGroupName.addActionListener(e -> this.filter());
        this.groupStore.addPropertyChangeListener(evt -> this.updateMatchGroupName());
        groupPanel.add(this.matchGroupName);
        panel.add(groupPanel);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    protected void updateMatchGroupName() {
        this.matchGroupName.removeAllItems();
        this.matchGroupName.addItem("(All Groups)");
        List<String> list = this.groupStore.getGroupNames();
        for (String group : list) {
            this.matchGroupName.addItem(group);
        }
    }

    protected final void buildWindow() {
        this.additionsToToolBar();
        frameInstances.add(this);
        this.getTop().add(this.createTop());
        this.getBottom().setMinimumSize(summaryPaneDim);
        this.getBottom().add(this.createBottom());
        this.statusBar();
        this.systemsMenu();
        this.helpMenu(this.getMenu(), this);
        if (this.prefsMgr.getSimplePreferenceState(this.getClass().getName() + ".hideSummary")) {
            this.hideBottomPane(false);
            this.hideBottomPane(true);
        }
        PropertyChangeListener propertyChangeListener = changeEvent -> {
            JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("lastDividerLocation")) {
                int current = sourceSplitPane.getDividerLocation() + sourceSplitPane.getDividerSize();
                int panesize = (int)sourceSplitPane.getSize().getHeight();
                this.hideBottomPane = panesize - current <= 1;
            }
        };
        this.getSplitPane().addPropertyChangeListener(propertyChangeListener);
        if (frameInstances.size() > 1) {
            this.firePropertyChange("closewindow", "setEnabled", (Object)true);
            this.allowQuit(frameInstances.get(0).isAllowQuit());
        } else {
            this.firePropertyChange("closewindow", "setEnabled", (Object)false);
        }
    }

    void closeWindow(WindowEvent e) {
        this.saveWindowDetails();
        if (this.allowQuit && frameInstances.size() == 1 && !InstanceManager.getDefault(ShutDownManager.class).isShuttingDown()) {
            this.handleQuit(e);
        } else {
            frameInstances.remove(this);
            super.windowClosing(e);
            if (frameInstances.size() == 1 && this.allowQuit) {
                frameInstances.get(0).firePropertyChange("closewindow", "setEnabled", (Object)false);
            }
            this.dispose();
        }
    }

    JComponent createBottom() {
        Integer splitPaneLocation;
        NodeInfoPane leftPanel = this.nodeInfoPane;
        NodePipPane centerPanel = this.nodePipPane;
        JPanel rightPanel = this.bottomRight();
        this.bottomLCPanel = new JSplitPane(1, leftPanel, centerPanel);
        this.bottomRPanel = new JSplitPane(1, this.bottomLCPanel, rightPanel);
        leftPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        centerPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.bottomLCPanel.setBorder(null);
        this.bottomLCPanel.setResizeWeight(0.67);
        this.bottomRPanel.setResizeWeight(0.75);
        this.bottomLCPanel.setOneTouchExpandable(true);
        this.bottomRPanel.setOneTouchExpandable(true);
        Object w = this.prefsMgr.getProperty(this.getWindowFrameRef(), "bottomLCPanelDividerLocation");
        if (w != null) {
            splitPaneLocation = (Integer)w;
            this.bottomLCPanel.setDividerLocation(splitPaneLocation);
        }
        if ((w = this.prefsMgr.getProperty(this.getWindowFrameRef(), "bottomRPanelDividerLocation")) != null) {
            splitPaneLocation = (Integer)w;
            this.bottomRPanel.setDividerLocation(splitPaneLocation);
        }
        this.bottomLCPanel.addPropertyChangeListener(changeEvent -> {
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("dividerLocation")) {
                this.prefsMgr.setProperty(this.getWindowFrameRef(), "bottomLCPanelDividerLocation", this.bottomLCPanel.getDividerLocation());
            }
        });
        this.bottomRPanel.addPropertyChangeListener(changeEvent -> {
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("dividerLocation")) {
                this.prefsMgr.setProperty(this.getWindowFrameRef(), "bottomRPanelDividerLocation", this.bottomRPanel.getDividerLocation());
            }
        });
        return this.bottomRPanel;
    }

    JComponent createTop() {
        JPanel rosters = new JPanel();
        rosters.setLayout(new BorderLayout());
        this.nodetable = new LccProTable(this.memo);
        rosters.add((Component)this.nodetable, "Center");
        this.nodetable.getTable().getSelectionModel().addListSelectionListener(e -> {
            JTable table = this.nodetable.getTable();
            if (!e.getValueIsAdjusting() && table.getSelectedRow() >= 0) {
                int row = table.convertRowIndexToModel(table.getSelectedRow());
                log.debug("Selected: {}", (Object)row);
                MimicNodeStore.NodeMemo nodememo = this.nodestore.getNodeMemos().toArray(new MimicNodeStore.NodeMemo[0])[row];
                log.trace("   node: {}", (Object)nodememo.getNodeID().toString());
                this.nodeInfoPane.update(nodememo);
                this.nodePipPane.update(nodememo);
            }
        });
        String nodetableref = this.getWindowFrameRef() + ":nodes";
        this.nodetable.getTable().setName(nodetableref);
        RowSorterUtil.addSingleSortableColumnListener(this.nodetable.getTable().getRowSorter());
        JTablePersistenceManager tpm = InstanceManager.getNullableDefault(JTablePersistenceManager.class);
        if (tpm != null) {
            tpm.resetState(this.nodetable.getTable());
            tpm.persist(this.nodetable.getTable());
        }
        this.nodetable.getTable().setDragEnabled(true);
        this.nodetable.getTable().setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public Transferable createTransferable(JComponent c) {
                JTable table = LccProFrame.this.nodetable.getTable();
                ArrayList<String> Ids = new ArrayList<String>(table.getSelectedRowCount());
                for (int i = 0; i < table.getSelectedRowCount(); ++i) {
                }
                return new RosterEntrySelection(Ids);
            }

            @Override
            public void exportDone(JComponent c, Transferable t, int action) {
            }
        });
        this.nodetable.getTable().addMouseListener(JmriMouseListener.adapt(new NodePopupListener()));
        JPanel leftSide = new JPanel();
        leftSide.setEnabled(false);
        leftSide.setVisible(false);
        this.rosterGroupSplitPane = new JSplitPane(1, leftSide, rosters);
        this.rosterGroupSplitPane.setOneTouchExpandable(false);
        this.rosterGroupSplitPane.setResizeWeight(0.0);
        Object w = this.prefsMgr.getProperty(this.getWindowFrameRef(), "rosterGroupPaneDividerLocation");
        if (w != null) {
            this.groupSplitPaneLocation = (Integer)w;
            this.rosterGroupSplitPane.setDividerLocation(this.groupSplitPaneLocation);
        }
        log.trace("createTop returns {}", (Object)this.rosterGroupSplitPane);
        return this.rosterGroupSplitPane;
    }

    private void filter() {
        RowFilter<LccProTableModel, Integer> rf = new RowFilter<LccProTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends LccProTableModel, ? extends Integer> entry) {
                if (LccProFrame.this.matchGroupName.getSelectedIndex() > 0) {
                    String group = LccProFrame.this.matchGroupName.getSelectedItem().toString();
                    NodeID node = new NodeID((String)entry.getValue(1));
                    if (!LccProFrame.this.groupStore.isNodeInGroup(node, group)) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.nodetable.sorter.setRowFilter(rf);
    }

    public boolean isAllowQuit() {
        return this.allowQuit;
    }

    public void setAllowQuit(boolean allowQuit) {
        this.allowQuit(allowQuit);
    }

    protected JmriAbstractAction getNewWindowAction() {
        if (this.newWindowAction == null) {
            this.newWindowAction = new LccProFrameAction("newWindow", this, this.allowQuit);
        }
        return this.newWindowAction;
    }

    protected void setNewWindowAction(JmriAbstractAction newWindowAction) {
        this.newWindowAction = newWindowAction;
    }

    @Override
    public Object getProperty(String key) {
        if (key.equalsIgnoreCase("hideSummary")) {
            return this.hideBottomPane;
        }
        return super.getProperty(key);
    }

    void handleQuit(WindowEvent e) {
        if (e != null && frameInstances.size() == 1) {
            String rememberWindowClose = this.getClass().getName() + ".closeDP3prompt";
            if (!this.prefsMgr.getSimplePreferenceState(rememberWindowClose)) {
                JPanel message = new JPanel();
                JLabel question = new JLabel(this.rb.getString("MessageLongCloseWarning"));
                JCheckBox remember = new JCheckBox(this.rb.getString("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                message.setLayout(new BoxLayout(message, 1));
                message.add(question);
                message.add(remember);
                int result = JmriJOptionPane.showConfirmDialog(null, message, this.rb.getString("MessageShortCloseWarning"), 0);
                if (remember.isSelected()) {
                    this.prefsMgr.setSimplePreferenceState(rememberWindowClose, true);
                }
                if (result == 0) {
                    this.handleQuit();
                }
            } else {
                this.handleQuit();
            }
        } else if (frameInstances.size() > 1) {
            String rememberWindowClose = this.getClass().getName() + ".closeMultipleDP3prompt";
            if (!this.prefsMgr.getSimplePreferenceState(rememberWindowClose)) {
                JPanel message = new JPanel();
                JLabel question = new JLabel(this.rb.getString("MessageLongMultipleCloseWarning"));
                JCheckBox remember = new JCheckBox(this.rb.getString("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                message.setLayout(new BoxLayout(message, 1));
                message.add(question);
                message.add(remember);
                int result = JmriJOptionPane.showConfirmDialog(null, message, this.rb.getString("MessageShortCloseWarning"), 0);
                if (remember.isSelected()) {
                    this.prefsMgr.setSimplePreferenceState(rememberWindowClose, true);
                }
                if (result == 0) {
                    this.handleQuit();
                }
            } else {
                this.handleQuit();
            }
        }
    }

    private void handleQuit() {
        try {
            InstanceManager.getDefault(ShutDownManager.class).shutdown();
        }
        catch (Exception e) {
            log.error("Continuing after error in handleQuit", (Throwable)e);
        }
    }

    protected void helpMenu(JMenuBar menuBar, JFrame frame) {
        JMenu helpMenu = HelpUtil.makeHelpMenu("package.apps.gui3.lccpro.LccPro", true);
        menuBar.add(helpMenu);
    }

    protected void hideGroups() {
        boolean boo = !this.hideGroups;
        this.hideGroupsPane(boo);
    }

    public void hideGroupsPane(boolean hide) {
        if (this.hideGroups == hide) {
            return;
        }
        this.hideGroups = hide;
        if (hide) {
            this.groupSplitPaneLocation = this.rosterGroupSplitPane.getDividerLocation();
            this.rosterGroupSplitPane.setDividerLocation(1);
            this.rosterGroupSplitPane.getLeftComponent().setMinimumSize(new Dimension());
        } else {
            this.rosterGroupSplitPane.setDividerSize(UIManager.getInt("SplitPane.dividerSize"));
            this.rosterGroupSplitPane.setOneTouchExpandable(true);
            if (this.groupSplitPaneLocation >= 2) {
                this.rosterGroupSplitPane.setDividerLocation(this.groupSplitPaneLocation);
            } else {
                this.rosterGroupSplitPane.resetToPreferredSizes();
            }
        }
    }

    protected void hideSummary() {
        boolean boo = !this.hideBottomPane;
        this.hideBottomPane(boo);
    }

    protected void newWindow() {
        this.newWindow(this.getNewWindowAction());
    }

    protected void newWindow(JmriAbstractAction action) {
        action.setWindowInterface(this);
        action.actionPerformed(null);
        this.firePropertyChange("closewindow", "setEnabled", (Object)true);
    }

    @Override
    public void remoteCalls(String[] args) {
        args[0] = args[0].toLowerCase();
        switch (args[0]) {
            case "summarypane": {
                this.hideSummary();
                break;
            }
            case "groupspane": {
                this.hideGroups();
                break;
            }
            case "quit": {
                this.saveWindowDetails();
                this.handleQuit(new WindowEvent(this, frameInstances.size()));
                break;
            }
            case "closewindow": {
                this.closeWindow(null);
                break;
            }
            case "newwindow": {
                this.newWindow();
                break;
            }
            case "resettablecolumns": {
                this.nodetable.resetColumnWidths();
                break;
            }
            default: {
                log.error("method {} not found", (Object)args[0]);
            }
        }
    }

    void saveWindowDetails() {
        if (this.prefsMgr != null) {
            this.prefsMgr.setSimplePreferenceState(this.getClass().getName() + ".hideSummary", this.hideBottomPane);
            this.prefsMgr.setSimplePreferenceState(this.getClass().getName() + ".hideGroups", this.hideGroups);
            if (this.rosterGroupSplitPane.getDividerLocation() > 2) {
                this.prefsMgr.setProperty(this.getWindowFrameRef(), "rosterGroupPaneDividerLocation", this.rosterGroupSplitPane.getDividerLocation());
            } else if (this.groupSplitPaneLocation > 2) {
                this.prefsMgr.setProperty(this.getWindowFrameRef(), "rosterGroupPaneDividerLocation", this.groupSplitPaneLocation);
            }
        }
    }

    protected void showPopup(JmriMouseEvent e) {
        int row = this.nodetable.getTable().rowAtPoint(e.getPoint());
        if (!this.nodetable.getTable().isRowSelected(row)) {
            this.nodetable.getTable().changeSelection(row, 0, false, false);
        }
        JPopupMenu popupMenu = new JPopupMenu();
        NodeID node = new NodeID((String)this.nodetable.getTable().getValueAt(row, 1));
        JMenuItem addMenu = new JMenuItem("Add Node To Group");
        addMenu.addActionListener(evt -> this.addToGroupPrompt(node));
        popupMenu.add(addMenu);
        JMenuItem removeMenu = new JMenuItem("Remove Node From Group");
        removeMenu.addActionListener(evt -> this.removeFromGroupPrompt(node));
        popupMenu.add(removeMenu);
        JMenuItem restartMenu = new JMenuItem("Restart Node");
        restartMenu.addActionListener(evt -> this.restart(node));
        popupMenu.add(restartMenu);
        JMenuItem clearCdiMenu = new JMenuItem("Clear CDI Cache");
        clearCdiMenu.addActionListener(evt -> this.clearCDI(node));
        popupMenu.add(clearCdiMenu);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    void addToGroupPrompt(NodeID node) {
        String group = JmriJOptionPane.showInputDialog(null, "Add to Group:", "Add to Group", 3);
        if (!group.isEmpty()) {
            this.groupStore.addNodeToGroup(node, group);
        }
        this.updateMatchGroupName();
    }

    void removeFromGroupPrompt(NodeID node) {
        String group = JmriJOptionPane.showInputDialog(null, "Remove from Group:", "Remove from Group", 3);
        if (!group.isEmpty()) {
            this.groupStore.removeNodeFromGroup(node, group);
        }
        this.updateMatchGroupName();
    }

    void restart(NodeID node) {
        this.memo.get(OlcbInterface.class).getDatagramService().sendData(node, new int[]{32, 169});
    }

    void clearCDI(NodeID destNodeID) {
        DropCdiCache.drop(destNodeID, this.memo.get(OlcbInterface.class));
    }

    protected void statusBar() {
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (conn.getDisabled()) continue;
            this.addToStatusBox(new ConnectionLabel(conn));
        }
        this.addToStatusBox(new TrafficStatusLabel(this.memo));
    }

    protected void systemsMenu() {
        ActiveSystemsMenu.addItems(this.getMenu());
        this.getMenu().add(new WindowMenu(this));
    }

    void updateDetails() {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeWindow(e);
    }

    private static class NodePipPane
    extends JPanel {
        public NodePipPane() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel("Supported Protocols:"));
        }

        public void update(MimicNodeStore.NodeMemo nodememo) {
            this.removeAll();
            this.revalidate();
            this.repaint();
            this.add(new JLabel("Supported Protocols:"));
            ProtocolIdentification pip = nodememo.getProtocolIdentification();
            List names = pip.getProtocolNames();
            for (String name : names) {
                String regex = "([a-z])([A-Z])";
                String replacement = "$1 $2";
                String formattedName = "   " + name.replaceAll("([a-z])([A-Z])", "$1 $2");
                this.add(new JLabel(formattedName));
            }
        }
    }

    private static class NodeInfoPane
    extends JPanel {
        JLabel name = new JLabel();
        JLabel desc = new JLabel();
        JLabel nodeID = new JLabel();
        JLabel mfg = new JLabel();
        JLabel model = new JLabel();
        JLabel hardver = new JLabel();
        JLabel softver = new JLabel();

        public NodeInfoPane() {
            GridLayout2 gbl = new GridLayout2(7, 2);
            this.setLayout(gbl);
            JLabel a = new JLabel("Name: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.name);
            a = new JLabel("Description: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.desc);
            a = new JLabel("Node ID: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.nodeID);
            a = new JLabel("Manufacturer: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.mfg);
            a = new JLabel("Model: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.model);
            a = new JLabel("Hardware Version: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.hardver);
            a = new JLabel("Software Version: ");
            a.setHorizontalAlignment(4);
            this.add(a);
            this.add(this.softver);
        }

        public void update(MimicNodeStore.NodeMemo nodememo) {
            SimpleNodeIdent snip = nodememo.getSimpleNodeIdent();
            this.name.setText(snip.getUserName());
            this.desc.setText(snip.getUserDesc());
            this.nodeID.setText(nodememo.getNodeID().toString());
            this.mfg.setText(snip.getMfgName());
            this.model.setText(snip.getModelName());
            this.hardver.setText(snip.getHardwareVersion());
            this.softver.setText(snip.getSoftwareVersion());
        }
    }

    private class NodePopupListener
    extends JmriMouseAdapter {
        private NodePopupListener() {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                LccProFrame.this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                LccProFrame.this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                LccProFrame.this.showPopup(e);
                return;
            }
        }
    }
}

