/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.lccpro;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.swing.lccpro.LccProTableModel;
import jmri.util.AlphanumComparator;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class LccProTable
extends JmriPanel {
    private LccProTableModel dataModel;
    TableRowSorter<LccProTableModel> sorter;
    private JTable dataTable;
    private JScrollPane dataScroll;
    private final XTableColumnModel columnModel = new XTableColumnModel();

    public LccProTable(CanSystemConnectionMemo memo) {
        this.dataModel = new LccProTableModel(memo){

            @Override
            public void forceFocus() {
                LccProTable.this.requestFocus();
            }
        };
        this.sorter = new TableRowSorter<LccProTableModel>(this.dataModel);
        this.dataTable = new JTable(this.dataModel);
        this.dataTable.setRowSorter(this.sorter);
        this.dataScroll = new JScrollPane(this.dataTable);
        this.dataTable.setRowHeight(InstanceManager.getDefault(GuiLafPreferencesManager.class).getFontSize() + 4);
        this.sorter.setComparator(1, new AlphanumComparator());
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.dataTable.getTableHeader().setReorderingAllowed(true);
        this.dataTable.setAutoResizeMode(0);
        this.dataTable.setColumnModel(this.columnModel);
        this.dataTable.createDefaultColumnsFromModel();
        this.dataTable.setAutoCreateColumnsFromModel(false);
        this.resetColumnWidths();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        this.columnModel.getColumn(5).setCellRenderer(buttonRenderer);
        this.columnModel.getColumn(6).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton()){

            @Override
            public void editingStarted(EventObject event) {
            }
        };
        this.dataTable.setDefaultEditor(JButton.class, buttonEditor);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.dataScroll);
        Dimension dataTableSize = this.dataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        dataTableSize.width = Math.max(dataTableSize.width, 400);
        this.dataScroll.getViewport().setPreferredSize(dataTableSize);
        this.dataTable.setSelectionMode(0);
        TableHeaderListener mouseHeaderListener = new TableHeaderListener();
        this.dataTable.getTableHeader().addMouseListener(JmriMouseListener.adapt(mouseHeaderListener));
    }

    public JTable getTable() {
        return this.dataTable;
    }

    public LccProTableModel getModel() {
        return this.dataModel;
    }

    public final void resetColumnWidths() {
        Enumeration<TableColumn> en = this.columnModel.getColumns(false);
        while (en.hasMoreElements()) {
            TableColumn tc = en.nextElement();
            int width = this.dataModel.getPreferredWidth(tc.getModelIndex());
            tc.setPreferredWidth(width);
        }
        this.dataTable.sizeColumnsToFit(-1);
    }

    @Override
    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        this.dataModel = null;
        this.dataTable = null;
        super.dispose();
    }

    protected void showTableHeaderPopup(JmriMouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        for (int i = 0; i < this.columnModel.getColumnCount(false); ++i) {
            TableColumn tc = this.columnModel.getColumnByModelIndex(i);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.dataTable.getModel().getColumnName(i), this.columnModel.isColumnVisible(tc));
            menuItem.addActionListener(new HeaderActionListener(tc));
            popupMenu.add(menuItem);
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setSelectionMode(int selectionMode) {
        this.dataTable.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.dataTable.getSelectionModel().getSelectionMode();
    }

    private class TableHeaderListener
    extends JmriMouseAdapter {
        private TableHeaderListener() {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                LccProTable.this.showTableHeaderPopup(e);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                LccProTable.this.showTableHeaderPopup(e);
            }
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                LccProTable.this.showTableHeaderPopup(e);
            }
        }
    }

    private class HeaderActionListener
    implements ActionListener {
        TableColumn tc;

        HeaderActionListener(TableColumn tc) {
            this.tc = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem check = (JCheckBoxMenuItem)e.getSource();
            if (!check.isSelected() && LccProTable.this.columnModel.getColumnCount(true) == 1) {
                return;
            }
            LccProTable.this.columnModel.setColumnVisible(this.tc, check.isSelected());
        }
    }
}

