/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.lccpro;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.swing.ClientActions;
import jmri.jmrix.openlcb.swing.downloader.LoaderPane;
import jmri.jmrix.openlcb.swing.lccpro.Bundle;
import jmri.jmrix.openlcb.swing.networktree.NetworkTreePane;
import jmri.util.ThreadingUtil;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProtocolIdentification;
import org.openlcb.SimpleNodeIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LccProTableModel
extends DefaultTableModel
implements PropertyChangeListener {
    static final int NAMECOL = 0;
    public static final int IDCOL = 1;
    static final int MFGCOL = 2;
    static final int MODELCOL = 3;
    static final int SVERSIONCOL = 4;
    public static final int CONFIGURECOL = 5;
    public static final int UPGRADECOL = 6;
    public static final int NUMCOL = 7;
    CanSystemConnectionMemo memo;
    MimicNodeStore nodestore;
    private static final Logger log = LoggerFactory.getLogger(LccProTableModel.class);

    public LccProTableModel(CanSystemConnectionMemo memo) {
        this.memo = memo;
        this.nodestore = memo.get(MimicNodeStore.class);
        log.trace("Found nodestore {}", (Object)this.nodestore);
        this.nodestore.addPropertyChangeListener((PropertyChangeListener)this);
        this.nodestore.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.trace("received {}", (Object)e);
        ThreadingUtil.runOnGUIDelayed(() -> this.fireTableDataChanged(), 250);
        ThreadingUtil.runOnGUIDelayed(() -> this.fireTableDataChanged(), 1000);
    }

    @Override
    public int getRowCount() {
        if (this.nodestore == null) {
            log.trace("Did not expect null nodestore, except in initialization before ctor runs");
            return 1;
        }
        if (this.nodestore.getNodeMemos() == null) {
            log.debug("Did not expect missing node memos");
            return 0;
        }
        return this.nodestore.getNodeMemos().size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("FieldName");
            }
            case 1: {
                return Bundle.getMessage("FieldID");
            }
            case 2: {
                return Bundle.getMessage("FieldMfg");
            }
            case 3: {
                return Bundle.getMessage("FieldModel");
            }
            case 4: {
                return Bundle.getMessage("FieldSVersion");
            }
            case 5: {
                return Bundle.getMessage("FieldConfig");
            }
            case 6: {
                return Bundle.getMessage("FieldUpgrade");
            }
        }
        return "<unexpected column number>";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 5: 
            case 6: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        log.trace("getValue({}, {})", (Object)row, (Object)col);
        MimicNodeStore.NodeMemo[] memoArray = this.nodestore.getNodeMemos().toArray(new MimicNodeStore.NodeMemo[0]);
        if (row >= memoArray.length) {
            return "";
        }
        MimicNodeStore.NodeMemo nodememo = memoArray[row];
        if (nodememo == null) {
            return "<invalid node memo>";
        }
        SimpleNodeIdent snip = nodememo.getSimpleNodeIdent();
        if (snip == null) {
            return "<snip info not yet availble>";
        }
        ProtocolIdentification pip = nodememo.getProtocolIdentification();
        switch (col) {
            case 0: {
                return snip.getUserName();
            }
            case 1: {
                return nodememo.getNodeID().toString();
            }
            case 2: {
                return snip.getMfgName();
            }
            case 3: {
                return snip.getModelName();
            }
            case 4: {
                return snip.getSoftwareVersion();
            }
            case 5: {
                if (pip.hasProtocol(ProtocolIdentification.Protocol.ConfigurationDescription)) {
                    return Bundle.getMessage("FieldConfig");
                }
                return null;
            }
            case 6: {
                if (pip.hasProtocol(ProtocolIdentification.Protocol.FirmwareUpgrade)) {
                    return Bundle.getMessage("FieldUpgrade");
                }
                return null;
            }
        }
        return "<unexpected column number>";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.trace("getValue({}, {})", (Object)row, (Object)col);
        MimicNodeStore.NodeMemo nodememo = this.nodestore.getNodeMemos().toArray(new MimicNodeStore.NodeMemo[0])[row];
        if (nodememo == null) {
            log.error("Button pushed but no corresponding node for row {}", (Object)row);
            return;
        }
        ProtocolIdentification pip = nodememo.getProtocolIdentification();
        switch (col) {
            case 5: {
                if (!pip.hasProtocol(ProtocolIdentification.Protocol.ConfigurationDescription)) break;
                ClientActions actions = new ClientActions(this.memo.get(OlcbInterface.class), this.memo);
                NodeID node = nodememo.getNodeID();
                String description = NetworkTreePane.augmentedNodeName(nodememo);
                actions.openCdiWindow(node, description);
                this.forceFocus();
                break;
            }
            case 6: {
                if (!pip.hasProtocol(ProtocolIdentification.Protocol.FirmwareUpgrade)) break;
                NodeID node = nodememo.getNodeID();
                LoaderPane.Default action = new LoaderPane.Default(node);
                action.actionPerformed(null);
                break;
            }
        }
    }

    public void forceFocus() {
    }

    public int getPreferredWidth(int column) {
        int retval = 20;
        retval = Math.max(retval, new JLabel((String)this.getColumnName((int)column)).getPreferredSize().width + 15);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.getColumnClass(column).equals(String.class)) {
                retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
                continue;
            }
            if (this.getColumnClass(column).equals(Integer.class)) {
                retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
                continue;
            }
            if (!this.getColumnClass(column).equals(ImageIcon.class)) continue;
            retval = Math.max(retval, new JLabel((Icon)((Icon)this.getValueAt((int)row, (int)column))).getPreferredSize().width);
        }
        return retval + 5;
    }

    public void dispose() {
        this.nodestore.removePropertyChangeListener((PropertyChangeListener)this);
    }
}

