/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.memtool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.memtool.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WrapLayout;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.openlcb.Connection;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.implementations.EventTable;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.MemorySpaceSelector;
import org.openlcb.swing.NodeSelector;
import org.openlcb.swing.memconfig.MemConfigDescriptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryToolPane
extends JmriPanel
implements CanPanelInterface {
    protected CanSystemConnectionMemo memo;
    Connection connection;
    NodeID nid;
    MimicNodeStore store;
    MemoryConfigurationService service;
    NodeSelector nodeSelector;
    static final int CHUNKSIZE = 64;
    MemorySpaceSelector spaceField;
    JLabel statusField;
    JButton gb;
    JButton pb;
    JButton cb;
    boolean cancelled = false;
    boolean running = false;
    JCheckBox trustStatusReply;
    int space = 255;
    NodeID farID = new NodeID("0.0.0.0.0.0");
    MemoryConfigurationService.McsReadHandler cbr = new MemoryConfigurationService.McsReadHandler(){

        public void handleFailure(int errorCode) {
            MemoryToolPane.this.setRunning(false);
            if (errorCode == 4226) {
                MemoryToolPane.this.statusField.setText("Done reading");
                log.debug("Stopping read due to 0x1082 status");
            }
            if (errorCode == 4225) {
                log.error("Read failed. Address space not known");
                MemoryToolPane.this.statusField.setText("Read failed. Address space not known");
            } else {
                log.error("Read failed. Error code is {}", (Object)String.format("%04X", errorCode));
                MemoryToolPane.this.statusField.setText("Read failed. Error code is " + String.format("%04X", errorCode));
            }
            try {
                MemoryToolPane.this.outputStream.flush();
                MemoryToolPane.this.outputStream.close();
            }
            catch (IOException ex) {
                log.error("Error closing file", (Throwable)ex);
                MemoryToolPane.this.statusField.setText("Error closing output file");
            }
        }

        public void handleReadData(NodeID dest, int readSpace, long readAddress, byte[] readData) {
            log.trace("read succeed with {} bytes at {}", (Object)readData.length, (Object)readAddress);
            MemoryToolPane.this.statusField.setText("Read " + readAddress + " bytes");
            try {
                MemoryToolPane.this.outputStream.write(readData);
            }
            catch (IOException ex) {
                log.error("Error writing data to file", (Throwable)ex);
                MemoryToolPane.this.statusField.setText("Error writing data to file");
                MemoryToolPane.this.setRunning(false);
                return;
            }
            if (readData.length != 64) {
                MemoryToolPane.this.statusField.setText("Done reading");
                log.debug("Stopping read due to short reply");
                MemoryToolPane.this.setRunning(false);
                try {
                    MemoryToolPane.this.outputStream.flush();
                    MemoryToolPane.this.outputStream.close();
                }
                catch (IOException ex) {
                    log.error("Error closing file", (Throwable)ex);
                    MemoryToolPane.this.statusField.setText("Error closing output file");
                }
                return;
            }
            if (readAddress + (long)readData.length - 1L >= MemoryToolPane.this.endingAddress) {
                MemoryToolPane.this.setRunning(false);
                log.debug("Get operation ending on length");
                MemoryToolPane.this.statusField.setText("Done Reading");
            }
            if (!MemoryToolPane.this.cancelled) {
                MemoryToolPane.this.service.requestRead(MemoryToolPane.this.farID, MemoryToolPane.this.space, readAddress + (long)readData.length, (int)Math.min(64L, MemoryToolPane.this.endingAddress - (readAddress + (long)readData.length - 1L)), MemoryToolPane.this.cbr);
            } else {
                MemoryToolPane.this.setRunning(false);
                MemoryToolPane.this.cancelled = false;
                log.debug("Get operation cancelled");
                MemoryToolPane.this.statusField.setText("Cancelled");
            }
        }
    };
    OutputStream outputStream;
    long endingAddress = 4096L;
    MemoryConfigurationService.McsWriteHandler cbw = new MemoryConfigurationService.McsWriteHandler(){

        public void handleFailure(int errorCode) {
            if (errorCode == 4225) {
                log.error("Write failed. Address space not known");
                MemoryToolPane.this.statusField.setText("Write failed. Address space not known.");
            } else if (errorCode == 4227) {
                log.error("Write failed. Address space not writable");
                MemoryToolPane.this.statusField.setText("Write failed. Address space not writeable.");
            } else {
                log.error("Write failed. error code is {}", (Object)String.format("%04X", errorCode));
                MemoryToolPane.this.statusField.setText("Write failed. error code is " + String.format("%016X", errorCode));
            }
            MemoryToolPane.this.setRunning(false);
        }

        public void handleSuccess() {
            byte[] dataRead;
            log.trace("Write succeeded {} bytes", (Object)(MemoryToolPane.this.address + MemoryToolPane.this.bytesRead));
            if (MemoryToolPane.this.cancelled) {
                log.debug("Cancelled");
                MemoryToolPane.this.statusField.setText("Cancelled");
                MemoryToolPane.this.setRunning(false);
                MemoryToolPane.this.cancelled = false;
            }
            MemoryToolPane.this.address += MemoryToolPane.this.bytesRead;
            try {
                dataRead = MemoryToolPane.this.getBytes();
                if (dataRead == null) {
                    MemoryToolPane.this.setRunning(false);
                    log.debug("Completed");
                    MemoryToolPane.this.statusField.setText("Completed.");
                    MemoryToolPane.this.inputStream.close();
                    return;
                }
                MemoryToolPane.this.bytesRead = dataRead.length;
                log.trace("write {} bytes", (Object)MemoryToolPane.this.bytesRead);
            }
            catch (IOException ex) {
                log.error("Error reading file", (Throwable)ex);
                return;
            }
            MemoryToolPane.this.service.requestWrite(MemoryToolPane.this.farID, MemoryToolPane.this.space, (long)MemoryToolPane.this.address, dataRead, MemoryToolPane.this.cbw);
        }
    };
    byte[] bytes = new byte[64];
    int bytesRead;
    InputStream inputStream;
    int address;
    static JFileChooser fileChooser = null;
    private static final Logger log = LoggerFactory.getLogger(MemoryToolPane.class);

    public String getTitle(String menuTitle) {
        return Bundle.getMessage("TitleMemoryTool");
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        this.connection = memo.get(Connection.class);
        this.nid = memo.get(NodeID.class);
        this.store = memo.get(MimicNodeStore.class);
        EventTable stdEventTable = memo.get(OlcbInterface.class).getEventTable();
        if (stdEventTable == null) {
            log.error("no OLCB EventTable found");
            return;
        }
        this.service = memo.get(MemoryConfigurationService.class);
        this.setLayout(new BoxLayout(this, 1));
        JPanel ns = new JPanel();
        ns.setLayout(new WrapLayout());
        this.add(ns);
        this.nodeSelector = new NodeSelector(this.store, Integer.MAX_VALUE);
        ns.add((Component)this.nodeSelector);
        JButton check = new JButton("Check");
        ns.add(check);
        check.addActionListener(this::pushedCheckButton);
        JPanel ms = new JPanel();
        ms.setLayout(new WrapLayout());
        this.add(ms);
        ms.add(new JLabel("Memory Space:"));
        this.spaceField = new MemorySpaceSelector(255);
        ms.add((Component)this.spaceField);
        this.trustStatusReply = new JCheckBox("Trust Status Info");
        this.trustStatusReply.setSelected(true);
        ms.add(this.trustStatusReply);
        JPanel bb = new JPanel();
        bb.setLayout(new WrapLayout());
        this.add(bb);
        this.gb = new JButton(Bundle.getMessage("ButtonGet"));
        bb.add(this.gb);
        this.gb.addActionListener(this::pushedGetButton);
        this.pb = new JButton(Bundle.getMessage("ButtonPut"));
        bb.add(this.pb);
        this.pb.addActionListener(this::pushedPutButton);
        this.cb = new JButton(Bundle.getMessage("ButtonCancel"));
        bb.add(this.cb);
        this.cb.addActionListener(this::pushedCancel);
        bb = new JPanel();
        bb.setLayout(new WrapLayout());
        this.add(bb);
        this.statusField = new JLabel("                          ", 0);
        bb.add(this.statusField);
        this.setRunning(false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.memtool.MemoryToolPane";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return this.memo.getUserName() + " Memory Tool";
        }
        return this.getTitle(Bundle.getMessage("TitleMemoryTool"));
    }

    void pushedCheckButton(ActionEvent e) {
        SimpleNodeIdent ident;
        NodeID node = this.nodeSelector.getSelectedNodeID();
        JmriJFrame f = new JmriJFrame();
        f.setTitle("Configuration Capabilities");
        JPanel p = new JPanel();
        f.add(p);
        p.setLayout(new BoxLayout(p, 1));
        JPanel q = new JPanel();
        q.setLayout(new WrapLayout());
        p.add(q);
        q.add(new JLabel(node.toString()));
        p.add(new JSeparator(0));
        MimicNodeStore.NodeMemo nodeMemo = this.store.findNode(node);
        String name = "";
        if (nodeMemo != null && (ident = nodeMemo.getSimpleNodeIdent()) != null) {
            name = ident.getUserName();
            q = new JPanel();
            q.setLayout(new WrapLayout());
            q.add(new JLabel(name));
            p.add(q);
        }
        MemConfigDescriptionPane mc = new MemConfigDescriptionPane(node, this.store, this.service);
        p.add((Component)mc);
        mc.initComponents();
        f.pack();
        f.setVisible(true);
    }

    void pushedCancel(ActionEvent e) {
        if (this.running) {
            this.cancelled = true;
        }
    }

    void setRunning(boolean t) {
        if (t) {
            this.gb.setEnabled(false);
            this.pb.setEnabled(false);
            this.cb.setEnabled(true);
        } else {
            this.gb.setEnabled(true);
            this.pb.setEnabled(true);
            this.cb.setEnabled(false);
        }
        this.running = t;
    }

    void pushedGetButton(ActionEvent e) {
        this.setRunning(true);
        this.farID = this.nodeSelector.getSelectedNodeID();
        try {
            this.space = this.spaceField.getMemorySpace();
        }
        catch (NumberFormatException ex) {
            log.error("error parsing the space field value \"{}\"", (Object)this.spaceField.getText());
            this.statusField.setText("Error parsing the space value");
            this.setRunning(false);
            return;
        }
        log.debug("Start get");
        if (fileChooser == null) {
            fileChooser = new JmriJFileChooser();
        }
        fileChooser.setDialogTitle("Read into binary file");
        fileChooser.rescanCurrentDirectory();
        fileChooser.setSelectedFile(new File("memory.bin"));
        int retVal = fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            this.setRunning(false);
            return;
        }
        File file = fileChooser.getSelectedFile();
        log.debug("access {}", (Object)file);
        try {
            this.outputStream = new FileOutputStream(file);
        }
        catch (IOException ex) {
            log.error("Error opening file", (Throwable)ex);
            this.statusField.setText("Error opening file");
            this.setRunning(false);
            return;
        }
        if (this.trustStatusReply.isSelected()) {
            MemoryConfigurationService.McsAddrSpaceMemo cbq = new MemoryConfigurationService.McsAddrSpaceMemo(this.farID, this.space){

                public void handleWriteReply(int errorCode) {
                    log.error("Get failed with code {}", (Object)String.format("%04X", errorCode));
                    MemoryToolPane.this.statusField.setText("Get failed with code" + String.format("%04X", errorCode));
                    MemoryToolPane.this.setRunning(false);
                }

                public void handleAddrSpaceData(NodeID dest, int space, long hiAddress, long lowAddress, int flags, String desc) {
                    log.debug("received high Address of {}, low address of {}", (Object)hiAddress, (Object)lowAddress);
                    MemoryToolPane.this.endingAddress = hiAddress;
                    MemoryToolPane.this.service.requestRead(MemoryToolPane.this.farID, space, lowAddress, (int)Math.min(64L, MemoryToolPane.this.endingAddress - lowAddress + 1L), MemoryToolPane.this.cbr);
                }
            };
            this.service.request(cbq);
        } else {
            this.service.requestRead(this.farID, this.space, 0L, 64, this.cbr);
        }
    }

    void pushedPutButton(ActionEvent e) {
        byte[] dataRead;
        this.farID = this.nodeSelector.getSelectedNodeID();
        try {
            this.space = this.spaceField.getMemorySpace();
        }
        catch (NumberFormatException ex) {
            log.error("error parsing the space field value \"{}\"", (Object)this.spaceField.getText());
            this.statusField.setText("Error parsing the space value");
            this.setRunning(false);
            return;
        }
        log.debug("Start put");
        if (fileChooser == null) {
            fileChooser = new JmriJFileChooser();
        }
        fileChooser.setDialogTitle("Upload binary file");
        fileChooser.rescanCurrentDirectory();
        fileChooser.setSelectedFile(new File("memory.bin"));
        int retVal = fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        log.debug("access {}", (Object)file);
        try {
            this.inputStream = new FileInputStream(file);
            dataRead = this.getBytes();
            if (dataRead == null) {
                log.debug("Completed");
                this.inputStream.close();
                return;
            }
            this.bytesRead = dataRead.length;
            log.trace("read {} bytes", (Object)this.bytesRead);
        }
        catch (IOException ex) {
            log.error("Error reading file", (Throwable)ex);
            return;
        }
        this.address = 0;
        this.setRunning(true);
        this.service.requestWrite(this.farID, this.space, (long)this.address, dataRead, this.cbw);
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null indicates end of file")
    byte[] getBytes() throws IOException {
        int bytesRead = this.inputStream.read(this.bytes);
        if (bytesRead == -1) {
            return null;
        }
        if (bytesRead == 64) {
            return this.bytes;
        }
        return Arrays.copyOf(this.bytes, bytesRead);
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super("Openlcb Memory Tool", new JmriJFrameInterface(), MemoryToolPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

