/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.monitor;

import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.swing.monitor.Bundle;
import jmri.util.StringUtil;
import org.openlcb.AddressedMessage;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.Message;
import org.openlcb.MimicNodeStore;
import org.openlcb.OlcbInterface;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.Utilities;
import org.openlcb.can.AliasMap;
import org.openlcb.can.CanFrame;
import org.openlcb.can.MessageBuilder;
import org.openlcb.can.OpenLcbCanFrame;
import org.openlcb.implementations.EventTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorPane
extends AbstractMonPane
implements CanListener,
CanPanelInterface {
    CanSystemConnectionMemo memo;
    AliasMap aliasMap;
    MessageBuilder messageBuilder;
    OlcbInterface olcbInterface;
    IdTagManager tagManager;
    final JCheckBox nodeNameCheckBox = new JCheckBox();
    final JCheckBox eventCheckBox = new JCheckBox();
    final JCheckBox eventAllCheckBox = new JCheckBox();
    final String nodeNameCheck = this.getClass().getName() + ".NodeName";
    final String eventCheck = this.getClass().getName() + ".Event";
    final String eventAllCheck = this.getClass().getName() + ".EventAll";
    private final UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
    private static final Logger log = LoggerFactory.getLogger(MonitorPane.class);

    public MonitorPane() {
        this.tagManager = InstanceManager.getDefault(IdTagManager.class);
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof CanSystemConnectionMemo) {
            this.initComponents((CanSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addCanConsoleListener(this);
        this.aliasMap = memo.get(AliasMap.class);
        this.messageBuilder = new MessageBuilder(this.aliasMap);
        this.olcbInterface = memo.get(OlcbInterface.class);
        this.setFixedWidthFont();
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return this.memo.getUserName() + " Monitor";
        }
        return Bundle.getMessage("MonitorTitle");
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.monitor.MonitorPane";
    }

    @Override
    protected void init() {
    }

    @Override
    public void dispose() {
        try {
            this.memo.getTrafficController().removeCanListener(this);
        }
        catch (NullPointerException npe) {
            log.debug("Null Pointer Exception while attempting to remove Can Listener", (Throwable)npe);
        }
        this.pm.setSimplePreferenceState(this.nodeNameCheck, this.nodeNameCheckBox.isSelected());
        this.pm.setSimplePreferenceState(this.eventCheck, this.eventCheckBox.isSelected());
        this.pm.setSimplePreferenceState(this.eventAllCheck, this.eventAllCheckBox.isSelected());
        super.dispose();
    }

    @Override
    protected void addCustomControlPanes(JPanel parent) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.nodeNameCheckBox.setText(Bundle.getMessage("CheckBoxShowNodeName"));
        this.nodeNameCheckBox.setVisible(true);
        this.nodeNameCheckBox.setSelected(this.pm.getSimplePreferenceState(this.nodeNameCheck));
        p.add(this.nodeNameCheckBox);
        this.eventCheckBox.setText(Bundle.getMessage("CheckBoxShowEvent"));
        this.eventCheckBox.setVisible(true);
        this.eventCheckBox.setSelected(this.pm.getSimplePreferenceState(this.eventCheck));
        p.add(this.eventCheckBox);
        this.eventAllCheckBox.setText(Bundle.getMessage("CheckBoxShowEventAll"));
        this.eventAllCheckBox.setVisible(true);
        this.eventAllCheckBox.setSelected(this.pm.getSimplePreferenceState(this.eventAllCheck));
        p.add(this.eventAllCheckBox);
        parent.add(p);
        super.addCustomControlPanes(parent);
    }

    String formatFrame(boolean extended, int header, int len, int[] content) {
        int i;
        StringBuilder formatted = new StringBuilder();
        formatted.append(extended ? "[" : "(");
        formatted.append(Integer.toHexString(header));
        formatted.append(extended ? "]" : ")");
        for (i = 0; i < len; ++i) {
            formatted.append(" ");
            formatted.append(StringUtil.twoHexFromInt(content[i]));
        }
        for (i = len; i < 8; ++i) {
            formatted.append("   ");
        }
        return new String(formatted);
    }

    List<Message> frameToMessages(int header, int len, int[] content) {
        OpenLcbCanFrame frame = new OpenLcbCanFrame(header & 0xFFF);
        frame.setHeader(header);
        if (len != 0) {
            byte[] data = new byte[len];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)content[i];
            }
            frame.setData(data);
        }
        this.aliasMap.processFrame(frame);
        return this.messageBuilder.processFrame((CanFrame)frame);
    }

    void format(String prefix, boolean extended, int header, int len, int[] content) {
        Object formatted;
        String raw = this.formatFrame(extended, header, len, content);
        if (extended && (header & 0x8000000) != 0) {
            List<Message> list = this.frameToMessages(header, len, content);
            if (list == null || list.isEmpty()) {
                if ((header & 0xF000000) == 0xB000000) {
                    formatted = prefix + ": (Start of Datagram)";
                } else if ((header & 0xF000000) == 0xC000000) {
                    formatted = prefix + ": (Middle of Datagram)";
                } else if ((header & 0xFFFF000) == 161513472 && content.length > 0) {
                    switch (content[0] & 0xF0) {
                        case 16: {
                            formatted = prefix + ": SNIP Reply 1st frame";
                            break;
                        }
                        case 32: {
                            formatted = prefix + ": SNIP Reply last frame";
                            break;
                        }
                        case 48: {
                            formatted = prefix + ": SNIP Reply middle frame";
                            break;
                        }
                        default: {
                            formatted = prefix + ": SNIP Reply unknown";
                            break;
                        }
                    }
                } else if ((header & 0xFFFF000) == 157200384 && content.length > 0) {
                    switch (content[0] & 0xF0) {
                        case 16: {
                            formatted = prefix + ": Traction Control Command 1st frame";
                            break;
                        }
                        case 32: {
                            formatted = prefix + ": Traction Control Command last frame";
                            break;
                        }
                        case 48: {
                            formatted = prefix + ": Traction Control Command middle frame";
                            break;
                        }
                        default: {
                            formatted = prefix + ": Traction Control Command unknown";
                            break;
                        }
                    }
                } else if ((header & 0xFFFF000) == 152997888 && content.length > 0) {
                    switch (content[0] & 0xF0) {
                        case 16: {
                            formatted = prefix + ": Traction Control Reply 1st frame";
                            break;
                        }
                        case 32: {
                            formatted = prefix + ": Traction Control Reply last frame";
                            break;
                        }
                        case 48: {
                            formatted = prefix + ": Traction Control Reply middle frame";
                            break;
                        }
                        default: {
                            formatted = prefix + ": Traction Control Reply unknown";
                            break;
                        }
                    }
                } else if ((header & 0xFFF8000) == 166789120 && content.length > 0) {
                    switch (header & 0x7000) {
                        case 24576: {
                            formatted = prefix + ": Events with Payload 1st frame";
                            break;
                        }
                        case 20480: {
                            formatted = prefix + ": Events with Payload middle frame";
                            break;
                        }
                        case 16384: {
                            formatted = prefix + ": Events with Payload last frame";
                            break;
                        }
                        default: {
                            formatted = prefix + ": Events with Payload unknown";
                            break;
                        }
                    }
                } else {
                    formatted = prefix + ": Unknown message " + raw;
                }
            } else {
                Message msg = list.get(0);
                StringBuilder sb = new StringBuilder();
                sb.append(prefix);
                sb.append(": ");
                sb.append(list.get(0).toString());
                if (this.nodeNameCheckBox.isSelected() && this.olcbInterface != null) {
                    SimpleNodeIdent ident;
                    Object name;
                    MimicNodeStore.NodeMemo ptr = this.olcbInterface.getNodeStore().findNode(list.get(0).getSourceNodeID());
                    if (ptr != null && ptr.getSimpleNodeIdent() != null) {
                        name = "";
                        ident = ptr.getSimpleNodeIdent();
                        if (ident != null && ((String)(name = ident.getUserName())).isEmpty()) {
                            name = ident.getMfgName() + " - " + ident.getModelName();
                        }
                        if (!((String)name).isBlank()) {
                            sb.append("\n  Src: ");
                            sb.append((String)name);
                        }
                    }
                    if (list.get(0) instanceof AddressedMessage && (ptr = this.olcbInterface.getNodeStore().findNode(((AddressedMessage)list.get(0)).getDestNodeID())) != null && ptr.getSimpleNodeIdent() != null) {
                        name = "";
                        ident = ptr.getSimpleNodeIdent();
                        if (ident != null && ((String)(name = ident.getUserName())).isEmpty()) {
                            name = ident.getMfgName() + " - " + ident.getModelName();
                        }
                        if (!((String)name).isBlank()) {
                            sb.append("    Dest: ");
                            sb.append((String)name);
                        }
                    }
                }
                if ((this.eventCheckBox.isSelected() || this.eventAllCheckBox.isSelected()) && this.olcbInterface != null && msg instanceof EventMessage) {
                    EventTable.EventTableEntry[] descr;
                    EventID ev = ((EventMessage)msg).getEventID();
                    log.debug("event message with event {}", (Object)ev);
                    IdTag tag = this.tagManager.getIdTag("IDOpenLCB$" + ev.toShortString());
                    String tagname = null;
                    if (tag != null && (tagname = tag.getUserName()) != null && !tagname.isEmpty()) {
                        sb.append("\n   Name: ");
                        sb.append(tagname);
                    }
                    if (content[0] == 1 && content[1] == 1 && content[2] == 0 && content[3] == 0 && content[4] == 1) {
                        sb.append("\n    ");
                        sb.append(this.formatTimeMessage(content));
                    }
                    if ((descr = this.olcbInterface.getEventTable().getEventInfo(ev).getAllEntries()).length > 0) {
                        sb.append("\n   Uses: ");
                        sb.append(descr[0].getDescription());
                        if (this.eventAllCheckBox.isSelected()) {
                            for (int i = 1; i < descr.length; ++i) {
                                sb.append("\n         ");
                                sb.append(descr[i].getDescription());
                            }
                        }
                    }
                }
                formatted = sb.toString();
            }
        } else {
            String alias = String.format("0x%03X", header & 0xFFF);
            if ((header & 0x7000000) == 0) {
                int[] data = new int[len];
                System.arraycopy(content, 0, data, 0, len);
                switch (header & 0xFFF000) {
                    case 0x700000: {
                        formatted = prefix + ": Alias " + alias + " RID frame";
                        break;
                    }
                    case 0x701000: {
                        formatted = prefix + ": Alias " + alias + " AMD frame for node " + Utilities.toHexDotsString((int[])data);
                        break;
                    }
                    case 0x702000: {
                        formatted = prefix + ": Alias " + alias + " AME frame for node " + Utilities.toHexDotsString((int[])data);
                        break;
                    }
                    case 0x703000: {
                        formatted = prefix + ": Alias " + alias + " AMR frame for node " + Utilities.toHexDotsString((int[])data);
                        break;
                    }
                    default: {
                        formatted = prefix + ": Unknown CAN control frame: " + raw;
                        break;
                    }
                }
            } else {
                formatted = prefix + ": Alias " + alias + " CID " + (header & 0x7000000) / 0x1000000 + " frame";
            }
        }
        this.nextLine((String)formatted + "\n", raw);
    }

    String formatTimeMessage(int[] content) {
        StringBuilder sb = new StringBuilder();
        int clock = content[5];
        switch (clock) {
            case 0: {
                sb.append(Bundle.getMessage("TimeClockDefault"));
                break;
            }
            case 1: {
                sb.append(Bundle.getMessage("TimeClockReal"));
                break;
            }
            case 2: {
                sb.append(Bundle.getMessage("TimeClockAlt1"));
                break;
            }
            case 3: {
                sb.append(Bundle.getMessage("TimeClockAlt2"));
                break;
            }
            default: {
                sb.append(Bundle.getMessage("TimeClockUnkClock"));
                sb.append(' ');
                sb.append(StringUtil.twoHexFromInt(clock));
            }
        }
        sb.append(' ');
        int msgType = (0xF0 & content[6]) >> 4;
        int nib = 0xF & content[6];
        int hour = content[6] & 0x1F;
        switch (msgType) {
            case 0: 
            case 1: {
                sb.append(Bundle.getMessage("TimeClockTimeMsg") + " ");
                sb.append(hour);
                sb.append(':');
                if (content[7] < 10) {
                    sb.append("0");
                    sb.append(content[7]);
                    break;
                }
                sb.append(content[7]);
                break;
            }
            case 2: {
                sb.append(Bundle.getMessage("TimeClockDateMsg") + " ");
                if (nib < 10) {
                    sb.append('0');
                }
                sb.append(nib);
                sb.append('/');
                if (content[7] < 10) {
                    sb.append('0');
                }
                sb.append(content[7]);
                break;
            }
            case 3: {
                sb.append(Bundle.getMessage("TimeClockYearMsg") + " ");
                sb.append(nib << 8 | content[7]);
                break;
            }
            case 4: {
                sb.append(Bundle.getMessage("TimeClockRateMsg") + " ");
                sb.append(' ');
                sb.append(this.cvtFastClockRate(content[6], content[7]));
                break;
            }
            case 8: 
            case 9: {
                sb.append(Bundle.getMessage("TimeClockSetTimeMsg") + " ");
                sb.append(hour);
                sb.append(':');
                if (content[7] < 10) {
                    sb.append("0");
                    sb.append(content[7]);
                    break;
                }
                sb.append(content[7]);
                break;
            }
            case 10: {
                sb.append(Bundle.getMessage("TimeClockSetDateMsg") + " ");
                if (nib < 10) {
                    sb.append('0');
                }
                sb.append(nib);
                sb.append('/');
                if (content[7] < 10) {
                    sb.append('0');
                }
                sb.append(content[7]);
                break;
            }
            case 11: {
                sb.append(Bundle.getMessage("TimeClockSetYearMsg") + " ");
                sb.append(nib << 8 | content[7]);
                break;
            }
            case 12: {
                sb.append(Bundle.getMessage("TimeClockSetRateMsg") + " ");
                sb.append(this.cvtFastClockRate(content[6], content[7]));
                break;
            }
            case 15: {
                if (nib == 0 && content[7] == 0) {
                    sb.append(Bundle.getMessage("TimeClockQueryMsg"));
                    break;
                }
                if (nib == 0 && content[7] == 1) {
                    sb.append(Bundle.getMessage("TimeClockStopMsg"));
                    break;
                }
                if (nib == 0 && content[7] == 2) {
                    sb.append(Bundle.getMessage("TimeClockStartMsg"));
                    break;
                }
                if (nib == 0 && content[7] == 3) {
                    sb.append(Bundle.getMessage("TimeClockDateRollMsg"));
                    break;
                }
                sb.append(Bundle.getMessage("TimeClockUnkData"));
                sb.append(' ');
                sb.append(StringUtil.twoHexFromInt(content[6]));
                sb.append(' ');
                sb.append(StringUtil.twoHexFromInt(content[7]));
                break;
            }
            default: {
                sb.append(Bundle.getMessage("TimeClockUnkData"));
                sb.append(' ');
                sb.append(StringUtil.twoHexFromInt(content[6]));
                sb.append(' ');
                sb.append(StringUtil.twoHexFromInt(content[7]));
            }
        }
        return sb.toString();
    }

    private float cvtFastClockRate(int byte6, int byte7) {
        int data = 0;
        boolean sign = false;
        float rate = 0.0f;
        data = (byte6 & 3) << 8 | byte7;
        sign = (byte6 & 4) >> 3 != 0;
        rate = sign ? (float)((double)data / 4.0) : (float)((double)(-1 * (~data + 1)) / 4.0);
        return rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isFiltered(String raw) {
        String checkRaw = this.getOpCodeForFilter(raw);
        if (raw != null) {
            String[] filters;
            for (String s : filters = this.filterField.getText().toUpperCase().split(" ")) {
                if (s.isEmpty() || !checkRaw.toUpperCase().startsWith(s.toUpperCase())) continue;
                MonitorPane monitorPane = this;
                synchronized (monitorPane) {
                    this.linesBuffer.setLength(0);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getOpCodeForFilter(String raw) {
        if (raw != null && raw.length() >= 2) {
            return raw.substring(1, raw.length());
        }
        return null;
    }

    @Override
    public synchronized void message(CanMessage l) {
        log.debug("Message: {}", (Object)l);
        this.format("S", l.isExtended(), l.getHeader(), l.getNumDataElements(), l.getData());
    }

    @Override
    public synchronized void reply(CanReply l) {
        log.debug("Reply: {}", (Object)l);
        this.format("R", l.isExtended(), l.getHeader(), l.getNumDataElements(), l.getData());
    }
}

