/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.send;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.swing.CanPanel;
import jmri.jmrix.openlcb.swing.ClientActions;
import jmri.jmrix.openlcb.swing.DropCdiCache;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.WrapLayout;
import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.DatagramAcknowledgedMessage;
import org.openlcb.DatagramMessage;
import org.openlcb.EventID;
import org.openlcb.EventState;
import org.openlcb.IdentifyConsumersMessage;
import org.openlcb.IdentifyEventsAddressedMessage;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.Message;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.ProtocolIdentification;
import org.openlcb.ProtocolIdentificationRequestMessage;
import org.openlcb.SimpleNodeIdentInfoRequestMessage;
import org.openlcb.VerifyNodeIDNumberGlobalMessage;
import org.openlcb.can.AliasMap;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.EventIdTextField;
import org.openlcb.swing.MemorySpaceSelector;
import org.openlcb.swing.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLcbCanSendPane
extends CanPanel
implements CanListener {
    final JLabel jLabel1 = new JLabel();
    final JButton sendButton = new JButton();
    final JTextField packetTextField = new JTextField(60);
    static final int MAXSEQUENCE = 4;
    final JTextField[] mPacketField = new JTextField[4];
    final JCheckBox[] mUseField = new JCheckBox[4];
    final JTextField[] mDelayField = new JTextField[4];
    final JToggleButton mRunButton = new JToggleButton("Go");
    final JTextField srcAliasField = new JTextField(4);
    NodeSelector nodeSelector;
    final JFormattedTextField sendEventField = new EventIdTextField();
    final JTextField datagramContentsField = new JTextField("20 61 00 00 00 00 08");
    final JTextField configNumberField = new JTextField("40");
    final JTextField configAddressField = new JTextField("000000");
    final JTextField readDataField = new JTextField(60);
    final JTextField writeDataField = new JTextField(60);
    final MemorySpaceSelector addrSpace = new MemorySpaceSelector(255);
    final JComboBox<String> validitySelector = new JComboBox<String>(new String[]{"Unknown", "Valid", "Invalid"});
    JButton cdiButton;
    Connection connection;
    AliasMap aliasMap;
    NodeID srcNodeID;
    MemoryConfigurationService mcs;
    MimicNodeStore store;
    OlcbInterface iface;
    ClientActions actions;
    int mNextSequenceElement = 0;
    Timer timer = null;
    private TrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(OpenLcbCanSendPane.class);

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.iface = memo.get(OlcbInterface.class);
        this.actions = new ClientActions(this.iface, memo);
        this.tc = memo.getTrafficController();
        this.tc.addCanListener(this);
        this.connection = memo.get(Connection.class);
        this.srcNodeID = memo.get(NodeID.class);
        this.aliasMap = memo.get(AliasMap.class);
        Connection.ConnectionListener cl = new Connection.ConnectionListener(){

            public void connectionActive(Connection c) {
                log.debug("connection active");
                OpenLcbCanSendPane.this.srcAliasField.setText(Integer.toHexString(OpenLcbCanSendPane.this.aliasMap.getAlias(OpenLcbCanSendPane.this.srcNodeID)));
            }
        };
        this.connection.registerStartNotification(cl);
        this.mcs = memo.get(MemoryConfigurationService.class);
        this.store = memo.get(MimicNodeStore.class);
        this.nodeSelector = new NodeSelector(this.store);
        this.nodeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenLcbCanSendPane.this.setCdiButton();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getSendSinglePacketJPanel());
        this.add(new JSeparator());
        this.add(new JLabel("Send sequence of frames:"));
        JPanel pane2 = new JPanel();
        pane2.setLayout(new GridLayout2(6, 4));
        pane2.add(new JLabel(""));
        pane2.add(new JLabel("Send"));
        pane2.add(new JLabel("packet"));
        pane2.add(new JLabel("wait (msec)"));
        for (int i = 0; i < 4; ++i) {
            pane2.add(new JLabel(Integer.toString(i + 1)));
            this.mUseField[i] = new JCheckBox();
            this.mPacketField[i] = new JTextField(20);
            this.mDelayField[i] = new JTextField(10);
            pane2.add(this.mUseField[i]);
            pane2.add(this.mPacketField[i]);
            pane2.add(this.mDelayField[i]);
        }
        this.add(pane2);
        this.add(this.mRunButton);
        this.mRunButton.addActionListener(this::runButtonActionPerformed);
        this.add(new JSeparator());
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        pane2.add(new JLabel("Send control frame with source alias:"));
        pane2.add(this.srcAliasField);
        JButton b = new JButton("Send CIM");
        b.addActionListener(this::sendCimPerformed);
        pane2.add(b);
        this.add(new JSeparator());
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        pane2.add(new JLabel("Send OpenLCB global message:"));
        b = new JButton("Send Verify Nodes Global");
        b.addActionListener(this::sendVerifyNodeGlobal);
        pane2.add(b);
        b = new JButton("Send Verify Node Global with NodeID");
        b.addActionListener(this::sendVerifyNodeGlobalID);
        pane2.add(b);
        this.add(new JSeparator());
        JPanel insert = new JPanel();
        insert.setLayout(new WrapLayout());
        insert.add(this.sendEventField);
        insert.add(this.validitySelector);
        this.add(this.addLineLabel("Send OpenLCB event message with eventID:", insert));
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        b = new JButton("Send Request Consumers");
        b.addActionListener(this::sendReqConsumers);
        pane2.add(b);
        b = new JButton("Send Consumer Identified");
        b.addActionListener(this::sendConsumerID);
        pane2.add(b);
        b = new JButton("Send Request Producers");
        b.addActionListener(this::sendReqProducers);
        pane2.add(b);
        b = new JButton("Send Producer Identified");
        b.addActionListener(this::sendProducerID);
        pane2.add(b);
        b = new JButton("Send Event Produced");
        b.addActionListener(this::sendEventPerformed);
        pane2.add(b);
        this.add(new JSeparator());
        this.add(this.addLineLabel("Send OpenLCB addressed message to:", (JComponent)this.nodeSelector));
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        b = new JButton("Send Request Events");
        b.addActionListener(this::sendRequestEvents);
        pane2.add(b);
        b = new JButton("Send PIP Request");
        b.addActionListener(this::sendRequestPip);
        pane2.add(b);
        b = new JButton("Send SNIP Request");
        b.addActionListener(this::sendRequestSnip);
        pane2.add(b);
        this.add(new JSeparator());
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        b = new JButton("Send Datagram");
        b.addActionListener(this::sendDatagramPerformed);
        pane2.add(b);
        pane2.add(new JLabel("Contents: "));
        this.datagramContentsField.setColumns(45);
        pane2.add(this.datagramContentsField);
        b = new JButton("Send Datagram Reply");
        b.addActionListener(this::sendDatagramReply);
        pane2.add(b);
        this.add(new JSeparator());
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        pane2.add(new JLabel("Send OpenLCB memory request with address: "));
        pane2.add(this.configAddressField);
        pane2.add(new JLabel("Address Space: "));
        pane2.add((Component)this.addrSpace);
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        pane2.add(new JLabel("Byte Count: "));
        pane2.add(this.configNumberField);
        b = new JButton("Read");
        b.addActionListener(this::readPerformed);
        pane2.add(b);
        pane2.add(new JLabel("Data: "));
        pane2.add(this.readDataField);
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        b = new JButton("Write");
        b.addActionListener(this::writePerformed);
        pane2.add(b);
        pane2.add(new JLabel("Data: "));
        this.writeDataField.setText("00 00");
        pane2.add(this.writeDataField);
        pane2 = new JPanel();
        pane2.setLayout(new WrapLayout());
        this.add(pane2);
        JButton restartButton = new JButton("Restart");
        pane2.add(restartButton);
        restartButton.addActionListener(this::restartNode);
        this.cdiButton = new JButton("Open CDI Config Tool");
        pane2.add(this.cdiButton);
        this.cdiButton.addActionListener(e -> this.openCdiPane());
        this.cdiButton.setToolTipText("If this button is disabled, please select another node.");
        this.setCdiButton();
        JButton clearCacheButton = new JButton("Clear CDI Cache");
        pane2.add(clearCacheButton);
        clearCacheButton.addActionListener(this::clearCache);
        clearCacheButton.setToolTipText("Closes any open configuration windows and forces a CDI reload");
        this.store.addPropertyChangeListener(e -> this.setCdiButton());
        ThreadingUtil.runOnGUIDelayed(() -> this.setCdiButton(), 500);
    }

    protected void setCdiButton() {
        NodeID nodeID = this.nodeSelector.getSelectedNodeID();
        if (nodeID == null) {
            this.cdiButton.setEnabled(false);
            return;
        }
        ProtocolIdentification pip = this.store.getProtocolIdentification(nodeID);
        if (pip == null || pip.getProtocols() == null) {
            this.cdiButton.setEnabled(false);
            return;
        }
        this.cdiButton.setEnabled(pip.getProtocols().contains(ProtocolIdentification.Protocol.ConfigurationDescription));
    }

    private JPanel getSendSinglePacketJPanel() {
        JPanel outer = new JPanel();
        outer.setLayout(new BoxLayout(outer, 0));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 1));
        this.jLabel1.setText("Single Frame:  (Raw input format is [123] 12 34 56) ");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send frame");
        this.packetTextField.setToolTipText("Frame as hex pairs, e.g. 82 7D; standard header in (), extended in []");
        this.packetTextField.setMaximumSize(this.packetTextField.getPreferredSize());
        pane1.add(this.jLabel1);
        pane1.add(this.packetTextField);
        pane1.add(this.sendButton);
        pane1.add(Box.createVerticalGlue());
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
        outer.add(Box.createHorizontalGlue());
        outer.add(pane1);
        outer.add(Box.createHorizontalGlue());
        return outer;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.send.OpenLcbCanSendFrame";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return this.memo.getUserName() + " Send CAN Frames and OpenLCB Messages";
        }
        return "Send CAN Frames and OpenLCB Messages";
    }

    JComponent addLineLabel(String text) {
        return this.addLineLabel(text, null);
    }

    JComponent addLineLabel(String text, JComponent c) {
        JLabel lab = new JLabel(text);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (c != null) {
            p.add((Component)lab, "East");
            if (c instanceof JTextField) {
                int height = lab.getMinimumSize().height + 4;
                int width = c.getMinimumSize().width;
                Dimension d = new Dimension(width, height);
                c.setMaximumSize(d);
            }
            p.add(c);
        } else {
            p.add((Component)lab, "East");
        }
        p.add(Box.createHorizontalGlue());
        return p;
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        CanMessage m = this.createPacket(input);
        log.debug("sendButtonActionPerformed: {}", (Object)m);
        this.tc.sendCanMessage(m, this);
    }

    public void sendCimPerformed(ActionEvent e) {
        String data = "[10700" + this.srcAliasField.getText() + "]";
        log.debug("sendCimPerformed: |{}|", (Object)data);
        CanMessage m = this.createPacket(data);
        log.debug("sendCimPerformed");
        this.tc.sendCanMessage(m, this);
    }

    NodeID destNodeID() {
        return this.nodeSelector.getSelectedNodeID();
    }

    EventID eventID() {
        return new EventID(StringUtil.bytesFromHexString(this.sendEventField.getText().replace(".", " ")));
    }

    public void sendVerifyNodeGlobal(ActionEvent e) {
        VerifyNodeIDNumberGlobalMessage m = new VerifyNodeIDNumberGlobalMessage(this.srcNodeID);
        this.connection.put((Message)m, null);
    }

    public void sendVerifyNodeGlobalID(ActionEvent e) {
        VerifyNodeIDNumberGlobalMessage m = new VerifyNodeIDNumberGlobalMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void sendRequestEvents(ActionEvent e) {
        IdentifyEventsAddressedMessage m = new IdentifyEventsAddressedMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void sendRequestPip(ActionEvent e) {
        ProtocolIdentificationRequestMessage m = new ProtocolIdentificationRequestMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void sendRequestSnip(ActionEvent e) {
        SimpleNodeIdentInfoRequestMessage m = new SimpleNodeIdentInfoRequestMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void sendEventPerformed(ActionEvent e) {
        ProducerConsumerEventReportMessage m = new ProducerConsumerEventReportMessage(this.srcNodeID, this.eventID());
        this.connection.put((Message)m, null);
    }

    public void sendReqConsumers(ActionEvent e) {
        IdentifyConsumersMessage m = new IdentifyConsumersMessage(this.srcNodeID, this.eventID());
        this.connection.put((Message)m, null);
    }

    EventState validity() {
        switch (this.validitySelector.getSelectedIndex()) {
            case 1: {
                return EventState.Valid;
            }
            case 2: {
                return EventState.Invalid;
            }
        }
        return EventState.Unknown;
    }

    public void sendConsumerID(ActionEvent e) {
        ConsumerIdentifiedMessage m = new ConsumerIdentifiedMessage(this.srcNodeID, this.eventID(), this.validity());
        this.connection.put((Message)m, null);
    }

    public void sendReqProducers(ActionEvent e) {
        IdentifyProducersMessage m = new IdentifyProducersMessage(this.srcNodeID, this.eventID());
        this.connection.put((Message)m, null);
    }

    public void sendProducerID(ActionEvent e) {
        ProducerIdentifiedMessage m = new ProducerIdentifiedMessage(this.srcNodeID, this.eventID(), this.validity());
        this.connection.put((Message)m, null);
    }

    public void sendDatagramPerformed(ActionEvent e) {
        DatagramMessage m = new DatagramMessage(this.srcNodeID, this.destNodeID(), StringUtil.bytesFromHexString(this.datagramContentsField.getText()));
        this.connection.put((Message)m, null);
    }

    public void sendDatagramReply(ActionEvent e) {
        DatagramAcknowledgedMessage m = new DatagramAcknowledgedMessage(this.srcNodeID, this.destNodeID());
        this.connection.put((Message)m, null);
    }

    public void restartNode(ActionEvent e) {
        DatagramMessage m = new DatagramMessage(this.srcNodeID, this.destNodeID(), new byte[]{32, -87});
        this.connection.put((Message)m, null);
    }

    public void clearCache(ActionEvent e) {
        DropCdiCache.drop(this.destNodeID(), this.memo.get(OlcbInterface.class));
    }

    public void readPerformed(ActionEvent e) {
        int space = this.addrSpace.getMemorySpace();
        long addr = Integer.parseInt(this.configAddressField.getText(), 16);
        int length = Integer.parseInt(this.configNumberField.getText());
        this.mcs.requestRead(this.destNodeID(), space, addr, length, new MemoryConfigurationService.McsReadHandler(){

            public void handleReadData(NodeID dest, int space, long address, byte[] data) {
                log.debug("Read data received {} bytes", (Object)data.length);
                OpenLcbCanSendPane.this.readDataField.setText(StringUtil.hexStringFromBytes(data));
            }

            public void handleFailure(int errorCode) {
                log.warn("OpenLCB read failed: 0x{}", (Object)Integer.toHexString(errorCode));
            }
        });
    }

    public void writePerformed(ActionEvent e) {
        int space = this.addrSpace.getMemorySpace();
        long addr = Integer.parseInt(this.configAddressField.getText(), 16);
        byte[] content = StringUtil.bytesFromHexString(this.writeDataField.getText());
        this.mcs.requestWrite(this.destNodeID(), space, addr, content, new MemoryConfigurationService.McsWriteHandler(){

            public void handleSuccess() {
            }

            public void handleFailure(int errorCode) {
                log.warn("OpenLCB write failed:  0x{}", (Object)Integer.toHexString(errorCode));
            }
        });
    }

    public void openCdiPane() {
        this.actions.openCdiWindow(this.destNodeID(), this.destNodeID().toString());
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.sendNextItem());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    protected synchronized void timeout() {
        this.sendNextItem();
    }

    public void runButtonActionPerformed(ActionEvent e) {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        boolean ok = false;
        for (int i = 0; i < 4; ++i) {
            if (!this.mUseField[i].isSelected()) continue;
            ok = true;
        }
        if (!ok) {
            this.mRunButton.setSelected(false);
            return;
        }
        this.mNextSequenceElement = 0;
        this.sendNextItem();
    }

    void startSequenceDelay() {
        int delay = Integer.parseInt(this.mDelayField[this.mNextSequenceElement].getText());
        ++this.mNextSequenceElement;
        this.restartTimer(delay);
    }

    void sendNextItem() {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        if (this.mNextSequenceElement >= 4) {
            this.mNextSequenceElement = 0;
        }
        if (this.mUseField[this.mNextSequenceElement].isSelected()) {
            CanMessage m = this.createPacket(this.mPacketField[this.mNextSequenceElement].getText());
            this.tc.sendCanMessage(m, this);
            this.startSequenceDelay();
        } else {
            ++this.mNextSequenceElement;
            this.sendNextItem();
        }
    }

    CanMessage createPacket(String s) {
        CanMessage m;
        CbusAddress a = new CbusAddress(s);
        if (a.check()) {
            m = a.makeMessage(this.tc.getCanid());
        } else {
            String h;
            int i;
            m = new CanMessage(this.tc.getCanid());
            if (s.charAt(0) == '[') {
                m.setExtended(true);
                i = s.indexOf(93);
                h = s.substring(1, i);
                m.setHeader(Integer.parseInt(h, 16));
                s = s.substring(i + 1);
            } else if (s.charAt(0) == '(') {
                i = s.indexOf(41);
                h = s.substring(1, i);
                m.setHeader(Integer.parseInt(h, 16));
                s = s.substring(i + 1);
            }
            byte[] b = StringUtil.bytesFromHexString(s);
            m.setNumDataElements(b.length);
            for (int i2 = 0; i2 < b.length; ++i2) {
                m.setElement(i2, b[i2] & 0xFF);
            }
        }
        return m;
    }

    @Override
    public void message(CanMessage m) {
    }

    @Override
    public void reply(CanReply m) {
    }

    @Override
    public void dispose() {
        this.mRunButton.setSelected(false);
        super.dispose();
    }
}

