/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.stleditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanelInterface;
import jmri.jmrix.openlcb.OlcbEventNameStore;
import jmri.jmrix.openlcb.swing.stleditor.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openlcb.EventID;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.cdi.cmd.Util;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StlEditorPane
extends JmriPanel
implements CanPanelInterface {
    private static int TOWER_LCC_Q_NODE_VERSION = 109;
    private static String TOWER_LCC_Q_NODE_VERSION_STRING = "v1.09";
    private CanSystemConnectionMemo _canMemo;
    private OlcbInterface _iface;
    private ConfigRepresentation _cdi;
    private MimicNodeStore _store;
    private OlcbEventNameStore _nameStore;
    final String _previewModeCheck = this.getClass().getName() + ".Preview";
    private final UserPreferencesManager _pm;
    private boolean _splitView;
    private boolean _stlPreview;
    private String _storeMode;
    private boolean _dirty = false;
    private int _logicRow = -1;
    private int _groupRow = 0;
    private List<String> _csvMessages = new ArrayList<String>();
    private AtomicInteger _storeQueueLength = new AtomicInteger(0);
    private boolean _compileNeeded = false;
    private boolean _compileInProgress = false;
    PropertyChangeListener _entryListener = new EntryListener();
    private List<String> _messages = new ArrayList<String>();
    private String _csvDirectoryPath = "";
    private DefaultComboBoxModel<NodeEntry> _nodeModel = new DefaultComboBoxModel();
    private JComboBox<NodeEntry> _nodeBox;
    private JComboBox<Operator> _operators = new JComboBox<Operator>(Operator.values());
    private TreeMap<Integer, Token> _tokenMap;
    private List<GroupRow> _groupList = new ArrayList<GroupRow>();
    private List<InputRow> _inputList = new ArrayList<InputRow>();
    private List<OutputRow> _outputList = new ArrayList<OutputRow>();
    private List<ReceiverRow> _receiverList = new ArrayList<ReceiverRow>();
    private List<TransmitterRow> _transmitterList = new ArrayList<TransmitterRow>();
    private JTable _groupTable;
    private JTable _logicTable;
    private JTable _inputTable;
    private JTable _outputTable;
    private JTable _receiverTable;
    private JTable _transmitterTable;
    private JTabbedPane _detailTabs;
    private JTabbedPane _tableTabs;
    private JmriJFrame _tableFrame;
    private JmriJFrame _previewFrame;
    private JTextArea _stlTextArea;
    private JScrollPane _logicScrollPane;
    private JScrollPane _inputPanel;
    private JScrollPane _outputPanel;
    private JScrollPane _receiverPanel;
    private JScrollPane _transmitterPanel;
    private JPanel _editButtons;
    private JButton _addButton;
    private JButton _insertButton;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private JButton _deleteButton;
    private JButton _percentButton;
    private JButton _refreshButton;
    private JButton _storeButton;
    private JButton _exportButton;
    private JButton _importButton;
    private JButton _loadButton;
    private JMenuItem _refreshItem;
    private JMenuItem _storeItem;
    private JMenuItem _exportItem;
    private JMenuItem _importItem;
    private JMenuItem _loadItem;
    private JRadioButtonMenuItem _viewSingle = new JRadioButtonMenuItem(Bundle.getMessage("MenuSingle"));
    private JRadioButtonMenuItem _viewSplit = new JRadioButtonMenuItem(Bundle.getMessage("MenuSplit"));
    private JRadioButtonMenuItem _viewPreview = new JRadioButtonMenuItem(Bundle.getMessage("MenuPreview"));
    private JRadioButtonMenuItem _viewReadable = new JRadioButtonMenuItem(Bundle.getMessage("MenuStoreLINE"));
    private JRadioButtonMenuItem _viewCompact = new JRadioButtonMenuItem(Bundle.getMessage("MenuStoreCLNE"));
    private JRadioButtonMenuItem _viewCompressed = new JRadioButtonMenuItem(Bundle.getMessage("MenuStoreCOMP"));
    private static String INPUT_NAME = "Logic Inputs.Group I%s(%s).Input Description";
    private static String INPUT_TRUE = "Logic Inputs.Group I%s(%s).True";
    private static String INPUT_FALSE = "Logic Inputs.Group I%s(%s).False";
    private static String OUTPUT_NAME = "Logic Outputs.Group Q%s(%s).Output Description";
    private static String OUTPUT_TRUE = "Logic Outputs.Group Q%s(%s).True";
    private static String OUTPUT_FALSE = "Logic Outputs.Group Q%s(%s).False";
    private static String RECEIVER_NAME = "Track Receivers.Rx Circuit(%s).Remote Mast Description";
    private static String RECEIVER_EVENT = "Track Receivers.Rx Circuit(%s).Link Address";
    private static String TRANSMITTER_NAME = "Track Transmitters.Tx Circuit(%s).Track Circuit Description";
    private static String TRANSMITTER_EVENT = "Track Transmitters.Tx Circuit(%s).Link Address";
    private static String GROUP_NAME = "Conditionals.Logic(%s).Group Description";
    private static String GROUP_MULTI_LINE = "Conditionals.Logic(%s).MultiLine";
    private static String SYNTAX_MESSAGE = "Syntax Messages.Syntax Messages.Message 1";
    private static Pattern PARSE_VARIABLE = Pattern.compile("[IQYZM](\\d+)\\.(\\d+)", 2);
    private static Pattern PARSE_NOVAROPER = Pattern.compile("(A\\(|AN\\(|O\\(|ON\\(|X\\(|XN\\(|\\)|NOT|SET|CLR|SAVE)", 2);
    private static Pattern PARSE_LABEL = Pattern.compile("([a-zA-Z]\\w{0,3}:)");
    private static Pattern PARSE_JUMP = Pattern.compile("(JNBI|JCN|JCB|JNB|JBI|JU|JC)", 2);
    private static Pattern PARSE_DEST = Pattern.compile("(\\w{1,4})");
    private static Pattern PARSE_TIMERWORD = Pattern.compile("([W]#[0123]#\\d{1,3})", 2);
    private static Pattern PARSE_TIMERVAR = Pattern.compile("([T]\\d{1,2})", 2);
    private static Pattern PARSE_COMMENT1 = Pattern.compile("//(.*)\\n");
    private static Pattern PARSE_COMMENT2 = Pattern.compile("/\\*(.*?)\\*/");
    private static Pattern PARSE_HEXPAIR = Pattern.compile("^[0-9a-fA-F]{2}$");
    private static Pattern PARSE_VERSION = Pattern.compile("^.*(\\d+)\\.(\\d+)$");
    private static final Logger log = LoggerFactory.getLogger(StlEditorPane.class);

    public StlEditorPane() {
        this._pm = InstanceManager.getDefault(UserPreferencesManager.class);
        this._stlPreview = this._pm.getSimplePreferenceState(this._previewModeCheck);
        Object view = this._pm.getProperty(this.getClass().getName(), "ViewMode");
        this._splitView = view == null ? false : "SPLIT".equals(view);
        Object mode = this._pm.getProperty(this.getClass().getName(), "StoreMode");
        this._storeMode = mode == null ? "LINE" : (String)mode;
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this._canMemo = memo;
        this._iface = memo.get(OlcbInterface.class);
        this._store = memo.get(MimicNodeStore.class);
        this._nameStore = memo.get(OlcbEventNameStore.class);
        this.setLayout(new BorderLayout());
        JPanel footer = new JPanel();
        footer.setLayout(new BorderLayout());
        this._addButton = new JButton(Bundle.getMessage("ButtonAdd"));
        this._insertButton = new JButton(Bundle.getMessage("ButtonInsert"));
        this._moveUpButton = new JButton(Bundle.getMessage("ButtonMoveUp"));
        this._moveDownButton = new JButton(Bundle.getMessage("ButtonMoveDown"));
        this._deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        this._percentButton = new JButton("0%");
        this._refreshButton = new JButton(Bundle.getMessage("ButtonRefresh"));
        this._storeButton = new JButton(Bundle.getMessage("ButtonStore"));
        this._exportButton = new JButton(Bundle.getMessage("ButtonExport"));
        this._importButton = new JButton(Bundle.getMessage("ButtonImport"));
        this._loadButton = new JButton(Bundle.getMessage("ButtonLoad"));
        this._refreshButton.setEnabled(false);
        this._storeButton.setEnabled(false);
        this._addButton.addActionListener(this::pushedAddButton);
        this._insertButton.addActionListener(this::pushedInsertButton);
        this._moveUpButton.addActionListener(this::pushedMoveUpButton);
        this._moveDownButton.addActionListener(this::pushedMoveDownButton);
        this._deleteButton.addActionListener(this::pushedDeleteButton);
        this._percentButton.addActionListener(this::pushedPercentButton);
        this._refreshButton.addActionListener(this::pushedRefreshButton);
        this._storeButton.addActionListener(this::pushedStoreButton);
        this._exportButton.addActionListener(this::pushedExportButton);
        this._importButton.addActionListener(this::pushedImportButton);
        this._loadButton.addActionListener(this::loadBackupData);
        this._editButtons = new JPanel();
        this._editButtons.add(this._addButton);
        this._editButtons.add(this._insertButton);
        this._editButtons.add(this._moveUpButton);
        this._editButtons.add(this._moveDownButton);
        this._editButtons.add(this._deleteButton);
        this._editButtons.add(this._percentButton);
        footer.add((Component)this._editButtons, "West");
        JPanel dataButtons = new JPanel();
        dataButtons.add(this._loadButton);
        dataButtons.add(new JLabel(" | "));
        dataButtons.add(this._importButton);
        dataButtons.add(this._exportButton);
        dataButtons.add(new JLabel(" | "));
        dataButtons.add(this._refreshButton);
        dataButtons.add(this._storeButton);
        footer.add((Component)dataButtons, "East");
        this.add((Component)footer, "South");
        JPanel nodeSelector = new JPanel();
        nodeSelector.setLayout(new FlowLayout());
        this._nodeBox = new JComboBox<NodeEntry>(this._nodeModel);
        for (MimicNodeStore.NodeMemo nodeMemo : this._store.getNodeMemos()) {
            this.newNodeInList(nodeMemo);
        }
        this._nodeBox.addActionListener(this::nodeSelected);
        JComboBoxUtil.setupComboBoxMaxRows(this._nodeBox);
        Dimension dim = this._nodeBox.getPreferredSize();
        Dimension newDim = new Dimension(400, (int)dim.getHeight());
        this._nodeBox.setPreferredSize(newDim);
        nodeSelector.add(this._nodeBox);
        JPanel header = new JPanel();
        header.setLayout(new BorderLayout());
        header.add((Component)nodeSelector, "Center");
        this.add((Component)header, "North");
        this._detailTabs = new JTabbedPane();
        this._detailTabs.add(Bundle.getMessage("ButtonG"), this.buildLogicPanel());
        this._inputPanel = this.buildInputPanel();
        this._outputPanel = this.buildOutputPanel();
        this._receiverPanel = this.buildReceiverPanel();
        this._transmitterPanel = this.buildTransmitterPanel();
        this._detailTabs.addChangeListener(this::tabSelected);
        this._detailTabs.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this._detailTabs, "Center");
        this.initalizeLists();
    }

    private JScrollPane buildGroupPanel() {
        GroupModel model = new GroupModel();
        this._groupTable = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(this._groupTable);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._groupTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._groupTable.setFont(new Font("Monospaced", 0, 12));
        ListSelectionModel selectionModel = this._groupTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this::handleGroupRowSelection);
        return scrollPane;
    }

    private JSplitPane buildLogicPanel() {
        LogicModel model = new LogicModel();
        this._logicTable = new JTable(model);
        this._logicScrollPane = new JScrollPane(this._logicTable);
        for (int i = 0; i < this._logicTable.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._logicTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._logicTable.setFont(new Font("Monospaced", 0, 12));
        TableColumn col = this._logicTable.getColumnModel().getColumn(1);
        col.setCellEditor(new DefaultCellEditor(this._operators));
        JComboBoxUtil.setupComboBoxMaxRows(this._operators);
        ListSelectionModel selectionModel = this._logicTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this::handleLogicRowSelection);
        JSplitPane logicPanel = new JSplitPane(1, this.buildGroupPanel(), this._logicScrollPane);
        logicPanel.setDividerSize(10);
        logicPanel.setResizeWeight(0.1);
        logicPanel.setDividerLocation(150);
        return logicPanel;
    }

    private JScrollPane buildInputPanel() {
        InputModel model = new InputModel();
        this._inputTable = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(this._inputTable);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._inputTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._inputTable.setFont(new Font("Monospaced", 0, 12));
        ListSelectionModel selectionModel = this._inputTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        CopyRowListener copyRowListener = new CopyRowListener();
        this._inputTable.addMouseListener(JmriMouseListener.adapt(copyRowListener));
        return scrollPane;
    }

    private JScrollPane buildOutputPanel() {
        OutputModel model = new OutputModel();
        this._outputTable = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(this._outputTable);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._outputTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._outputTable.setFont(new Font("Monospaced", 0, 12));
        ListSelectionModel selectionModel = this._outputTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        CopyRowListener copyRowListener = new CopyRowListener();
        this._outputTable.addMouseListener(JmriMouseListener.adapt(copyRowListener));
        return scrollPane;
    }

    private JScrollPane buildReceiverPanel() {
        ReceiverModel model = new ReceiverModel();
        this._receiverTable = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(this._receiverTable);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._receiverTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._receiverTable.setFont(new Font("Monospaced", 0, 12));
        ListSelectionModel selectionModel = this._receiverTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        CopyRowListener copyRowListener = new CopyRowListener();
        this._receiverTable.addMouseListener(JmriMouseListener.adapt(copyRowListener));
        return scrollPane;
    }

    private JScrollPane buildTransmitterPanel() {
        TransmitterModel model = new TransmitterModel();
        this._transmitterTable = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(this._transmitterTable);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._transmitterTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._transmitterTable.setFont(new Font("Monospaced", 0, 12));
        ListSelectionModel selectionModel = this._transmitterTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        CopyRowListener copyRowListener = new CopyRowListener();
        this._transmitterTable.addMouseListener(JmriMouseListener.adapt(copyRowListener));
        return scrollPane;
    }

    private void tabSelected(ChangeEvent e) {
        if (this._detailTabs.getSelectedIndex() == 0) {
            this._editButtons.setVisible(true);
        } else {
            this._editButtons.setVisible(false);
        }
    }

    private void initalizeLists() {
        int i;
        for (i = 0; i < 16; ++i) {
            this._groupList.add(new GroupRow(""));
        }
        for (i = 0; i < 128; ++i) {
            this._inputList.add(new InputRow("", "", ""));
        }
        for (i = 0; i < 128; ++i) {
            this._outputList.add(new OutputRow("", "", ""));
        }
        for (i = 0; i < 16; ++i) {
            this._receiverList.add(new ReceiverRow("", ""));
        }
        for (i = 0; i < 16; ++i) {
            this._transmitterList.add(new TransmitterRow("", ""));
        }
    }

    private void handleGroupRowSelection(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this._groupRow = this._groupTable.getSelectedRow();
            this._logicTable.revalidate();
            this._logicTable.repaint();
            this.pushedPercentButton(null);
        }
    }

    private void pushedPercentButton(ActionEvent e) {
        this.encode(this._groupList.get(this._groupRow));
        this._percentButton.setText(this._groupList.get(this._groupRow).getSize());
    }

    private void handleLogicRowSelection(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this._logicRow = this._logicTable.getSelectedRow();
            this._moveUpButton.setEnabled(this._logicRow > 0);
            this._moveDownButton.setEnabled(this._logicRow < this._logicTable.getRowCount() - 1);
        }
    }

    private void pushedAddButton(ActionEvent e) {
        List<LogicRow> logicList = this._groupList.get(this._groupRow).getLogicList();
        logicList.add(new LogicRow("", null, "", ""));
        this._logicRow = logicList.size() - 1;
        this._logicTable.revalidate();
        this._logicTable.setRowSelectionInterval(this._logicRow, this._logicRow);
        this.setDirty(true);
    }

    private void pushedInsertButton(ActionEvent e) {
        List<LogicRow> logicList = this._groupList.get(this._groupRow).getLogicList();
        if (this._logicRow >= 0 && this._logicRow < logicList.size()) {
            logicList.add(this._logicRow, new LogicRow("", null, "", ""));
            this._logicTable.revalidate();
            this._logicTable.setRowSelectionInterval(this._logicRow, this._logicRow);
        }
        this.setDirty(true);
    }

    private void pushedMoveUpButton(ActionEvent e) {
        List<LogicRow> logicList = this._groupList.get(this._groupRow).getLogicList();
        if (this._logicRow >= 0 && this._logicRow < logicList.size()) {
            LogicRow logicRow = logicList.remove(this._logicRow);
            logicList.add(this._logicRow - 1, logicRow);
            --this._logicRow;
            this._logicTable.revalidate();
            this._logicTable.setRowSelectionInterval(this._logicRow, this._logicRow);
        }
        this.setDirty(true);
    }

    private void pushedMoveDownButton(ActionEvent e) {
        List<LogicRow> logicList = this._groupList.get(this._groupRow).getLogicList();
        if (this._logicRow >= 0 && this._logicRow < logicList.size()) {
            LogicRow logicRow = logicList.remove(this._logicRow);
            logicList.add(this._logicRow + 1, logicRow);
            ++this._logicRow;
            this._logicTable.revalidate();
            this._logicTable.setRowSelectionInterval(this._logicRow, this._logicRow);
        }
        this.setDirty(true);
    }

    private void pushedDeleteButton(ActionEvent e) {
        List<LogicRow> logicList = this._groupList.get(this._groupRow).getLogicList();
        if (this._logicRow >= 0 && this._logicRow < logicList.size()) {
            logicList.remove(this._logicRow);
            this._logicTable.revalidate();
        }
        this.setDirty(true);
    }

    private String nameToVariable(String name) {
        if (name != null && !name.isEmpty()) {
            int i;
            if (!name.contains("~")) {
                int row;
                int j;
                int i2;
                for (i2 = 0; i2 < 16; ++i2) {
                    for (j = 0; j < 8; ++j) {
                        row = i2 * 8 + j;
                        if (!this._inputList.get(row).getName().equals(name)) continue;
                        return "I" + i2 + "." + j;
                    }
                }
                for (i2 = 0; i2 < 16; ++i2) {
                    for (j = 0; j < 8; ++j) {
                        row = i2 * 8 + j;
                        if (!this._outputList.get(row).getName().equals(name)) continue;
                        return "Q" + i2 + "." + j;
                    }
                }
                return name;
            }
            String[] splitName = name.split("~");
            String baseName = splitName[0];
            String aspectName = splitName[1];
            int aspectNumber = 0;
            try {
                aspectNumber = Integer.parseInt(aspectName);
                if (aspectNumber < 0 || aspectNumber > 7) {
                    this.warningDialog(Bundle.getMessage("TitleAspect"), Bundle.getMessage("MessageAspect", aspectNumber));
                    aspectNumber = 0;
                }
            }
            catch (NumberFormatException e) {
                this.warningDialog(Bundle.getMessage("TitleAspect"), Bundle.getMessage("MessageAspect", aspectName));
                aspectNumber = 0;
            }
            for (i = 0; i < 16; ++i) {
                if (!this._receiverList.get(i).getName().equals(baseName)) continue;
                return "Y" + i + "." + aspectNumber;
            }
            for (i = 0; i < 16; ++i) {
                if (!this._transmitterList.get(i).getName().equals(baseName)) continue;
                return "Z" + i + "." + aspectNumber;
            }
            return name;
        }
        return null;
    }

    private String variableToName(String variable) {
        Object name = variable;
        if (variable.length() > 1) {
            String varType = variable.substring(0, 1);
            Matcher match = PARSE_VARIABLE.matcher(variable);
            if (match.find() && match.groupCount() == 2) {
                int first = -1;
                int second = -1;
                int row = -1;
                try {
                    first = Integer.parseInt(match.group(1));
                    second = Integer.parseInt(match.group(2));
                }
                catch (NumberFormatException e) {
                    this.warningDialog(Bundle.getMessage("TitleVariable"), Bundle.getMessage("MessageVariable", variable));
                    return name;
                }
                switch (varType) {
                    case "I": {
                        row = first * 8 + second;
                        name = this._inputList.get(row).getName();
                        if (!((String)name).isEmpty()) break;
                        name = variable;
                        break;
                    }
                    case "Q": {
                        row = first * 8 + second;
                        name = this._outputList.get(row).getName();
                        if (!((String)name).isEmpty()) break;
                        name = variable;
                        break;
                    }
                    case "Y": {
                        row = first;
                        name = this._receiverList.get(row).getName() + "~" + second;
                        break;
                    }
                    case "Z": {
                        row = first;
                        name = this._transmitterList.get(row).getName() + "~" + second;
                        break;
                    }
                    case "M": {
                        break;
                    }
                    default: {
                        log.error("Variable '{}' has an invalid first letter (IQYZM)", (Object)variable);
                    }
                }
            }
        }
        return name;
    }

    private void encode(GroupRow groupRow) {
        Object longLine = "";
        String separator = this._storeMode.equals("LINE") ? " " : "";
        List<LogicRow> logicList = groupRow.getLogicList();
        for (LogicRow row : logicList) {
            StringBuilder sb = new StringBuilder();
            boolean jumpLabel = false;
            if (!row.getLabel().isEmpty()) {
                sb.append(row.getLabel() + " ");
            }
            if (row.getOper() != null) {
                Operator oper = row.getOper();
                String operName = oper.name();
                if (operName.equals("Cp")) {
                    operName = ")";
                } else if (operName.equals("EQ")) {
                    operName = "=";
                } else if (operName.contains("p")) {
                    operName = operName.replace("p", "(");
                }
                if (operName.startsWith("J")) {
                    jumpLabel = true;
                }
                sb.append(operName);
            }
            if (!row.getName().isEmpty()) {
                String name = row.getName().trim();
                if (jumpLabel) {
                    sb.append(" " + name + "\n");
                    jumpLabel = false;
                } else if (this.isMemory(name)) {
                    sb.append(separator + name);
                } else if (this.isTimerWord(name)) {
                    sb.append(separator + name);
                } else if (this.isTimerVar(name)) {
                    sb.append(separator + name);
                } else {
                    String variable = this.nameToVariable(name);
                    if (variable == null) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MessageBadName", groupRow.getName(), name), Bundle.getMessage("TitleBadName"), 0);
                        log.error("bad name: {}", (Object)name);
                    } else {
                        sb.append(separator + variable);
                    }
                }
            }
            if (!row.getComment().isEmpty()) {
                String comment = row.getComment().trim();
                sb.append(separator + "//" + separator + comment);
                if (this._storeMode.equals("COMP")) {
                    sb.append("\n");
                }
            }
            if (!this._storeMode.equals("COMP")) {
                sb.append("\n");
            }
            longLine = (String)longLine + sb.toString();
        }
        log.debug("MultiLine: {}", longLine);
        if (((String)longLine).length() < 256) {
            groupRow.setMultiLine((String)longLine);
        } else {
            String overflow = ((String)longLine).substring(255);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MessageOverflow", groupRow.getName(), overflow), Bundle.getMessage("TitleOverflow"), 0);
            log.error("The line overflowed, content truncated:  {}", (Object)overflow);
        }
        if (this._stlPreview) {
            this._stlTextArea.setText(Bundle.getMessage("PreviewHeader", groupRow.getName()));
            this._stlTextArea.append((String)longLine);
        }
    }

    private boolean isMemory(String name) {
        Matcher match = PARSE_VARIABLE.matcher(name);
        return match.find() && name.startsWith("M");
    }

    private boolean isTimerWord(String name) {
        Matcher match = PARSE_TIMERWORD.matcher(name);
        return match.find();
    }

    private boolean isTimerVar(String name) {
        Matcher match = PARSE_TIMERVAR.matcher(name);
        if (match.find()) {
            return match.group(1).equals(name);
        }
        return false;
    }

    private void decode(GroupRow group) {
        this.createTokenMap(group);
        for (Token token : this._tokenMap.values()) {
            Integer nextKey;
            Token prevToken;
            if (!token.getType().equals("Oper")) continue;
            String label = "";
            String name = "";
            String comment = "";
            Operator oper = this.getEnum(token.getName());
            Integer prevKey = this._tokenMap.lowerKey(token.getStart());
            if (prevKey != null && (prevToken = this._tokenMap.get(prevKey)).getType().equals("Label")) {
                label = prevToken.getName();
            }
            if ((nextKey = this._tokenMap.higherKey(token.getStart())) != null) {
                Token nextToken = this._tokenMap.get(nextKey);
                if (nextToken.getType().equals("Comment")) {
                    comment = this.variableToName(nextToken.getName());
                } else if (!nextToken.getType().equals("Label") && !nextToken.getType().equals("Oper")) {
                    Token comToken;
                    name = this.variableToName(nextToken.getName());
                    Integer comKey = this._tokenMap.higherKey(nextKey);
                    if (comKey != null && (comToken = this._tokenMap.get(comKey)).getType().equals("Comment")) {
                        comment = comToken.getName();
                    }
                }
            }
            LogicRow logic = new LogicRow(label, oper, name, comment);
            group.getLogicList().add(logic);
        }
    }

    private void createTokenMap(GroupRow group) {
        this._messages.clear();
        this._tokenMap = new TreeMap();
        String line = group.getMultiLine();
        Matcher matchLabel = PARSE_LABEL.matcher(line);
        while (matchLabel.find()) {
            String label = line.substring(matchLabel.start(), matchLabel.end());
            this._tokenMap.put(matchLabel.start(), new Token("Label", label, matchLabel.start(), matchLabel.end()));
        }
        Matcher matchVar = PARSE_VARIABLE.matcher(line);
        while (matchVar.find()) {
            String variable = line.substring(matchVar.start(), matchVar.end());
            this._tokenMap.put(matchVar.start(), new Token("Var", variable, matchVar.start(), matchVar.end()));
            Token operToken = this.findOperator(matchVar.start() - 1, line);
            if (operToken == null) continue;
            this._tokenMap.put(operToken.getStart(), operToken);
        }
        Matcher matchOper = PARSE_NOVAROPER.matcher(line);
        while (matchOper.find()) {
            String oper = line.substring(matchOper.start(), matchOper.end());
            if (this.isOperInComment(line, matchOper.start())) continue;
            if (this.getEnum(oper) != null) {
                this._tokenMap.put(matchOper.start(), new Token("Oper", oper, matchOper.start(), matchOper.end()));
                continue;
            }
            this._messages.add(Bundle.getMessage("ErrStandAlone", oper));
        }
        Matcher matchJump = PARSE_JUMP.matcher(line);
        while (matchJump.find()) {
            String jump = line.substring(matchJump.start(), matchJump.end());
            if (this.getEnum(jump) != null && (jump.startsWith("J") || jump.startsWith("j"))) {
                this._tokenMap.put(matchJump.start(), new Token("Oper", jump, matchJump.start(), matchJump.end()));
                Matcher matchDest = PARSE_DEST.matcher(line);
                if (matchDest.find(matchJump.end())) {
                    String dest = matchDest.group(1);
                    this._tokenMap.put(matchDest.start(), new Token("Dest", dest, matchDest.start(), matchDest.end()));
                    continue;
                }
                this._messages.add(Bundle.getMessage("ErrJumpDest", jump));
                continue;
            }
            this._messages.add(Bundle.getMessage("ErrJumpOper", jump));
        }
        Matcher matchTimerWord = PARSE_TIMERWORD.matcher(line);
        while (matchTimerWord.find()) {
            String timerWord = matchTimerWord.group(1);
            this._tokenMap.put(matchTimerWord.start(), new Token("TimerWord", timerWord, matchTimerWord.start(), matchTimerWord.end()));
            Token operToken = this.findOperator(matchTimerWord.start() - 1, line);
            if (operToken == null) continue;
            if (operToken.getName().equals("L") || operToken.getName().equals("l")) {
                this._tokenMap.put(operToken.getStart(), operToken);
                continue;
            }
            this._messages.add(Bundle.getMessage("ErrTimerLoad", operToken.getName()));
        }
        Matcher matchTimerVar = PARSE_TIMERVAR.matcher(line);
        while (matchTimerVar.find()) {
            String timerVar = matchTimerVar.group(1);
            this._tokenMap.put(matchTimerVar.start(), new Token("TimerVar", timerVar, matchTimerVar.start(), matchTimerVar.end()));
            Token operToken = this.findOperator(matchTimerVar.start() - 1, line);
            if (operToken == null) continue;
            this._tokenMap.put(operToken.getStart(), operToken);
        }
        Matcher matchComment1 = PARSE_COMMENT1.matcher(line);
        while (matchComment1.find()) {
            String comment = matchComment1.group(1).trim();
            this._tokenMap.put(matchComment1.start(), new Token("Comment", comment, matchComment1.start(), matchComment1.end()));
        }
        Matcher matchComment2 = PARSE_COMMENT2.matcher(line);
        while (matchComment2.find()) {
            String comment = matchComment2.group(1).trim();
            this._tokenMap.put(matchComment2.start(), new Token("Comment", comment, matchComment2.start(), matchComment2.end()));
        }
        for (Token token : this._tokenMap.values()) {
            Token nextToken;
            Integer nextKey;
            if (!token.getType().equals("Dest") || (nextKey = this._tokenMap.higherKey(token.getStart())) == null || !(nextToken = this._tokenMap.get(nextKey)).getType().equals("Label") || token.getEnd() <= nextToken.getStart()) continue;
            this._messages.add(Bundle.getMessage("ErrDestLabel", token.getName(), nextToken.getName()));
        }
        if (this._messages.size() > 0) {
            String msgs = this._messages.stream().collect(Collectors.joining("\n"));
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MsgParseErr", group.getName(), msgs), Bundle.getMessage("TitleParseErr"), 0);
            this._messages.forEach(msg -> log.error(msg));
        }
        if (log.isDebugEnabled()) {
            log.info("Line = {}", (Object)line);
            for (Token token : this._tokenMap.values()) {
                log.info("Token = {}", (Object)token);
            }
        }
    }

    private Token findOperator(int index, String line) {
        StringBuilder sb = new StringBuilder();
        for (int limit = 10; limit > 0 && index >= 0; --limit, --index) {
            char ch = line.charAt(index);
            if (ch == ' ') continue;
            sb.insert(0, ch);
            if (this.getEnum(sb.toString()) == null) continue;
            String oper = sb.toString();
            return new Token("Oper", oper, index, index + oper.length());
        }
        this._messages.add(Bundle.getMessage("ErrNoOper", index, line));
        log.error("findOperator: {} :: {}", (Object)index, (Object)line);
        return null;
    }

    private boolean isOperInComment(String line, int index) {
        int previous = 0;
        for (int limit = 20; limit > 0 && index >= 0; --index, --limit) {
            char ch = line.charAt(index);
            if (ch == '\n') {
                return false;
            }
            if (ch == '*' && previous == 47) {
                return false;
            }
            if (ch == '/' && (previous == 47 || previous == 42)) {
                return true;
            }
            previous = ch;
        }
        return false;
    }

    private Operator getEnum(String name) {
        try {
            String temp = name.toUpperCase();
            if (name.equals("=")) {
                temp = "EQ";
            } else if (name.equals(")")) {
                temp = "Cp";
            } else if (name.endsWith("(")) {
                temp = name.toUpperCase().replace("(", "p");
            }
            Operator oper = Enum.valueOf(Operator.class, temp);
            return oper;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private void nodeSelected(ActionEvent e) {
        NodeEntry node = (NodeEntry)this._nodeBox.getSelectedItem();
        node.getNodeMemo().addPropertyChangeListener((PropertyChangeListener)new RebootListener());
        log.debug("nodeSelected: {}", (Object)node);
        if (this.isValidNodeVersionNumber(node.getNodeMemo())) {
            this._cdi = this._iface.getConfigForNode(node.getNodeID());
            this._cdi.eventNameStore = this._canMemo.get(OlcbEventNameStore.class);
            if (this._cdi.getRoot() != null) {
                this.loadCdiData();
            } else {
                JmriJOptionPane.showMessageDialogNonModal(this, Bundle.getMessage("MessageCdiLoad", node), Bundle.getMessage("TitleCdiLoad"), 1, null);
                this._cdi.addPropertyChangeListener((PropertyChangeListener)new CdiListener());
            }
        }
    }

    private void newNodeInList(MimicNodeStore.NodeMemo nodeMemo) {
        int i;
        NodeID node = nodeMemo.getNodeID();
        String id = node.toString();
        log.debug("node id: {}", (Object)id);
        if (!id.startsWith("02.01.57.4")) {
            return;
        }
        if (this._nodeModel.getIndexOf(nodeMemo.getNodeID()) >= 0) {
            return;
        }
        NodeEntry e = new NodeEntry(nodeMemo);
        for (i = 0; i < this._nodeModel.getSize() && this._nodeModel.getElementAt(i).compareTo(e) < 0; ++i) {
        }
        this._nodeModel.insertElementAt(e, i);
    }

    private boolean isValidNodeVersionNumber(MimicNodeStore.NodeMemo nodeMemo) {
        SimpleNodeIdent ident = nodeMemo.getSimpleNodeIdent();
        String versionString = ident.getSoftwareVersion();
        int version = 0;
        Matcher match = PARSE_VERSION.matcher(versionString);
        if (match.find()) {
            String major = match.group(1);
            String minor = match.group(2);
            version = Integer.parseInt(major + minor);
        }
        if (version < TOWER_LCC_Q_NODE_VERSION) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MessageVersion", nodeMemo.getNodeID(), versionString, TOWER_LCC_Q_NODE_VERSION_STRING), Bundle.getMessage("TitleVersion"), 2);
            return false;
        }
        return true;
    }

    private void displayStoreDone() {
        this._csvMessages.add(Bundle.getMessage("StoreDone"));
        int msgType = 0;
        if (this._csvMessages.size() == 1) {
            msgType = 1;
        }
        JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"\n", this._csvMessages), Bundle.getMessage("TitleCdiStore"), msgType);
        if (this._compileNeeded) {
            log.debug("Display compile needed message");
            Object[] options = new String[]{Bundle.getMessage("EditorReboot"), Bundle.getMessage("CdiReboot")};
            int response = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("MessageCdiReboot"), Bundle.getMessage("TitleCdiReboot"), 0, 3, null, options, options[0]);
            if (response == 0) {
                this._compileInProgress = true;
                this._cdi.getConnection().getDatagramService().sendData(this._cdi.getRemoteNodeID(), new int[]{32, 169});
            }
        }
    }

    private void getCompileMessage() {
        ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(SYNTAX_MESSAGE);
        entry.addPropertyChangeListener(this._entryListener);
        entry.reload();
    }

    private void displayCompileMessage(String message) {
        this._compileInProgress = false;
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MessageCompile", message), Bundle.getMessage("TitleCompile"), 1);
    }

    public void updateComboBoxModelEntry(NodeEntry nodeEntry) {
        int idx = this._nodeModel.getIndexOf(nodeEntry.getNodeID());
        if (idx < 0) {
            return;
        }
        NodeEntry last = this._nodeModel.getElementAt(idx);
        if (last != nodeEntry) {
            nodeEntry.dispose();
            return;
        }
        NodeEntry sel = (NodeEntry)this._nodeModel.getSelectedItem();
        this._nodeModel.removeElementAt(idx);
        this._nodeModel.insertElementAt(nodeEntry, idx);
        this._nodeModel.setSelectedItem(sel);
    }

    private void loadCdiData() {
        if (!this.replaceData()) {
            return;
        }
        this.loadCdiInputs();
        this.loadCdiOutputs();
        this.loadCdiReceivers();
        this.loadCdiTransmitters();
        this.loadCdiGroups();
        for (GroupRow row : this._groupList) {
            this.decode(row);
        }
        this.setDirty(false);
        this._groupTable.setRowSelectionInterval(0, 0);
        this._groupTable.repaint();
        this._exportButton.setEnabled(true);
        this._refreshButton.setEnabled(true);
        this._storeButton.setEnabled(true);
        this._exportItem.setEnabled(true);
        this._refreshItem.setEnabled(true);
        this._storeItem.setEnabled(true);
        if (this._splitView) {
            this._tableTabs.repaint();
        }
    }

    private void pushedRefreshButton(ActionEvent e) {
        this.loadCdiData();
    }

    private void loadCdiGroups() {
        for (int i = 0; i < 16; ++i) {
            GroupRow groupRow = this._groupList.get(i);
            groupRow.clearLogicList();
            ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(GROUP_NAME, i));
            groupRow.setName(entry.getValue());
            entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(GROUP_MULTI_LINE, i));
            groupRow.setMultiLine(entry.getValue());
        }
        this._groupTable.revalidate();
    }

    private void loadCdiInputs() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                InputRow inputRow = this._inputList.get(i * 8 + j);
                ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(INPUT_NAME, i, j));
                inputRow.setName(entry.getValue());
                ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(INPUT_TRUE, i, j));
                inputRow.setEventTrue(event.getNumericalEventValue());
                event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(INPUT_FALSE, i, j));
                inputRow.setEventFalse(event.getNumericalEventValue());
            }
        }
        this._inputTable.revalidate();
    }

    private void loadCdiOutputs() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                OutputRow outputRow = this._outputList.get(i * 8 + j);
                ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(OUTPUT_NAME, i, j));
                outputRow.setName(entry.getValue());
                ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(OUTPUT_TRUE, i, j));
                outputRow.setEventTrue(event.getNumericalEventValue());
                event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(OUTPUT_FALSE, i, j));
                outputRow.setEventFalse(event.getNumericalEventValue());
            }
        }
        this._outputTable.revalidate();
    }

    private void loadCdiReceivers() {
        for (int i = 0; i < 16; ++i) {
            ReceiverRow receiverRow = this._receiverList.get(i);
            ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(RECEIVER_NAME, i));
            receiverRow.setName(entry.getValue());
            ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(RECEIVER_EVENT, i));
            receiverRow.setEventId(event.getNumericalEventValue());
        }
        this._receiverTable.revalidate();
    }

    private void loadCdiTransmitters() {
        for (int i = 0; i < 16; ++i) {
            TransmitterRow transmitterRow = this._transmitterList.get(i);
            ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(TRANSMITTER_NAME, i));
            transmitterRow.setName(entry.getValue());
            ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(TRANSMITTER_EVENT, i));
            transmitterRow.setEventId(event.getNumericalEventValue());
        }
        this._transmitterTable.revalidate();
    }

    private void pushedStoreButton(ActionEvent e) {
        this._csvMessages.clear();
        this._compileNeeded = false;
        this._storeQueueLength.set(0);
        this.storeInputs();
        this.storeOutputs();
        this.storeReceivers();
        this.storeTransmitters();
        this.storeGroups();
        this.setDirty(false);
    }

    private void storeGroups() {
        int currentCount = 0;
        for (int i = 0; i < 16; ++i) {
            GroupRow row = this._groupList.get(i);
            this.encode(row);
            ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(GROUP_NAME, i));
            if (!row.getName().equals(entry.getValue())) {
                entry.addPropertyChangeListener(this._entryListener);
                entry.setValue(row.getName());
                currentCount = this._storeQueueLength.incrementAndGet();
            }
            entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(GROUP_MULTI_LINE, i));
            if (!row.getMultiLine().equals(entry.getValue())) {
                entry.addPropertyChangeListener(this._entryListener);
                entry.setValue(row.getMultiLine());
                currentCount = this._storeQueueLength.incrementAndGet();
                this._compileNeeded = true;
            }
            log.debug("Group: {}", (Object)row.getName());
            log.debug("Logic: {}", (Object)row.getMultiLine());
        }
        log.debug("storeGroups count = {}", (Object)currentCount);
    }

    private void storeInputs() {
        int currentCount = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                InputRow row = this._inputList.get(i * 8 + j);
                ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(INPUT_NAME, i, j));
                if (!row.getName().equals(entry.getValue())) {
                    entry.addPropertyChangeListener(this._entryListener);
                    entry.setValue(row.getName());
                    currentCount = this._storeQueueLength.incrementAndGet();
                }
                ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(INPUT_TRUE, i, j));
                if (!row.getEventTrue().equals(event.getValue())) {
                    event.addPropertyChangeListener(this._entryListener);
                    event.setValue(row.getEventTrue());
                    currentCount = this._storeQueueLength.incrementAndGet();
                }
                event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(INPUT_FALSE, i, j));
                if (row.getEventFalse().equals(event.getValue())) continue;
                event.addPropertyChangeListener(this._entryListener);
                event.setValue(row.getEventFalse());
                currentCount = this._storeQueueLength.incrementAndGet();
            }
        }
        log.debug("storeInputs count = {}", (Object)currentCount);
    }

    private void storeOutputs() {
        int currentCount = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                OutputRow row = this._outputList.get(i * 8 + j);
                ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(OUTPUT_NAME, i, j));
                if (!row.getName().equals(entry.getValue())) {
                    entry.addPropertyChangeListener(this._entryListener);
                    entry.setValue(row.getName());
                    currentCount = this._storeQueueLength.incrementAndGet();
                }
                ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(OUTPUT_TRUE, i, j));
                if (!row.getEventTrue().equals(event.getValue())) {
                    event.addPropertyChangeListener(this._entryListener);
                    event.setValue(row.getEventTrue());
                    currentCount = this._storeQueueLength.incrementAndGet();
                }
                event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(OUTPUT_FALSE, i, j));
                if (row.getEventFalse().equals(event.getValue())) continue;
                event.addPropertyChangeListener(this._entryListener);
                event.setValue(row.getEventFalse());
                currentCount = this._storeQueueLength.incrementAndGet();
            }
        }
        log.debug("storeOutputs count = {}", (Object)currentCount);
    }

    private void storeReceivers() {
        int currentCount = 0;
        for (int i = 0; i < 16; ++i) {
            ReceiverRow row = this._receiverList.get(i);
            ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(RECEIVER_NAME, i));
            if (!row.getName().equals(entry.getValue())) {
                entry.addPropertyChangeListener(this._entryListener);
                entry.setValue(row.getName());
                currentCount = this._storeQueueLength.incrementAndGet();
            }
            ConfigRepresentation.EventEntry event = (ConfigRepresentation.EventEntry)this._cdi.getVariableForKey(String.format(RECEIVER_EVENT, i));
            if (row.getEventId().equals(event.getValue())) continue;
            event.addPropertyChangeListener(this._entryListener);
            event.setValue(row.getEventId());
            currentCount = this._storeQueueLength.incrementAndGet();
        }
        log.debug("storeReceivers count = {}", (Object)currentCount);
    }

    private void storeTransmitters() {
        int currentCount = 0;
        for (int i = 0; i < 16; ++i) {
            TransmitterRow row = this._transmitterList.get(i);
            ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)this._cdi.getVariableForKey(String.format(TRANSMITTER_NAME, i));
            if (row.getName().equals(entry.getValue())) continue;
            entry.addPropertyChangeListener(this._entryListener);
            entry.setValue(row.getName());
            currentCount = this._storeQueueLength.incrementAndGet();
        }
        log.debug("storeTransmitters count = {}", (Object)currentCount);
    }

    private void loadBackupData(ActionEvent m) {
        if (!this.replaceData()) {
            return;
        }
        JmriJFileChooser fileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
        fileChooser.setApproveButtonText(Bundle.getMessage("LoadCdiButton"));
        fileChooser.setDialogTitle(Bundle.getMessage("LoadCdiTitle"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Bundle.getMessage("LoadCdiFilter"), "txt");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int response = fileChooser.showOpenDialog(this);
        if (response == 1) {
            return;
        }
        List<String> lines = null;
        try {
            lines = Files.readAllLines(Paths.get(fileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            log.error("Failed to load file.", (Throwable)e);
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            if (lines.get(i).startsWith("Logic Inputs.Group")) {
                this.loadBackupInputs(i, lines);
                i += 384;
            }
            if (lines.get(i).startsWith("Logic Outputs.Group")) {
                this.loadBackupOutputs(i, lines);
                i += 384;
            }
            if (lines.get(i).startsWith("Track Receivers")) {
                this.loadBackupReceivers(i, lines);
                i += 32;
            }
            if (lines.get(i).startsWith("Track Transmitters")) {
                this.loadBackupTransmitters(i, lines);
                i += 32;
            }
            if (!lines.get(i).startsWith("Conditionals.Logic")) continue;
            this.loadBackupGroups(i, lines);
            i += 32;
        }
        for (GroupRow row : this._groupList) {
            this.decode(row);
        }
        this.setDirty(false);
        this._groupTable.setRowSelectionInterval(0, 0);
        this._groupTable.repaint();
        this._exportButton.setEnabled(true);
        this._exportItem.setEnabled(true);
        if (this._splitView) {
            this._tableTabs.repaint();
        }
    }

    private String getLineValue(String line) {
        if (line.endsWith("=")) {
            return "";
        }
        int index = line.indexOf("=");
        String newLine = line.substring(index + 1);
        newLine = Util.unescapeString((String)newLine);
        return newLine;
    }

    private String getLoadEventID(String event, char iqyz, int row) {
        if (StlEditorPane.isEventValid(event)) {
            return event;
        }
        try {
            EventID eventID = this._nameStore.getEventID(event);
            return eventID.toShortString();
        }
        catch (NumberFormatException ex) {
            log.error("STL Editor getLoadEventID event failed for event name {}", (Object)event);
            int group = row;
            int item = 0;
            if (iqyz == 'I' || iqyz == 'Q') {
                group = row / 8;
                item = row % 8;
            }
            StringBuilder sb = new StringBuilder("00.00.00.00.00.");
            sb.append(StringUtil.twoHexFromInt(iqyz));
            sb.append(".");
            sb.append(StringUtil.twoHexFromInt(group));
            sb.append(".");
            sb.append(StringUtil.twoHexFromInt(item));
            String zeroEvent = sb.toString();
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MessageEvent", event, zeroEvent, Character.valueOf(iqyz)), Bundle.getMessage("TitleEvent"), 0);
            return zeroEvent;
        }
    }

    private void loadBackupInputs(int index, List<String> lines) {
        for (int i = 0; i < 128; ++i) {
            InputRow inputRow = this._inputList.get(i);
            inputRow.setName(this.getLineValue(lines.get(index)));
            String trueName = this.getLineValue(lines.get(index + 1));
            inputRow.setEventTrue(this.getLoadEventID(trueName, 'I', i));
            String falseName = this.getLineValue(lines.get(index + 2));
            inputRow.setEventFalse(this.getLoadEventID(falseName, 'I', i));
            index += 3;
        }
        this._inputTable.revalidate();
    }

    private void loadBackupOutputs(int index, List<String> lines) {
        for (int i = 0; i < 128; ++i) {
            OutputRow outputRow = this._outputList.get(i);
            outputRow.setName(this.getLineValue(lines.get(index)));
            String trueName = this.getLineValue(lines.get(index + 1));
            outputRow.setEventTrue(this.getLoadEventID(trueName, 'Q', i));
            String falseName = this.getLineValue(lines.get(index + 2));
            outputRow.setEventFalse(this.getLoadEventID(falseName, 'Q', i));
            index += 3;
        }
        this._outputTable.revalidate();
    }

    private void loadBackupReceivers(int index, List<String> lines) {
        for (int i = 0; i < 16; ++i) {
            ReceiverRow receiverRow = this._receiverList.get(i);
            receiverRow.setName(this.getLineValue(lines.get(index)));
            String event = this.getLineValue(lines.get(index + 1));
            receiverRow.setEventId(this.getLoadEventID(event, 'Y', i));
            index += 2;
        }
        this._receiverTable.revalidate();
    }

    private void loadBackupTransmitters(int index, List<String> lines) {
        for (int i = 0; i < 16; ++i) {
            TransmitterRow transmitterRow = this._transmitterList.get(i);
            transmitterRow.setName(this.getLineValue(lines.get(index)));
            String event = this.getLineValue(lines.get(index + 1));
            transmitterRow.setEventId(this.getLoadEventID(event, 'Z', i));
            index += 2;
        }
        this._transmitterTable.revalidate();
    }

    private void loadBackupGroups(int index, List<String> lines) {
        for (int i = 0; i < 16; ++i) {
            GroupRow groupRow = this._groupList.get(i);
            groupRow.clearLogicList();
            groupRow.setName(this.getLineValue(lines.get(index)));
            groupRow.setMultiLine(this.getLineValue(lines.get(index + 1)));
            index += 2;
        }
        this._groupTable.revalidate();
        this._logicTable.revalidate();
    }

    private void pushedImportButton(ActionEvent e) {
        if (!this.replaceData()) {
            return;
        }
        if (!this.setCsvDirectoryPath(true)) {
            return;
        }
        this._csvMessages.clear();
        this.importCsvData();
        this.setDirty(false);
        this._exportButton.setEnabled(true);
        this._exportItem.setEnabled(true);
        if (!this._csvMessages.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"\n", this._csvMessages), Bundle.getMessage("TitleCsvImport"), 0);
        }
    }

    private void importCsvData() {
        this.importGroupLogic();
        this.importInputs();
        this.importOutputs();
        this.importReceivers();
        this.importTransmitters();
        this._groupTable.setRowSelectionInterval(0, 0);
        this._groupTable.repaint();
        if (this._splitView) {
            this._tableTabs.repaint();
        }
    }

    private void importGroupLogic() {
        List<CSVRecord> records = this.getCsvRecords("group_logic.csv");
        if (records.isEmpty()) {
            return;
        }
        boolean skipHeader = true;
        int groupNumber = -1;
        for (CSVRecord record : records) {
            if (skipHeader) {
                skipHeader = false;
                continue;
            }
            ArrayList values = new ArrayList();
            record.forEach(values::add);
            if (values.size() == 1 || values.size() == 5 && ((String)values.get(1)).isEmpty() && ((String)values.get(2)).isEmpty() && ((String)values.get(3)).isEmpty() && ((String)values.get(4)).isEmpty()) {
                GroupRow groupRow = this._groupList.get(++groupNumber);
                groupRow.setName((String)values.get(0));
                groupRow.setMultiLine("");
                groupRow.clearLogicList();
                continue;
            }
            if (values.size() == 5) {
                Operator oper = this.getEnum((String)values.get(2));
                LogicRow logicRow = new LogicRow((String)values.get(1), oper, (String)values.get(3), (String)values.get(4));
                this._groupList.get(groupNumber).getLogicList().add(logicRow);
                continue;
            }
            this._csvMessages.add(Bundle.getMessage("ImportGroupError", record.toString()));
        }
        this._groupTable.revalidate();
        this._logicTable.revalidate();
    }

    private void importInputs() {
        List<CSVRecord> records = this.getCsvRecords("inputs.csv");
        if (records.isEmpty()) {
            return;
        }
        for (int i = 0; i < 129; ++i) {
            if (i == 0) continue;
            CSVRecord record = records.get(i);
            ArrayList values = new ArrayList();
            record.forEach(values::add);
            if (values.size() == 4) {
                InputRow inputRow = this._inputList.get(i - 1);
                inputRow.setName((String)values.get(1));
                inputRow.setEventTrue((String)values.get(2));
                inputRow.setEventFalse((String)values.get(3));
                continue;
            }
            this._csvMessages.add(Bundle.getMessage("ImportInputError", record.toString()));
        }
        this._inputTable.revalidate();
    }

    private void importOutputs() {
        List<CSVRecord> records = this.getCsvRecords("outputs.csv");
        if (records.isEmpty()) {
            return;
        }
        for (int i = 0; i < 129; ++i) {
            if (i == 0) continue;
            CSVRecord record = records.get(i);
            ArrayList values = new ArrayList();
            record.forEach(values::add);
            if (values.size() == 4) {
                OutputRow outputRow = this._outputList.get(i - 1);
                outputRow.setName((String)values.get(1));
                outputRow.setEventTrue((String)values.get(2));
                outputRow.setEventFalse((String)values.get(3));
                continue;
            }
            this._csvMessages.add(Bundle.getMessage("ImportOuputError", record.toString()));
        }
        this._outputTable.revalidate();
    }

    private void importReceivers() {
        List<CSVRecord> records = this.getCsvRecords("receivers.csv");
        if (records.isEmpty()) {
            return;
        }
        for (int i = 0; i < 17; ++i) {
            if (i == 0) continue;
            CSVRecord record = records.get(i);
            ArrayList values = new ArrayList();
            record.forEach(values::add);
            if (values.size() == 3) {
                ReceiverRow receiverRow = this._receiverList.get(i - 1);
                receiverRow.setName((String)values.get(1));
                receiverRow.setEventId((String)values.get(2));
                continue;
            }
            this._csvMessages.add(Bundle.getMessage("ImportReceiverError", record.toString()));
        }
        this._receiverTable.revalidate();
    }

    private void importTransmitters() {
        List<CSVRecord> records = this.getCsvRecords("transmitters.csv");
        if (records.isEmpty()) {
            return;
        }
        for (int i = 0; i < 17; ++i) {
            if (i == 0) continue;
            CSVRecord record = records.get(i);
            ArrayList values = new ArrayList();
            record.forEach(values::add);
            if (values.size() == 3) {
                TransmitterRow transmitterRow = this._transmitterList.get(i - 1);
                transmitterRow.setName((String)values.get(1));
                transmitterRow.setEventId((String)values.get(2));
                continue;
            }
            this._csvMessages.add(Bundle.getMessage("ImportTransmitterError", record.toString()));
        }
        this._transmitterTable.revalidate();
    }

    private List<CSVRecord> getCsvRecords(String fileName) {
        FileReader fileReader;
        ArrayList<CSVRecord> recordList = new ArrayList<CSVRecord>();
        try {
            fileReader = new FileReader(this._csvDirectoryPath + fileName);
        }
        catch (FileNotFoundException ex) {
            this._csvMessages.add(Bundle.getMessage("ImportFileNotFound", fileName));
            return recordList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            CSVParser csvFile = new CSVParser((Reader)bufferedReader, CSVFormat.DEFAULT);
            recordList.addAll(csvFile.getRecords());
            csvFile.close();
            bufferedReader.close();
            fileReader.close();
        }
        catch (IOException iox) {
            this._csvMessages.add(Bundle.getMessage("ImportFileIOError", iox.getMessage(), fileName));
        }
        return recordList;
    }

    private void pushedExportButton(ActionEvent e) {
        if (!this.setCsvDirectoryPath(false)) {
            return;
        }
        this._csvMessages.clear();
        this.exportCsvData();
        this.setDirty(false);
        this._csvMessages.add(Bundle.getMessage("ExportDone"));
        int msgType = 0;
        if (this._csvMessages.size() == 1) {
            msgType = 1;
        }
        JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"\n", this._csvMessages), Bundle.getMessage("TitleCsvExport"), msgType);
    }

    private void exportCsvData() {
        try {
            this.exportGroupLogic();
            this.exportInputs();
            this.exportOutputs();
            this.exportReceivers();
            this.exportTransmitters();
        }
        catch (IOException ex) {
            this._csvMessages.add(Bundle.getMessage("ExportIOError", ex.getMessage()));
        }
    }

    private void exportGroupLogic() throws IOException {
        FileWriter fileWriter = new FileWriter(this._csvDirectoryPath + "group_logic.csv");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        CSVPrinter csvFile = new CSVPrinter((Appendable)bufferedWriter, CSVFormat.DEFAULT);
        csvFile.printRecord(new Object[]{Bundle.getMessage("GroupName"), Bundle.getMessage("ColumnLabel"), Bundle.getMessage("ColumnOper"), Bundle.getMessage("ColumnName"), Bundle.getMessage("ColumnComment")});
        for (int i = 0; i < 16; ++i) {
            GroupRow row = this._groupList.get(i);
            String groupName = row.getName();
            csvFile.printRecord(new Object[]{groupName});
            List<LogicRow> logicRow = row.getLogicList();
            for (LogicRow logic : logicRow) {
                String operName = logic.getOperName();
                csvFile.printRecord(new Object[]{"", logic.getLabel(), operName, logic.getName(), logic.getComment()});
            }
        }
        csvFile.flush();
        csvFile.close();
    }

    private void exportInputs() throws IOException {
        FileWriter fileWriter = new FileWriter(this._csvDirectoryPath + "inputs.csv");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        CSVPrinter csvFile = new CSVPrinter((Appendable)bufferedWriter, CSVFormat.DEFAULT);
        csvFile.printRecord(new Object[]{Bundle.getMessage("ColumnInput"), Bundle.getMessage("ColumnName"), Bundle.getMessage("ColumnTrue"), Bundle.getMessage("ColumnFalse")});
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                String variable = "I" + i + "." + j;
                InputRow row = this._inputList.get(i * 8 + j);
                csvFile.printRecord(new Object[]{variable, row.getName(), row.getEventTrue(), row.getEventFalse()});
            }
        }
        csvFile.flush();
        csvFile.close();
    }

    private void exportOutputs() throws IOException {
        FileWriter fileWriter = new FileWriter(this._csvDirectoryPath + "outputs.csv");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        CSVPrinter csvFile = new CSVPrinter((Appendable)bufferedWriter, CSVFormat.DEFAULT);
        csvFile.printRecord(new Object[]{Bundle.getMessage("ColumnOutput"), Bundle.getMessage("ColumnName"), Bundle.getMessage("ColumnTrue"), Bundle.getMessage("ColumnFalse")});
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                String variable = "Q" + i + "." + j;
                OutputRow row = this._outputList.get(i * 8 + j);
                csvFile.printRecord(new Object[]{variable, row.getName(), row.getEventTrue(), row.getEventFalse()});
            }
        }
        csvFile.flush();
        csvFile.close();
    }

    private void exportReceivers() throws IOException {
        FileWriter fileWriter = new FileWriter(this._csvDirectoryPath + "receivers.csv");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        CSVPrinter csvFile = new CSVPrinter((Appendable)bufferedWriter, CSVFormat.DEFAULT);
        csvFile.printRecord(new Object[]{Bundle.getMessage("ColumnCircuit"), Bundle.getMessage("ColumnName"), Bundle.getMessage("ColumnEventID")});
        for (int i = 0; i < 16; ++i) {
            String variable = "Y" + i;
            ReceiverRow row = this._receiverList.get(i);
            csvFile.printRecord(new Object[]{variable, row.getName(), row.getEventId()});
        }
        csvFile.flush();
        csvFile.close();
    }

    private void exportTransmitters() throws IOException {
        FileWriter fileWriter = new FileWriter(this._csvDirectoryPath + "transmitters.csv");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        CSVPrinter csvFile = new CSVPrinter((Appendable)bufferedWriter, CSVFormat.DEFAULT);
        csvFile.printRecord(new Object[]{Bundle.getMessage("ColumnCircuit"), Bundle.getMessage("ColumnName"), Bundle.getMessage("ColumnEventID")});
        for (int i = 0; i < 16; ++i) {
            String variable = "Z" + i;
            TransmitterRow row = this._transmitterList.get(i);
            csvFile.printRecord(new Object[]{variable, row.getName(), row.getEventId()});
        }
        csvFile.flush();
        csvFile.close();
    }

    private boolean setCsvDirectoryPath(boolean isOpen) {
        JmriJFileChooser directoryChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
        directoryChooser.setApproveButtonText(Bundle.getMessage("SelectCsvButton"));
        directoryChooser.setDialogTitle(Bundle.getMessage("SelectCsvTitle"));
        directoryChooser.setFileSelectionMode(1);
        int response = 0;
        response = isOpen ? directoryChooser.showOpenDialog(this) : directoryChooser.showSaveDialog(this);
        if (response != 0) {
            return false;
        }
        this._csvDirectoryPath = directoryChooser.getSelectedFile().getAbsolutePath() + "/";
        return true;
    }

    private void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    private boolean isDirty() {
        return this._dirty;
    }

    private boolean replaceData() {
        int response;
        return !this.isDirty() || (response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("MessageRevert"), Bundle.getMessage("TitleRevert"), 0)) == 0;
    }

    private void warningDialog(String title, String message) {
        JmriJOptionPane.showMessageDialog(this, message, title, 2);
    }

    static boolean isLabelValid(String label) {
        if (label.isEmpty()) {
            return true;
        }
        Matcher match = PARSE_LABEL.matcher(label);
        if (match.find()) {
            return true;
        }
        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MessageLabel", label), Bundle.getMessage("TitleLabel"), 0);
        return false;
    }

    static boolean isEventValid(String event) {
        boolean valid = true;
        if (event.isEmpty()) {
            return valid;
        }
        String[] hexPairs = event.split("\\.");
        if (hexPairs.length != 8) {
            valid = false;
        } else {
            for (int i = 0; i < 8; ++i) {
                Matcher match = PARSE_HEXPAIR.matcher(hexPairs[i]);
                if (match.find()) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private String getTableInputEventID(String event) {
        if (StlEditorPane.isEventValid(event)) {
            return event;
        }
        try {
            EventID eventID = this._nameStore.getEventID(event);
            return eventID.toShortString();
        }
        catch (NumberFormatException num) {
            log.error("STL Editor getTableInputEventID event failed for event name {} (NumberFormatException)", (Object)event);
        }
        catch (IllegalArgumentException arg) {
            log.error("STL Editor getTableInputEventID event failed for event name {} (IllegalArgumentException)", (Object)event);
        }
        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MessageEventTable", event), Bundle.getMessage("TitleEventTable"), 0);
        return null;
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> retval = new ArrayList<JMenu>();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        this._refreshItem = new JMenuItem(Bundle.getMessage("MenuRefresh"));
        this._storeItem = new JMenuItem(Bundle.getMessage("MenuStore"));
        this._importItem = new JMenuItem(Bundle.getMessage("MenuImport"));
        this._exportItem = new JMenuItem(Bundle.getMessage("MenuExport"));
        this._loadItem = new JMenuItem(Bundle.getMessage("MenuLoad"));
        this._refreshItem.addActionListener(this::pushedRefreshButton);
        this._storeItem.addActionListener(this::pushedStoreButton);
        this._importItem.addActionListener(this::pushedImportButton);
        this._exportItem.addActionListener(this::pushedExportButton);
        this._loadItem.addActionListener(this::loadBackupData);
        fileMenu.add(this._refreshItem);
        fileMenu.add(this._storeItem);
        fileMenu.addSeparator();
        fileMenu.add(this._importItem);
        fileMenu.add(this._exportItem);
        fileMenu.addSeparator();
        fileMenu.add(this._loadItem);
        this._refreshItem.setEnabled(false);
        this._storeItem.setEnabled(false);
        this._exportItem.setEnabled(false);
        JMenu viewMenu = new JMenu(Bundle.getMessage("MenuView"));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        this._viewSingle.setActionCommand("SINGLE");
        this._viewSingle.addItemListener(this::setViewMode);
        viewMenu.add(this._viewSingle);
        viewButtonGroup.add(this._viewSingle);
        this._viewSplit.setActionCommand("SPLIT");
        this._viewSplit.addItemListener(this::setViewMode);
        viewMenu.add(this._viewSplit);
        viewButtonGroup.add(this._viewSplit);
        if (this._splitView) {
            this._viewSplit.setSelected(true);
        } else {
            this._viewSingle.setSelected(true);
        }
        viewMenu.addSeparator();
        this._viewPreview.addItemListener(this::setPreview);
        viewMenu.add(this._viewPreview);
        if (this._stlPreview) {
            this._viewPreview.setSelected(true);
        } else {
            this._viewPreview.setSelected(false);
        }
        viewMenu.addSeparator();
        ButtonGroup viewStoreGroup = new ButtonGroup();
        this._viewReadable.setActionCommand("LINE");
        this._viewReadable.addItemListener(this::setViewStoreMode);
        viewMenu.add(this._viewReadable);
        viewStoreGroup.add(this._viewReadable);
        this._viewCompact.setActionCommand("CLNE");
        this._viewCompact.addItemListener(this::setViewStoreMode);
        viewMenu.add(this._viewCompact);
        viewStoreGroup.add(this._viewCompact);
        this._viewCompressed.setActionCommand("COMP");
        this._viewCompressed.addItemListener(this::setViewStoreMode);
        viewMenu.add(this._viewCompressed);
        viewStoreGroup.add(this._viewCompressed);
        switch (this._storeMode) {
            case "LINE": {
                this._viewReadable.setSelected(true);
                break;
            }
            case "CLNE": {
                this._viewCompact.setSelected(true);
                break;
            }
            case "COMP": {
                this._viewCompressed.setSelected(true);
                break;
            }
            default: {
                log.error("Invalid store mode: {}", (Object)this._storeMode);
            }
        }
        retval.add(fileMenu);
        retval.add(viewMenu);
        return retval;
    }

    private void setViewMode(ItemEvent e) {
        if (e.getStateChange() == 1) {
            JRadioButtonMenuItem button = (JRadioButtonMenuItem)e.getItem();
            String cmd = button.getActionCommand();
            this._splitView = "SPLIT".equals(cmd);
            this._pm.setProperty(this.getClass().getName(), "ViewMode", cmd);
            if (this._splitView) {
                this.splitTabs();
            } else if (this._detailTabs.getTabCount() == 1) {
                this.mergeTabs();
            }
        }
    }

    private void splitTabs() {
        if (this._detailTabs.getTabCount() == 5) {
            this._detailTabs.remove(4);
            this._detailTabs.remove(3);
            this._detailTabs.remove(2);
            this._detailTabs.remove(1);
        }
        if (this._tableTabs == null) {
            this._tableTabs = new JTabbedPane();
        }
        this._tableTabs.add(Bundle.getMessage("ButtonI"), this._inputPanel);
        this._tableTabs.add(Bundle.getMessage("ButtonQ"), this._outputPanel);
        this._tableTabs.add(Bundle.getMessage("ButtonY"), this._receiverPanel);
        this._tableTabs.add(Bundle.getMessage("ButtonZ"), this._transmitterPanel);
        this._tableTabs.setFont(new Font("Monospaced", 0, 12));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this._tableTabs, "Center");
        if (this._tableFrame == null) {
            this._tableFrame = new JmriJFrame(Bundle.getMessage("TitleTables"));
            this._tableFrame.setDefaultCloseOperation(0);
        }
        this._tableFrame.add(tablePanel);
        this._tableFrame.pack();
        this._tableFrame.setVisible(true);
    }

    private void mergeTabs() {
        if (this._tableTabs != null) {
            this._tableTabs.removeAll();
        }
        this._detailTabs.add(Bundle.getMessage("ButtonI"), this._inputPanel);
        this._detailTabs.add(Bundle.getMessage("ButtonQ"), this._outputPanel);
        this._detailTabs.add(Bundle.getMessage("ButtonY"), this._receiverPanel);
        this._detailTabs.add(Bundle.getMessage("ButtonZ"), this._transmitterPanel);
        if (this._tableFrame != null) {
            this._tableFrame.setVisible(false);
        }
    }

    private void setPreview(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this._stlPreview = true;
            this._stlTextArea = new JTextArea();
            this._stlTextArea.setEditable(false);
            this._stlTextArea.setFont(new Font("Monospaced", 0, 12));
            this._stlTextArea.setMargin(new Insets(5, 10, 0, 0));
            JPanel previewPanel = new JPanel();
            previewPanel.setLayout(new BorderLayout());
            previewPanel.add((Component)this._stlTextArea, "Center");
            if (this._previewFrame == null) {
                this._previewFrame = new JmriJFrame(Bundle.getMessage("TitlePreview"));
                this._previewFrame.setDefaultCloseOperation(0);
            }
            this._previewFrame.add(previewPanel);
            this._previewFrame.pack();
            this._previewFrame.setVisible(true);
        } else {
            this._stlPreview = false;
            if (this._previewFrame != null) {
                this._previewFrame.setVisible(false);
            }
        }
        this._pm.setSimplePreferenceState(this._previewModeCheck, this._stlPreview);
    }

    private void setViewStoreMode(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String cmd;
            JRadioButtonMenuItem button = (JRadioButtonMenuItem)e.getItem();
            this._storeMode = cmd = button.getActionCommand();
            this._pm.setProperty(this.getClass().getName(), "StoreMode", cmd);
        }
    }

    @Override
    public void dispose() {
        if (this._tableFrame != null) {
            this._tableFrame.dispose();
        }
        if (this._previewFrame != null) {
            this._previewFrame.dispose();
        }
        super.dispose();
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.openlcb.swing.stleditor.StlEditorPane";
    }

    @Override
    public String getTitle() {
        if (this._canMemo != null) {
            return this._canMemo.getUserName() + " STL Editor";
        }
        return Bundle.getMessage("TitleSTLEditor");
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super("STL Editor", new JmriJFrameInterface(), StlEditorPane.class.getName(), InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
        }

        public Default(String name, WindowInterface iface) {
            super(name, iface, StlEditorPane.class.getName(), InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
        }

        public Default(String name, Icon icon, WindowInterface iface) {
            super(name, icon, iface, StlEditorPane.class.getName(), InstanceManager.getNullableDefault(CanSystemConnectionMemo.class));
        }
    }

    static class Token {
        String _type = "";
        String _name = "";
        int _offsetStart = 0;
        int _offsetEnd = 0;

        Token(String type, String name, int offsetStart, int offsetEnd) {
            this._type = type;
            this._name = name;
            this._offsetStart = offsetStart;
            this._offsetEnd = offsetEnd;
        }

        public String getType() {
            return this._type;
        }

        public String getName() {
            return this._name;
        }

        public int getStart() {
            return this._offsetStart;
        }

        public int getEnd() {
            return this._offsetEnd;
        }

        public String toString() {
            return String.format("Type: %s, Name: %s, Start: %d, End: %d", this._type, this._name, this._offsetStart, this._offsetEnd);
        }
    }

    public static enum Operator {
        x0(Bundle.getMessage("Separator0")),
        z1(Bundle.getMessage("Separator1")),
        A(Bundle.getMessage("OperatorA")),
        AN(Bundle.getMessage("OperatorAN")),
        O(Bundle.getMessage("OperatorO")),
        ON(Bundle.getMessage("OperatorON")),
        X(Bundle.getMessage("OperatorX")),
        XN(Bundle.getMessage("OperatorXN")),
        z2(Bundle.getMessage("Separator2")),
        Ap(Bundle.getMessage("OperatorAp")),
        ANp(Bundle.getMessage("OperatorANp")),
        Op(Bundle.getMessage("OperatorOp")),
        ONp(Bundle.getMessage("OperatorONp")),
        Xp(Bundle.getMessage("OperatorXp")),
        XNp(Bundle.getMessage("OperatorXNp")),
        Cp(Bundle.getMessage("OperatorCp")),
        z3(Bundle.getMessage("Separator3")),
        EQ(Bundle.getMessage("OperatorEQ")),
        R(Bundle.getMessage("OperatorR")),
        S(Bundle.getMessage("OperatorS")),
        z4(Bundle.getMessage("Separator4")),
        NOT(Bundle.getMessage("OperatorNOT")),
        SET(Bundle.getMessage("OperatorSET")),
        CLR(Bundle.getMessage("OperatorCLR")),
        SAVE(Bundle.getMessage("OperatorSAVE")),
        z5(Bundle.getMessage("Separator5")),
        JU(Bundle.getMessage("OperatorJU")),
        JC(Bundle.getMessage("OperatorJC")),
        JCN(Bundle.getMessage("OperatorJCN")),
        JCB(Bundle.getMessage("OperatorJCB")),
        JNB(Bundle.getMessage("OperatorJNB")),
        JBI(Bundle.getMessage("OperatorJBI")),
        JNBI(Bundle.getMessage("OperatorJNBI")),
        z6(Bundle.getMessage("Separator6")),
        FN(Bundle.getMessage("OperatorFN")),
        FP(Bundle.getMessage("OperatorFP")),
        z7(Bundle.getMessage("Separator7")),
        L(Bundle.getMessage("OperatorL")),
        FR(Bundle.getMessage("OperatorFR")),
        SP(Bundle.getMessage("OperatorSP")),
        SE(Bundle.getMessage("OperatorSE")),
        SD(Bundle.getMessage("OperatorSD")),
        SS(Bundle.getMessage("OperatorSS")),
        SF(Bundle.getMessage("OperatorSF"));

        private final String _text;

        private Operator(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    class TransmitterModel
    extends AbstractTableModel {
        public static final int CIRCUIT_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int EVENTID_COLUMN = 2;

        TransmitterModel() {
        }

        @Override
        public int getRowCount() {
            return StlEditorPane.this._transmitterList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnCircuit");
                }
                case 1: {
                    return Bundle.getMessage("ColumnName");
                }
                case 2: {
                    return Bundle.getMessage("ColumnEventID");
                }
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return "Z" + r;
                }
                case 1: {
                    return StlEditorPane.this._transmitterList.get(r).getName();
                }
                case 2: {
                    EventID eventID = new EventID(StlEditorPane.this._transmitterList.get(r).getEventId());
                    return StlEditorPane.this._nameStore.getEventName(eventID);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 1: {
                    StlEditorPane.this._transmitterList.get(r).setName((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 2: {
                    String event = StlEditorPane.this.getTableInputEventID((String)type);
                    if (event == null) break;
                    StlEditorPane.this._transmitterList.get(r).setEventId(event);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1 || c == 2;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }
    }

    class ReceiverModel
    extends AbstractTableModel {
        public static final int CIRCUIT_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int EVENTID_COLUMN = 2;

        ReceiverModel() {
        }

        @Override
        public int getRowCount() {
            return StlEditorPane.this._receiverList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnCircuit");
                }
                case 1: {
                    return Bundle.getMessage("ColumnName");
                }
                case 2: {
                    return Bundle.getMessage("ColumnEventID");
                }
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return "Y" + r;
                }
                case 1: {
                    return StlEditorPane.this._receiverList.get(r).getName();
                }
                case 2: {
                    EventID eventID = new EventID(StlEditorPane.this._receiverList.get(r).getEventId());
                    return StlEditorPane.this._nameStore.getEventName(eventID);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 1: {
                    StlEditorPane.this._receiverList.get(r).setName((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 2: {
                    String event = StlEditorPane.this.getTableInputEventID((String)type);
                    if (event == null) break;
                    StlEditorPane.this._receiverList.get(r).setEventId(event);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1 || c == 2;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }
    }

    class OutputModel
    extends AbstractTableModel {
        public static final int OUTPUT_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int TRUE_COLUMN = 2;
        public static final int FALSE_COLUMN = 3;

        OutputModel() {
        }

        @Override
        public int getRowCount() {
            return StlEditorPane.this._outputList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnOutput");
                }
                case 1: {
                    return Bundle.getMessage("ColumnName");
                }
                case 2: {
                    return Bundle.getMessage("ColumnTrue");
                }
                case 3: {
                    return Bundle.getMessage("ColumnFalse");
                }
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    int grp = r / 8;
                    int rem = r % 8;
                    return "Q" + grp + "." + rem;
                }
                case 1: {
                    return StlEditorPane.this._outputList.get(r).getName();
                }
                case 2: {
                    EventID trueID = new EventID(StlEditorPane.this._outputList.get(r).getEventTrue());
                    return StlEditorPane.this._nameStore.getEventName(trueID);
                }
                case 3: {
                    EventID falseID = new EventID(StlEditorPane.this._outputList.get(r).getEventFalse());
                    return StlEditorPane.this._nameStore.getEventName(falseID);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 1: {
                    StlEditorPane.this._outputList.get(r).setName((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 2: {
                    String trueEvent = StlEditorPane.this.getTableInputEventID((String)type);
                    if (trueEvent == null) break;
                    StlEditorPane.this._outputList.get(r).setEventTrue(trueEvent);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 3: {
                    String falseEvent = StlEditorPane.this.getTableInputEventID((String)type);
                    if (falseEvent == null) break;
                    StlEditorPane.this._outputList.get(r).setEventFalse(falseEvent);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1 || c == 2 || c == 3;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
                case 2: 
                case 3: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }
    }

    class InputModel
    extends AbstractTableModel {
        public static final int INPUT_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int TRUE_COLUMN = 2;
        public static final int FALSE_COLUMN = 3;

        InputModel() {
        }

        @Override
        public int getRowCount() {
            return StlEditorPane.this._inputList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnInput");
                }
                case 1: {
                    return Bundle.getMessage("ColumnName");
                }
                case 2: {
                    return Bundle.getMessage("ColumnTrue");
                }
                case 3: {
                    return Bundle.getMessage("ColumnFalse");
                }
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    int grp = r / 8;
                    int rem = r % 8;
                    return "I" + grp + "." + rem;
                }
                case 1: {
                    return StlEditorPane.this._inputList.get(r).getName();
                }
                case 2: {
                    EventID trueID = new EventID(StlEditorPane.this._inputList.get(r).getEventTrue());
                    return StlEditorPane.this._nameStore.getEventName(trueID);
                }
                case 3: {
                    EventID falseID = new EventID(StlEditorPane.this._inputList.get(r).getEventFalse());
                    return StlEditorPane.this._nameStore.getEventName(falseID);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 1: {
                    StlEditorPane.this._inputList.get(r).setName((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 2: {
                    String trueEvent = StlEditorPane.this.getTableInputEventID((String)type);
                    if (trueEvent == null) break;
                    StlEditorPane.this._inputList.get(r).setEventTrue(trueEvent);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 3: {
                    String falseEvent = StlEditorPane.this.getTableInputEventID((String)type);
                    if (falseEvent == null) break;
                    StlEditorPane.this._inputList.get(r).setEventFalse(falseEvent);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1 || c == 2 || c == 3;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
                case 2: 
                case 3: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }
    }

    class LogicModel
    extends AbstractTableModel {
        public static final int LABEL_COLUMN = 0;
        public static final int OPER_COLUMN = 1;
        public static final int NAME_COLUMN = 2;
        public static final int COMMENT_COLUMN = 3;

        LogicModel() {
        }

        @Override
        public int getRowCount() {
            List<LogicRow> logicList = StlEditorPane.this._groupList.get(StlEditorPane.this._groupRow).getLogicList();
            return logicList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1) {
                return JComboBox.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnLabel");
                }
                case 1: {
                    return Bundle.getMessage("ColumnOper");
                }
                case 2: {
                    return Bundle.getMessage("ColumnName");
                }
                case 3: {
                    return Bundle.getMessage("ColumnComment");
                }
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int r, int c) {
            List<LogicRow> logicList = StlEditorPane.this._groupList.get(StlEditorPane.this._groupRow).getLogicList();
            switch (c) {
                case 0: {
                    return logicList.get(r).getLabel();
                }
                case 1: {
                    return logicList.get(r).getOper();
                }
                case 2: {
                    return logicList.get(r).getName();
                }
                case 3: {
                    return logicList.get(r).getComment();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            List<LogicRow> logicList = StlEditorPane.this._groupList.get(StlEditorPane.this._groupRow).getLogicList();
            switch (c) {
                case 0: {
                    logicList.get(r).setLabel((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 1: {
                    Operator z = (Operator)((Object)type);
                    if (z != null) {
                        if (z.name().startsWith("z")) {
                            return;
                        }
                        if (z.name().equals("x0")) {
                            logicList.get(r).setOper(null);
                            return;
                        }
                    }
                    logicList.get(r).setOper((Operator)((Object)type));
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 2: {
                    logicList.get(r).setName((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
                case 3: {
                    logicList.get(r).setComment((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return true;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
                case 2: 
                case 3: {
                    return new JTextField((int)40).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }
    }

    class GroupModel
    extends AbstractTableModel {
        public static final int ROW_COLUMN = 0;
        public static final int NAME_COLUMN = 1;

        GroupModel() {
        }

        @Override
        public int getRowCount() {
            return StlEditorPane.this._groupList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return Bundle.getMessage("ColumnName");
                }
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return r + 1;
                }
                case 1: {
                    return StlEditorPane.this._groupList.get(r).getName();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 1: {
                    StlEditorPane.this._groupList.get(r).setName((String)type);
                    StlEditorPane.this.setDirty(true);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)4).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }
    }

    static class TransmitterRow {
        String _name;
        String _eventid;

        TransmitterRow(String name, String eventid) {
            this._name = name;
            this._eventid = eventid;
        }

        String getName() {
            return this._name;
        }

        void setName(String newName) {
            this._name = newName.trim();
        }

        String getEventId() {
            if (this._eventid.length() == 0) {
                return "00.00.00.00.00.00.00.00";
            }
            return this._eventid;
        }

        void setEventId(String newEventid) {
            this._eventid = newEventid.trim();
        }
    }

    static class ReceiverRow {
        String _name;
        String _eventid;

        ReceiverRow(String name, String eventid) {
            this._name = name;
            this._eventid = eventid;
        }

        String getName() {
            return this._name;
        }

        void setName(String newName) {
            this._name = newName.trim();
        }

        String getEventId() {
            if (this._eventid.length() == 0) {
                return "00.00.00.00.00.00.00.00";
            }
            return this._eventid;
        }

        void setEventId(String newEventid) {
            this._eventid = newEventid.trim();
        }
    }

    static class OutputRow {
        String _name;
        String _eventTrue;
        String _eventFalse;

        OutputRow(String name, String eventTrue, String eventFalse) {
            this._name = name;
            this._eventTrue = eventTrue;
            this._eventFalse = eventFalse;
        }

        String getName() {
            return this._name;
        }

        void setName(String newName) {
            this._name = newName.trim();
        }

        String getEventTrue() {
            if (this._eventTrue.length() == 0) {
                return "00.00.00.00.00.00.00.00";
            }
            return this._eventTrue;
        }

        void setEventTrue(String newEventTrue) {
            this._eventTrue = newEventTrue.trim();
        }

        String getEventFalse() {
            if (this._eventFalse.length() == 0) {
                return "00.00.00.00.00.00.00.00";
            }
            return this._eventFalse;
        }

        void setEventFalse(String newEventFalse) {
            this._eventFalse = newEventFalse.trim();
        }
    }

    static class InputRow {
        String _name;
        String _eventTrue;
        String _eventFalse;

        InputRow(String name, String eventTrue, String eventFalse) {
            this._name = name;
            this._eventTrue = eventTrue;
            this._eventFalse = eventFalse;
        }

        String getName() {
            return this._name;
        }

        void setName(String newName) {
            this._name = newName.trim();
        }

        String getEventTrue() {
            if (this._eventTrue.length() == 0) {
                return "00.00.00.00.00.00.00.00";
            }
            return this._eventTrue;
        }

        void setEventTrue(String newEventTrue) {
            this._eventTrue = newEventTrue.trim();
        }

        String getEventFalse() {
            if (this._eventFalse.length() == 0) {
                return "00.00.00.00.00.00.00.00";
            }
            return this._eventFalse;
        }

        void setEventFalse(String newEventFalse) {
            this._eventFalse = newEventFalse.trim();
        }
    }

    static class LogicRow {
        String _label;
        Operator _oper;
        String _name;
        String _comment;

        LogicRow(String label, Operator oper, String name, String comment) {
            this._label = label;
            this._oper = oper;
            this._name = name;
            this._comment = comment;
        }

        String getLabel() {
            return this._label;
        }

        void setLabel(String newLabel) {
            String label = newLabel.trim();
            if (StlEditorPane.isLabelValid(label)) {
                this._label = label;
            }
        }

        Operator getOper() {
            return this._oper;
        }

        String getOperName() {
            if (this._oper == null) {
                return "";
            }
            String operName = this._oper.name();
            if (operName.equals("Cp")) {
                operName = ")";
            } else if (operName.equals("EQ")) {
                operName = "=";
            } else if (operName.contains("p")) {
                operName = operName.replace("p", "(");
            }
            return operName;
        }

        void setOper(Operator newOper) {
            this._oper = newOper;
        }

        String getName() {
            return this._name;
        }

        void setName(String newName) {
            this._name = newName.trim();
        }

        String getComment() {
            return this._comment;
        }

        void setComment(String newComment) {
            this._comment = newComment;
        }
    }

    static class GroupRow {
        String _name;
        String _multiLine = "";
        List<LogicRow> _logicList = new ArrayList<LogicRow>();

        GroupRow(String name) {
            this._name = name;
        }

        String getName() {
            return this._name;
        }

        void setName(String newName) {
            this._name = newName;
        }

        List<LogicRow> getLogicList() {
            return this._logicList;
        }

        void setLogicList(List<LogicRow> logicList) {
            this._logicList.clear();
            this._logicList.addAll(logicList);
        }

        void clearLogicList() {
            this._logicList.clear();
        }

        String getMultiLine() {
            return this._multiLine;
        }

        void setMultiLine(String newMultiLine) {
            this._multiLine = newMultiLine.strip();
        }

        String getSize() {
            int size = this._multiLine.length() * 100 / 255;
            return String.valueOf(size) + "%";
        }
    }

    protected static class NodeEntry
    implements Comparable<NodeEntry>,
    PropertyChangeListener {
        final MimicNodeStore.NodeMemo nodeMemo;
        String description = "";

        NodeEntry(MimicNodeStore.NodeMemo memo) {
            this.nodeMemo = memo;
            memo.addPropertyChangeListener((PropertyChangeListener)this);
            this.updateDescription();
        }

        public NodeEntry(String description) {
            this.nodeMemo = null;
            this.description = description;
        }

        public NodeID getNodeID() {
            return this.nodeMemo.getNodeID();
        }

        MimicNodeStore.NodeMemo getNodeMemo() {
            return this.nodeMemo;
        }

        private void updateDescription() {
            SimpleNodeIdent ident = this.nodeMemo.getSimpleNodeIdent();
            StringBuilder sb = new StringBuilder();
            sb.append(this.nodeMemo.getNodeID().toString());
            this.addToDescription(ident.getUserName(), sb);
            this.addToDescription(ident.getUserDesc(), sb);
            if (!ident.getMfgName().isEmpty() || !ident.getModelName().isEmpty()) {
                this.addToDescription(ident.getMfgName() + " " + ident.getModelName(), sb);
            }
            this.addToDescription(ident.getSoftwareVersion(), sb);
            String newDescription = sb.toString();
            if (!this.description.equals(newDescription)) {
                this.description = newDescription;
            }
        }

        private void addToDescription(String s, StringBuilder sb) {
            if (!s.isEmpty()) {
                sb.append(" - ");
                sb.append(s);
            }
        }

        private long reorder(long n) {
            return n < 0L ? Long.MAX_VALUE - n : Long.MIN_VALUE + n;
        }

        @Override
        public int compareTo(NodeEntry otherEntry) {
            long l1 = this.reorder(this.getNodeID().toLong());
            long l2 = this.reorder(otherEntry.getNodeID().toLong());
            return Long.compare(l1, l2);
        }

        public String toString() {
            return this.description;
        }

        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Purposefully attempting lookup using NodeID argument in model vector.")
        public boolean equals(Object o) {
            if (o instanceof NodeEntry) {
                return this.getNodeID().equals((Object)((NodeEntry)o).getNodeID());
            }
            if (o instanceof NodeID) {
                return this.getNodeID().equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.getNodeID().hashCode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("updateSimpleNodeIdent")) {
                this.updateDescription();
            }
        }

        public void dispose() {
            this.nodeMemo.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public class EntryListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            log.debug("EntryListener event = {}", (Object)propertyName);
            if (propertyName.equals("PENDING_WRITE_COMPLETE")) {
                int currentLength = StlEditorPane.this._storeQueueLength.decrementAndGet();
                log.debug("Listener: queue length = {}, source = {}", (Object)currentLength, e.getSource());
                ConfigRepresentation.CdiEntry entry = (ConfigRepresentation.CdiEntry)e.getSource();
                entry.removePropertyChangeListener(StlEditorPane.this._entryListener);
                if (currentLength < 1) {
                    log.debug("The queue is back to zero which implies the updates are done");
                    StlEditorPane.this.displayStoreDone();
                }
            }
            if (StlEditorPane.this._compileInProgress && propertyName.equals("UPDATE_ENTRY_DATA")) {
                ConfigRepresentation.StringEntry entry = (ConfigRepresentation.StringEntry)e.getSource();
                entry.removePropertyChangeListener(StlEditorPane.this._entryListener);
                StlEditorPane.this.displayCompileMessage(entry.getValue());
            }
        }
    }

    public class RebootListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (StlEditorPane.this._compileInProgress && propertyName.equals("updateSimpleNodeIdent")) {
                log.debug("The reboot appears to be done");
                StlEditorPane.this.getCompileMessage();
            }
        }
    }

    public class CdiListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            log.debug("CdiListener event = {}", (Object)propertyName);
            if (propertyName.equals("UPDATE_CACHE_COMPLETE")) {
                Window[] windows;
                for (Window window : windows = Window.getWindows()) {
                    if (!(window instanceof JDialog)) continue;
                    JDialog dialog = (JDialog)window;
                    if (!Bundle.getMessage("TitleCdiLoad").equals(dialog.getTitle())) continue;
                    dialog.dispose();
                }
                StlEditorPane.this.loadCdiData();
            }
        }
    }

    private class CopyRowListener
    extends JmriMouseAdapter {
        private CopyRowListener() {
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (StlEditorPane.this._logicRow < 0) {
                return;
            }
            if (!e.isShiftDown()) {
                return;
            }
            int currentTab = -1;
            currentTab = StlEditorPane.this._detailTabs.getTabCount() == 5 ? StlEditorPane.this._detailTabs.getSelectedIndex() : StlEditorPane.this._tableTabs.getSelectedIndex() + 1;
            String sourceName = "";
            switch (currentTab) {
                case 1: {
                    sourceName = StlEditorPane.this._inputList.get(StlEditorPane.this._inputTable.getSelectedRow()).getName();
                    break;
                }
                case 2: {
                    sourceName = StlEditorPane.this._outputList.get(StlEditorPane.this._outputTable.getSelectedRow()).getName();
                    break;
                }
                case 3: {
                    sourceName = StlEditorPane.this._receiverList.get(StlEditorPane.this._receiverTable.getSelectedRow()).getName();
                    break;
                }
                case 4: {
                    sourceName = StlEditorPane.this._transmitterList.get(StlEditorPane.this._transmitterTable.getSelectedRow()).getName();
                    break;
                }
                default: {
                    log.debug("CopyRowListener: Invalid tab number: {}", (Object)currentTab);
                    return;
                }
            }
            StlEditorPane.this._groupList.get((int)StlEditorPane.this._groupRow)._logicList.get(StlEditorPane.this._logicRow).setName(sourceName);
            StlEditorPane.this._logicTable.revalidate();
            StlEditorPane.this._logicScrollPane.repaint();
        }
    }
}

