/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb.swing.tie;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerTableModel
extends AbstractTableModel {
    static ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.openlcb.swing.tie.TieBundle");
    public static final int USERNAME_COLUMN = 0;
    public static final int NODE_COLUMN = 1;
    public static final int NUMBER_COLUMN = 2;
    final String[] columnName = new String[]{"User Name", "Node", "Event"};
    final String[][] dummy = new String[][]{{"Turnout 21 Left", "11", "1"}, {"Turnout 21 Right", "11", "2"}, {"Turnout 22 Right", "13", "1"}, {"Turnout 22 Left", "13", "2"}, {"Turnout 23 Right", "13", "3"}, {"Turnout 23 Left", "13", "4"}, {"Turnout 24 Right", "15", "1"}, {"Turnout 24 Left", "15", "2"}};
    private static final Logger log = LoggerFactory.getLogger(ConsumerTableModel.class);

    @Override
    public String getColumnName(int c) {
        return this.columnName[c];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnName.length;
    }

    @Override
    public int getRowCount() {
        return this.dummy.length;
    }

    @Override
    public Object getValueAt(int r, int c) {
        return this.dummy[r][c];
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
    }

    public void printTable(HardcopyWriter w, int[] colWidth) {
        int[] columnSize = new int[4];
        int charPerLine = w.getCharactersPerLine();
        int tableLineWidth = 0;
        int totalColWidth = 0;
        for (int j = 0; j < 4; ++j) {
            totalColWidth += colWidth[j];
        }
        float ratio = (float)charPerLine / (float)totalColWidth;
        for (int j = 0; j < 4; ++j) {
            columnSize[j] = (int)Math.round((double)((float)colWidth[j] * ratio) - 1.0);
            tableLineWidth += columnSize[j] + 1;
        }
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
        String[] columnStrings = new String[4];
        for (int i = 0; i < 4; ++i) {
            columnStrings[i] = this.getColumnName(i);
        }
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnSize);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
        String[] spaces = new String[4];
        for (int k = 0; k < 4; ++k) {
            spaces[k] = "";
            for (int i = 0; i < columnSize[k]; ++i) {
                spaces[k] = spaces[k] + " ";
            }
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < 4; ++j) {
                columnStrings[j] = this.getValueAt(i, j) == null ? spaces[j] : (String)this.getValueAt(i, j);
            }
            this.printColumns(w, columnStrings, columnSize);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
        }
        w.close();
    }

    protected void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnSize) {
        StringBuilder columnString = new StringBuilder();
        StringBuilder lineString = new StringBuilder();
        String[] spaces = new String[4];
        for (int k = 0; k < 4; ++k) {
            spaces[k] = "";
            for (int i = 0; i < columnSize[k]; ++i) {
                spaces[k] = spaces[k] + " ";
            }
        }
        boolean complete = false;
        while (!complete) {
            int k;
            complete = true;
            for (int i = 0; i < 4; ++i) {
                if (columnStrings[i].length() > columnSize[i]) {
                    boolean noWord = true;
                    for (k = columnSize[i]; k >= 1; --k) {
                        if (!columnStrings[i].startsWith(" ", k - 1) && !columnStrings[i].startsWith("-", k - 1) && !columnStrings[i].startsWith("_", k - 1)) continue;
                        columnString = new StringBuilder(columnStrings[i].substring(0, k));
                        columnString.append(spaces[i].substring(columnStrings[i].substring(0, k).length()));
                        columnStrings[i] = columnStrings[i].substring(k);
                        noWord = false;
                        complete = false;
                        break;
                    }
                    if (noWord) {
                        columnString = new StringBuilder(columnStrings[i].substring(0, columnSize[i]));
                        columnStrings[i] = columnStrings[i].substring(columnSize[i]);
                        complete = false;
                    }
                } else {
                    columnString = new StringBuilder(columnStrings[i]);
                    columnString.append(spaces[i].substring(columnStrings[i].length()));
                    columnStrings[i] = "";
                }
                lineString.append((CharSequence)columnString);
                lineString.append(" ");
            }
            try {
                w.write(lineString.toString());
                int iLine = w.getCurrentLineNumber();
                int i = 0;
                k = 0;
                while (i < w.getCharactersPerLine()) {
                    w.write(iLine, i, iLine + 1, i);
                    i = k < 4 ? i + columnSize[k] + 1 : w.getCharactersPerLine();
                    ++k;
                }
                w.write("\n");
                lineString = new StringBuilder();
            }
            catch (IOException e) {
                log.warn("error during printing", (Throwable)e);
            }
        }
    }
}

