/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

public class DmxSequence {
    private static final int MAXINDEX = 32;
    private int index = 0;
    private Command[] cmds = new Cmd[32];

    public void addCommand(int unit, byte value) {
        if (this.index >= 32) {
            throw new IllegalArgumentException("Sequence too long");
        }
        this.cmds[this.index] = new Cmd(unit, value);
        ++this.index;
    }

    public void reset() {
        this.index = 0;
    }

    public Command getCommand() {
        return this.cmds[this.index++];
    }

    public static class Cmd
    implements Command {
        int unit;
        byte value;

        public Cmd(int unit, byte value) {
            this.unit = unit;
            this.value = value;
        }

        @Override
        public int getUnit() {
            return this.unit;
        }

        @Override
        public byte getValue() {
            return this.value;
        }
    }

    public static interface Command {
        public int getUnit();

        public byte getValue();
    }
}

