/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import jmri.jmrix.powerline.X10Sequence;

public class InsteonSequence {
    private static final int MAXINDEX = 32;
    int index = 0;
    Command[] cmds = new Command[32];

    public void addFunction(int idhighbyte, int idmiddlebyte, int idlowbyte, int function, int flag, int command1, int command2) {
        if (this.index >= 32) {
            throw new IllegalArgumentException("Sequence too long");
        }
        this.cmds[this.index] = new Function(idhighbyte, idmiddlebyte, idlowbyte, function, flag, command1, command2);
        ++this.index;
    }

    public void addAddress(int idhighbyte, int idmiddlebyte, int idlowbyte) {
        if (this.index >= 32) {
            throw new IllegalArgumentException("Sequence too long");
        }
        this.cmds[this.index] = new Address(idhighbyte, idmiddlebyte, idlowbyte);
        ++this.index;
    }

    public void reset() {
        this.index = 0;
    }

    public Command getCommand() {
        return this.cmds[this.index++];
    }

    public static String functionName(int i) {
        return X10Sequence.functionName(i);
    }

    public static int encode(int i) {
        return X10Sequence.encode(i);
    }

    public static int decode(int i) {
        return X10Sequence.decode(i);
    }

    public static String formatAddressByte(int b) {
        return "House " + X10Sequence.houseValueToText(X10Sequence.decode(b >> 4 & 0xF)) + " address device " + X10Sequence.decode(b & 0xF);
    }

    public static String formatCommandByte(int b) {
        return "House " + X10Sequence.houseValueToText(X10Sequence.decode(b >> 4 & 0xF)) + " function: " + X10Sequence.functionName(b & 0xF);
    }

    public static String houseValueToText(int hV) {
        if (hV >= 1 && hV <= 16) {
            return X10Sequence.houseValueToText(hV);
        }
        return "??";
    }

    public static String houseCodeToText(int hC) {
        return X10Sequence.houseCodeToText(hC);
    }

    public static class ExtData
    implements Command {
        int idhighbyte;
        int idmiddlebyte;
        int idlowbyte;
        int value;

        public ExtData(int value) {
            this.value = value;
            this.idhighbyte = -1;
            this.idmiddlebyte = -1;
            this.idlowbyte = -1;
        }

        @Override
        public int getAddressHigh() {
            return this.idhighbyte;
        }

        @Override
        public int getAddressMiddle() {
            return this.idmiddlebyte;
        }

        @Override
        public int getAddressLow() {
            return this.idlowbyte;
        }

        public int getExtData() {
            return this.value;
        }

        @Override
        public boolean isAddress() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    public static class Function
    implements Command {
        int idhighbyte;
        int idmiddlebyte;
        int idlowbyte;
        int function;
        int flag;
        int command1;
        int command2;

        public Function(int idhighbyte, int idmiddlebyte, int idlowbyte, int function, int flag, int command1, int command2) {
            this.idhighbyte = idhighbyte;
            this.idmiddlebyte = idmiddlebyte;
            this.idlowbyte = idlowbyte;
            this.function = function;
            this.flag = flag;
            this.command1 = command1;
            this.command2 = command2;
        }

        @Override
        public int getAddressHigh() {
            return this.idhighbyte;
        }

        @Override
        public int getAddressMiddle() {
            return this.idmiddlebyte;
        }

        @Override
        public int getAddressLow() {
            return this.idlowbyte;
        }

        public int getFunction() {
            return this.function;
        }

        public int getFlag() {
            return this.flag;
        }

        public int getCommand1() {
            return this.command1;
        }

        public int getCommand2() {
            return this.command2;
        }

        @Override
        public boolean isAddress() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return true;
        }
    }

    public static class Address
    implements Command {
        int idhighbyte;
        int idmiddlebyte;
        int idlowbyte;

        public Address(int idhighbyte, int idmiddlebyte, int idlowbyte) {
            this.idhighbyte = idhighbyte;
            this.idmiddlebyte = idmiddlebyte;
            this.idlowbyte = idlowbyte;
        }

        @Override
        public int getAddressHigh() {
            return this.idhighbyte;
        }

        @Override
        public int getAddressMiddle() {
            return this.idmiddlebyte;
        }

        @Override
        public int getAddressLow() {
            return this.idlowbyte;
        }

        @Override
        public boolean isAddress() {
            return true;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    public static interface Command {
        public boolean isAddress();

        public boolean isFunction();

        public int getAddressHigh();

        public int getAddressMiddle();

        public int getAddressLow();
    }
}

