/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.powerline.Bundle;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialAddress {
    private Matcher hCodes = null;
    private Matcher aCodes = null;
    private Matcher iCodes = null;
    private Matcher dCodes = null;
    private static final char MIN_HOUSE_CODE = 'A';
    private static final char MAX_HOUSE_CODE = 'P';
    SerialSystemConnectionMemo memo = null;
    private static final Logger log = LoggerFactory.getLogger(SerialAddress.class);

    public SerialAddress(SerialSystemConnectionMemo m) {
        this.memo = m;
        this.hCodes = Pattern.compile("^(" + this.memo.getSystemPrefix() + ")([LTS])([A-P])(\\d++)$").matcher("");
        this.aCodes = Pattern.compile("^(" + this.memo.getSystemPrefix() + ")([LTS]).*$").matcher("");
        this.iCodes = Pattern.compile("^(" + this.memo.getSystemPrefix() + ")([LTS])(\\p{XDigit}\\p{XDigit})[.](\\p{XDigit}\\p{XDigit})[.](\\p{XDigit}\\p{XDigit})$").matcher("");
        this.dCodes = Pattern.compile("^(" + this.memo.getSystemPrefix() + ")([L])(\\p{Digit}{1,3}+)$").matcher("");
    }

    String validateSystemNameFormat(String name, char type, Locale locale) {
        block14: {
            boolean aTest = this.aCodes.reset(name).matches();
            boolean hTest = this.hCodes.reset(name).matches();
            boolean iTest = this.iCodes.reset(name).matches();
            boolean dTest = this.dCodes.reset(name).matches();
            if (!aTest || this.aCodes.group(2).charAt(0) != type) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidPrefix", this.memo.getSystemPrefix() + type), Bundle.getMessage(locale, "InvalidSystemNameInvalidPrefix", this.memo.getSystemPrefix() + type));
            }
            if (hTest && this.hCodes.groupCount() == 4) {
                if (this.hCodes.group(3).charAt(0) < 'A' || this.hCodes.group(3).charAt(0) > 'P') {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidHouseCode", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidHouseCode", name));
                }
                try {
                    int num = Integer.parseInt(this.hCodes.group(4));
                    if (num < 1 || num > 16) {
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidDevice", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidDevice", name));
                    }
                    break block14;
                }
                catch (NumberFormatException e) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidDevice", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidDevice", name));
                }
            }
            if (iTest) {
                if (this.iCodes.groupCount() != 5) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidInsteon", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidInsteon", name));
                }
            } else {
                if (dTest) {
                    if (this.dCodes.groupCount() != 3) {
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidDmx", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidDmx", name));
                    }
                    try {
                        int num = Integer.parseInt(this.dCodes.group(3));
                        if (num < 1 || num > 512) {
                            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidDevice", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidDevice", name));
                        }
                        break block14;
                    }
                    catch (NumberFormatException e) {
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidDevice", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidDevice", name));
                    }
                }
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidFormat", name), Bundle.getMessage(locale, "InvalidSystemNameInvalidFormat", name));
            }
        }
        return name;
    }

    public Manager.NameValidity validSystemNameFormat(String systemName, char type) {
        try {
            this.validateSystemNameFormat(systemName, type, Locale.getDefault());
        }
        catch (IllegalArgumentException ex) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    public boolean validSystemNameConfig(String systemName, char type) {
        return this.validSystemNameFormat(systemName, type) == Manager.NameValidity.VALID;
    }

    public boolean isInsteon(String systemName) {
        if (!this.aCodes.reset(systemName).matches() || this.validSystemNameFormat(systemName, this.aCodes.group(2).charAt(0)) != Manager.NameValidity.VALID) {
            return false;
        }
        if (this.hCodes.reset(systemName).matches() && this.hCodes.groupCount() == 4) {
            try {
                return false;
            }
            catch (Exception e) {
                log.error("illegal character in house code field system name: {}", (Object)systemName);
                return false;
            }
        }
        return true;
    }

    public String normalizeSystemName(String systemName) {
        boolean aMatch = this.aCodes.reset(systemName).matches();
        int aCount = this.aCodes.groupCount();
        boolean hMatch = this.hCodes.reset(systemName).matches();
        int hCount = this.hCodes.groupCount();
        boolean iMatch = this.iCodes.reset(systemName).matches();
        int iCount = this.iCodes.groupCount();
        if (!aMatch || aCount != 2 || this.validSystemNameFormat(systemName, this.aCodes.group(2).charAt(0)) != Manager.NameValidity.VALID) {
            return "";
        }
        Object nName = "";
        if (hMatch && hCount == 4) {
            nName = this.hCodes.group(1) + this.hCodes.group(2) + this.hCodes.group(3) + Integer.toString(Integer.parseInt(this.hCodes.group(4)));
        }
        if (((String)nName).equals("")) {
            if (iMatch && iCount == 5) {
                nName = this.iCodes.group(1) + this.iCodes.group(2) + this.iCodes.group(3) + "." + this.iCodes.group(4) + "." + this.iCodes.group(5);
            } else if (log.isDebugEnabled()) {
                log.debug("valid name doesn't normalize: {} hMatch: {} hCount: {}", new Object[]{systemName, hMatch, hCount});
            }
        }
        return nName;
    }

    public String houseCodeFromSystemName(String systemName) {
        String hCode = "";
        if (this.aCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.aCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.hCodes.reset(systemName).matches() && this.hCodes.groupCount() == 2) {
            try {
                hCode = this.hCodes.group(1);
            }
            catch (Exception e) {
                log.error("illegal character in house code field system name: {}", (Object)systemName);
                return "";
            }
        }
        return hCode;
    }

    public String deviceCodeFromSystemName(String systemName) {
        Object dCode = "";
        if (this.aCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.aCodes.group(2).charAt(0)) == Manager.NameValidity.VALID) {
            if (this.hCodes.reset(systemName).matches()) {
                if (this.hCodes.groupCount() == 2) {
                    try {
                        dCode = this.hCodes.group(2);
                    }
                    catch (Exception e) {
                        log.error("illegal character in number field system name: {}", (Object)systemName);
                        return "";
                    }
                }
            } else if (this.iCodes.reset(systemName).matches()) {
                dCode = this.iCodes.group(3) + this.iCodes.group(4) + this.iCodes.group(5);
            } else {
                log.error("illegal insteon address: {}", (Object)systemName);
                return "";
            }
        }
        return dCode;
    }

    public int x10HouseCodeAsValueFromSystemName(String systemName) {
        int hCode = -1;
        if (this.aCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.aCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.hCodes.reset(systemName).matches() && this.hCodes.groupCount() == 4) {
            try {
                hCode = this.hCodes.group(3).charAt(0) - 64;
            }
            catch (Exception e) {
                log.error("illegal character in number field system name: {}", (Object)systemName);
                return -1;
            }
        }
        return hCode;
    }

    public int x10DeviceCodeAsValueFromSystemName(String systemName) {
        int dCode = -1;
        if (this.aCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.aCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.hCodes.reset(systemName).matches() && this.hCodes.groupCount() == 4) {
            try {
                dCode = Integer.parseInt(this.hCodes.group(4));
            }
            catch (NumberFormatException e) {
                log.error("illegal character in number field system name: {}", (Object)systemName);
                return -1;
            }
        }
        return dCode;
    }

    public int insteonIdHighCodeAsValueFromSystemName(String systemName) {
        int dCode = -1;
        if (this.iCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.iCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.iCodes.groupCount() == 5) {
            try {
                dCode = Integer.parseInt(this.iCodes.group(3), 16);
            }
            catch (NumberFormatException e) {
                log.error("illegal character in high id system name: {}", (Object)systemName);
                return -1;
            }
        }
        return dCode;
    }

    public int insteonIdMiddleCodeAsValueFromSystemName(String systemName) {
        int dCode = -1;
        if (this.iCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.iCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.iCodes.groupCount() == 5) {
            try {
                dCode = Integer.parseInt(this.iCodes.group(4), 16);
            }
            catch (NumberFormatException e) {
                log.error("illegal character in high id system name: {}", (Object)systemName);
                return -1;
            }
        }
        return dCode;
    }

    public int insteonIdLowCodeAsValueFromSystemName(String systemName) {
        int dCode = -1;
        if (this.iCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.iCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.iCodes.groupCount() == 5) {
            try {
                dCode = Integer.parseInt(this.iCodes.group(5), 16);
            }
            catch (NumberFormatException e) {
                log.error("illegal character in high id system name: {}", (Object)systemName);
                return -1;
            }
        }
        return dCode;
    }

    public int dmxUnitIdCodeAsValueFromSystemName(String systemName) {
        int dCode = -1;
        if (this.dCodes.reset(systemName).matches() && this.validSystemNameFormat(systemName, this.dCodes.group(2).charAt(0)) == Manager.NameValidity.VALID && this.dCodes.groupCount() == 3) {
            try {
                dCode = Integer.parseInt(this.dCodes.group(3));
            }
            catch (NumberFormatException e) {
                log.error("illegal character in dmx unit id system name: {}", (Object)systemName);
                return -1;
            }
        }
        return dCode;
    }
}

