/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.powerline.Bundle;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSensor;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.managers.AbstractSensorManager;

public abstract class SerialSensorManager
extends AbstractSensorManager
implements SerialListener {
    private SerialTrafficController tc = null;

    public SerialSensorManager(SerialTrafficController tc) {
        super(tc.getAdapterMemo());
        this.tc = tc;
        tc.addSerialListener(this);
    }

    @Override
    @Nonnull
    public SerialSystemConnectionMemo getMemo() {
        return (SerialSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = this.tc.getAdapterMemo().getSerialAddress().normalizeSystemName(systemName);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Powerline Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("Powerline Sensor with this name already exists - " + systemName);
        }
        s = userName == null ? new SerialSensor(sName, this.tc) : new SerialSensor(sName, this.tc, userName);
        return s;
    }

    @Override
    public void message(SerialMessage r) {
    }

    @Override
    public abstract void reply(SerialReply var1);

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getNextValidSystemName(@Nonnull NamedBean currentBean) throws JmriException {
        throw new JmriException("getNextValidSystemName should not have been called");
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.tc.getAdapterMemo().getSerialAddress().validateSystemNameFormat(name, this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.tc.getAdapterMemo().getSerialAddress().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

