/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.powerline.InsteonSequence;
import jmri.jmrix.powerline.SerialInterface;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSensorManager;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerialTrafficController
extends AbstractMRTrafficController
implements SerialInterface {
    protected boolean logDebug = log.isDebugEnabled();
    SerialSensorManager mSensorManager = null;
    protected SerialSystemConnectionMemo memo = null;
    SerialTrafficController self = null;
    boolean sendInterlock = false;
    boolean expectLength = false;
    boolean countingBytes = false;
    int remainingBytes = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialTrafficController.class);

    public SerialTrafficController() {
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    public void sendX10Sequence(X10Sequence s, SerialListener l) {
    }

    public void sendInsteonSequence(InsteonSequence s, SerialListener l) {
    }

    public boolean sendDmxSequence(int unitid, byte newStep) {
        return false;
    }

    public int getNumberOfIntensitySteps() {
        return 0;
    }

    public SerialMessage getSerialMessage(int length) {
        return null;
    }

    @Override
    public synchronized void addSerialListener(SerialListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSerialListener(SerialListener l) {
        this.removeListener(l);
    }

    @Override
    protected int enterProgModeDelayTime() {
        return 1000;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SerialListener)client).message((SerialMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((SerialListener)client).reply((SerialReply)r);
    }

    public void setSensorManager(SerialSensorManager m) {
        this.mSensorManager = m;
    }

    public SerialSensorManager getSensorManager() {
        return this.mSensorManager;
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendSerialMessage(SerialMessage m, SerialListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        this.sendInterlock = ((SerialMessage)m).getInterlocked();
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    public void setAdapterMemo(SerialSystemConnectionMemo adaptermemo) {
        this.memo = adaptermemo;
    }

    public SerialSystemConnectionMemo getAdapterMemo() {
        return this.memo;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return true;
    }

    @Override
    protected AbstractMRReply newReply() {
        return null;
    }
}

