/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.powerline.Bundle;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.SerialTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnoutManager
extends AbstractTurnoutManager {
    private SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnoutManager.class);

    public SerialTurnoutManager(SerialTrafficController tc) {
        super(tc.getAdapterMemo());
        this.tc = tc;
    }

    @Override
    @Nonnull
    public SerialSystemConnectionMemo getMemo() {
        return (SerialSystemConnectionMemo)this.memo;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getNextValidSystemName(@Nonnull NamedBean currentBean) throws JmriException {
        throw new JmriException("getNextValidSystemName should not have been called");
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = this.tc.getAdapterMemo().getSerialAddress().normalizeSystemName(systemName);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create Turnout System Name from " + systemName);
        }
        Turnout t = (Turnout)this.getBySystemName(sName);
        if (t != null) {
            return t;
        }
        t = new SerialTurnout(sName, this.tc, userName);
        if (!this.tc.getAdapterMemo().getSerialAddress().validSystemNameConfig(sName, 'T')) {
            log.warn("Turnout '{}' refers to an undefined Serial Node.", (Object)sName);
        }
        return t;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.tc.getAdapterMemo().getSerialAddress().validateSystemNameFormat(name, this.typeLetter(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.tc.getAdapterMemo().getSerialAddress().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

