/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline;

import jmri.jmrix.powerline.SerialLight;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialX10Light
extends SerialLight {
    protected int lastOutputStep = -1;
    protected int maxDimStep = 0;
    SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SerialX10Light.class);

    public SerialX10Light(String systemName, SerialTrafficController tc) {
        super(systemName, tc);
        this.tc = tc;
        this.maxDimStep = tc.getNumberOfIntensitySteps();
    }

    public SerialX10Light(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, tc, userName);
        this.tc = tc;
        this.maxDimStep = tc.getNumberOfIntensitySteps();
    }

    @Override
    protected void initIntensity(double intensity) {
        if (log.isDebugEnabled()) {
            log.debug("initIntensity({})", (Object)intensity);
        }
        this.maxDimStep = this.tc.getNumberOfIntensitySteps();
        if (intensity <= 0.5) {
            X10Sequence out3 = new X10Sequence();
            out3.addAddress(this.housecode, this.devicecode);
            out3.addFunction(this.housecode, 3, 0);
            this.tc.sendX10Sequence(out3, null);
            X10Sequence out2 = new X10Sequence();
            out2.addAddress(this.housecode, this.devicecode);
            out2.addFunction(this.housecode, 4, this.maxDimStep);
            this.tc.sendX10Sequence(out2, null);
            this.lastOutputStep = 0;
            if (log.isDebugEnabled()) {
                log.debug("initIntensity: sent dim reset");
            }
        } else {
            X10Sequence out3 = new X10Sequence();
            out3.addAddress(this.housecode, this.devicecode);
            out3.addFunction(this.housecode, 2, 0);
            this.tc.sendX10Sequence(out3, null);
            X10Sequence out2 = new X10Sequence();
            out2.addAddress(this.housecode, this.devicecode);
            out2.addFunction(this.housecode, 5, this.maxDimStep);
            this.tc.sendX10Sequence(out2, null);
            this.lastOutputStep = this.maxDimStep;
            if (log.isDebugEnabled()) {
                log.debug("initIntensity: sent bright reset");
            }
        }
    }

    @Override
    protected void sendIntensity(double intensity) {
        int newStep;
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) lastOutputStep: {} maxDimStep: {}", new Object[]{intensity, this.lastOutputStep, this.maxDimStep});
        }
        if ((newStep = (int)Math.round(intensity * (double)this.maxDimStep)) < 0 || newStep > this.maxDimStep) {
            log.error("newStep wrong: {} intensity: {}", (Object)newStep, (Object)intensity);
        }
        if (newStep == 0) {
            if (log.isDebugEnabled()) {
                log.debug("intensity {} within current step, return", (Object)intensity);
            }
            return;
        }
        X10Sequence out = new X10Sequence();
        out.addExtData(this.housecode, this.devicecode, 49, newStep);
        this.tc.sendX10Sequence(out, null);
        this.lastOutputStep = newStep;
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) house {} device {} newStep: {}", new Object[]{intensity, X10Sequence.houseValueToText(this.housecode), this.devicecode, newStep});
        }
    }

    @Override
    protected int getNumberOfSteps() {
        return this.tc.getNumberOfIntensitySteps();
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        double newDim;
        int function;
        if (log.isDebugEnabled()) {
            log.debug("sendOnOff({}) Current: {}", (Object)newState, (Object)this.mState);
        }
        if (newState == 2) {
            function = 2;
            newDim = 1.0;
        } else if (newState == 4) {
            function = 3;
            newDim = 0.0;
        } else {
            log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            return;
        }
        log.debug("set state {} house {} device {}", new Object[]{newState, this.housecode, this.devicecode});
        X10Sequence out = new X10Sequence();
        out.addAddress(this.housecode, this.devicecode);
        out.addFunction(this.housecode, function, 0);
        this.tc.sendX10Sequence(out, null);
        if (log.isDebugEnabled()) {
            log.debug("sendOnOff({})  house {} device {} funct: {}", new Object[]{newDim, X10Sequence.houseValueToText(this.housecode), this.devicecode, function});
        }
    }
}

