/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cm11;

import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSensorManager;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificSensorManager
extends SerialSensorManager {
    SerialTrafficController tc = null;
    private String newHouseCode = null;
    private int newCmdCode = -1;
    private int newAddrCode = -1;
    private static final Logger log = LoggerFactory.getLogger(SpecificSensorManager.class);

    public SpecificSensorManager(SerialTrafficController tc) {
        super(tc);
        this.tc = tc;
    }

    @Override
    public synchronized void reply(SerialReply r) {
        this.processForPollReq(r);
    }

    private void processForPollReq(SerialReply l) {
        if ((l.getElement(0) & 0xFF) == 90) {
            int last = (l.getElement(1) & 0xFF) + 1;
            int bits = l.getElement(2) & 0xFF;
            Sensor sensor = null;
            for (int i = 3; i <= last; ++i) {
                int dat = l.getElement(i) & 0xFF;
                if ((bits & 1) != 0) {
                    this.newHouseCode = X10Sequence.houseValueToText(X10Sequence.decode(dat >> 4 & 0xF));
                    this.newCmdCode = dat & 0xF;
                    if (this.newHouseCode != null && (this.newCmdCode == 6 || this.newCmdCode == 0 || this.newCmdCode == 1)) {
                        this.getNamedBeanSet().forEach(sensorInSet -> {
                            String sName = sensorInSet.getSystemName();
                            if (this.newHouseCode.compareTo(this.tc.getAdapterMemo().getSerialAddress().houseCodeFromSystemName(sName)) == 0) {
                                try {
                                    if (this.newCmdCode == 6 || this.newCmdCode == 0) {
                                        sensorInSet.setKnownState(4);
                                    } else {
                                        sensorInSet.setKnownState(2);
                                    }
                                }
                                catch (JmriException e) {
                                    if (this.newCmdCode == 6 || this.newCmdCode == 0) {
                                        log.error("Exception setting {} sensor INACTIVE", (Object)sName, (Object)e);
                                    }
                                    log.error("Exception setting {} sensor ACTIVE", (Object)sName, (Object)e);
                                }
                            }
                        });
                    } else if (this.newAddrCode > 0) {
                        String sysName = this.getSystemPrefix() + "S" + this.newHouseCode + this.newAddrCode;
                        try {
                            sensor = this.provideSensor(sysName);
                        }
                        catch (IllegalArgumentException iae) {
                            log.debug("Attempt access sensor {} failed", (Object)sysName);
                            throw iae;
                        }
                        if (this.newCmdCode == 2 || this.newCmdCode == 5 || this.newCmdCode == 13) {
                            try {
                                sensor.setKnownState(2);
                            }
                            catch (JmriException e) {
                                log.error("Exception setting {} sensor ACTIVE", (Object)sysName, (Object)e);
                            }
                        }
                        if (this.newCmdCode == 3 || this.newCmdCode == 4 || this.newCmdCode == 14) {
                            try {
                                sensor.setKnownState(4);
                            }
                            catch (JmriException e) {
                                log.error("Exception setting {} sensor INACTIVE", (Object)sysName, (Object)e);
                            }
                        }
                    }
                    this.newHouseCode = null;
                    this.newCmdCode = -1;
                    this.newAddrCode = -1;
                } else {
                    this.newHouseCode = X10Sequence.houseValueToText(X10Sequence.decode(dat >> 4 & 0xF));
                    this.newAddrCode = X10Sequence.decode(dat & 0xF);
                }
                bits >>= 1;
            }
        }
    }
}

