/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.dmx512;

import jmri.jmrix.powerline.SerialLight;
import jmri.jmrix.powerline.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificDmxLight
extends SerialLight {
    SerialTrafficController tc = null;
    protected int maxDimStep = 0;
    private static final Logger log = LoggerFactory.getLogger(SpecificDmxLight.class);

    public SpecificDmxLight(String systemName, SerialTrafficController tc) {
        super(systemName, tc);
        this.tc = tc;
        this.maxDimStep = tc.getNumberOfIntensitySteps();
    }

    public SpecificDmxLight(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, tc, userName);
        this.tc = tc;
        this.maxDimStep = tc.getNumberOfIntensitySteps();
    }

    @Override
    protected void sendIntensity(double intensity) {
        int newStep;
        if (intensity < this.mMinIntensity || intensity > this.mMaxIntensity) {
            log.debug("correcting out of range intensity: {}", (Object)intensity);
            if (intensity < this.mMinIntensity) {
                intensity = this.mMinIntensity;
            }
            if (intensity > this.mMaxIntensity) {
                intensity = this.mMaxIntensity;
            }
        }
        if (this.mCurrentIntensity < this.mMinIntensity || this.mCurrentIntensity > this.mMaxIntensity) {
            log.debug("correcting out of range current intensity: {}", (Object)this.mCurrentIntensity);
            if (this.mCurrentIntensity < this.mMinIntensity) {
                this.mCurrentIntensity = this.mMinIntensity;
            }
            if (this.mCurrentIntensity > this.mMaxIntensity) {
                this.mCurrentIntensity = this.mMaxIntensity;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) maxDimStep: {}", (Object)intensity, (Object)this.maxDimStep);
        }
        if ((newStep = (int)Math.round(intensity * (double)this.maxDimStep)) < 0 || newStep > this.maxDimStep) {
            log.error("newStep wrong: {} intensity: {} mCurrentIntensity {}", new Object[]{newStep, intensity, this.mCurrentIntensity});
            return;
        }
        this.tc.sendDmxSequence(this.unitid, (byte)newStep);
    }

    @Override
    protected int getNumberOfSteps() {
        return this.tc.getNumberOfIntensitySteps();
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        byte newDim;
        if (log.isDebugEnabled()) {
            log.debug("sendOnOff({}) Current: {}", (Object)newState, (Object)this.mState);
        }
        if (newState == 2) {
            newDim = (byte)this.maxDimStep;
            this.mCurrentIntensity = 1.0;
            this.mTransitionTargetIntensity = 1.0;
        } else if (newState == 4) {
            newDim = 0;
            this.mCurrentIntensity = 0.0;
            this.mTransitionTargetIntensity = 0.0;
        } else {
            log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            return;
        }
        log.debug("set state {} unitid {} value {}", new Object[]{newState, this.unitid, newDim});
        this.tc.sendDmxSequence(this.unitid, newDim);
        if (log.isDebugEnabled()) {
            log.debug("sendOnOff() unit {} state {} value {} ", new Object[]{this.unitid, newState, newDim});
        }
    }
}

