/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.dmx512;

import java.util.Arrays;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.powerline.SerialAddress;
import jmri.jmrix.powerline.SerialPortController;
import jmri.jmrix.powerline.dmx512.Bundle;
import jmri.jmrix.powerline.dmx512.SpecificSystemConnectionMemo;
import jmri.jmrix.powerline.dmx512.SpecificTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificDriverAdapter
extends SerialPortController {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud250000")};
    protected int[] validSpeedValues = new int[]{250000};
    private static final Logger log = LoggerFactory.getLogger(SpecificDriverAdapter.class);

    public SpecificDriverAdapter() {
        super(new SpecificSystemConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log, 2);
        if (this.currentSerialPort == null) {
            log.error("failed to connect DMX512 to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting DMX512 to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        SpecificTrafficController tc = null;
        tc = new SpecificTrafficController(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setSerialAddress(new SerialAddress(this.getSystemConnectionMemo()));
        this.getSystemConnectionMemo().setActiveSerialPort(this.currentSerialPort);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

