/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.dmx512;

import com.fazecast.jSerialComm.SerialPortTimeoutException;
import java.io.IOException;
import jmri.jmrix.SerialPort;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificTrafficController
extends SerialTrafficController {
    private boolean oneTimeLog = true;
    public byte[] dmxArray = new byte[513];
    private int intensitySteps = 255;
    private SerialPort activePort = null;
    private static final Logger log = LoggerFactory.getLogger(SpecificTrafficController.class);

    public SpecificTrafficController(SerialSystemConnectionMemo memo) {
        this.memo = memo;
        this.logDebug = log.isDebugEnabled();
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    public boolean setDmxIntensity(int unitId, byte intensityValue) {
        if (unitId > 0 && unitId <= 512) {
            this.dmxArray[unitId] = intensityValue;
            return true;
        }
        return false;
    }

    @Override
    protected void transmitLoop() {
        if (this.oneTimeLog) {
            this.oneTimeLog = false;
            for (int i = 0; i < this.dmxArray.length; ++i) {
                this.dmxArray[i] = 0;
            }
            this.dmxArray[0] = 0;
            for (int tryLimit = 0; this.activePort == null && tryLimit <= 10; ++tryLimit) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                this.activePort = this.memo.getActiveSerialPort();
                if (this.activePort != null) continue;
                log.info("try {} to get activePort", (Object)tryLimit);
            }
        }
        while (!this.connectionError && !this.threadStopRequest) {
            try {
                if (this.ostream != null) {
                    if (this.activePort != null) {
                        this.activePort.setBreak();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            log.warn("transmitLoop did not expected to be interrupted during break");
                            break;
                        }
                        this.activePort.clearBreak();
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            log.warn("transmitLoop did not expected to be interrupted during clear");
                            break;
                        }
                    }
                    try {
                        this.ostream.write(this.dmxArray);
                    }
                    catch (SerialPortTimeoutException ex) {
                        if (!this.threadStopRequest) {
                            log.warn("DMX512 write operation ended early");
                        }
                        return;
                    }
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                this.connectionError = true;
            }
            catch (IOException | RuntimeException e) {
                this.xmtException = true;
                this.portWarn(e);
            }
        }
    }

    @Override
    public void receiveLoop() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int getNumberOfIntensitySteps() {
        return this.intensitySteps;
    }

    @Override
    public boolean sendDmxSequence(int unitid, byte newStep) {
        boolean didIt = this.setDmxIntensity(unitid, newStep);
        if (!didIt) {
            log.error("Invalid Dmx Message for unit {} value {}", (Object)unitid, (Object)newStep);
        }
        return didIt;
    }
}

