/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.insteon2412s;

import java.util.Arrays;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.powerline.SerialAddress;
import jmri.jmrix.powerline.SerialPortController;
import jmri.jmrix.powerline.insteon2412s.Bundle;
import jmri.jmrix.powerline.insteon2412s.SpecificSystemConnectionMemo;
import jmri.jmrix.powerline.insteon2412s.SpecificTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificDriverAdapter
extends SerialPortController {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("BaudAutomatic")};
    protected int[] validSpeedValues = new int[]{19200};
    private static final Logger log = LoggerFactory.getLogger(SpecificDriverAdapter.class);

    public SpecificDriverAdapter() {
        super(new SpecificSystemConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect Insteon 2412 to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting Insteon 2412 to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        SpecificTrafficController tc = null;
        tc = new SpecificTrafficController(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setSerialAddress(new SerialAddress(this.getSystemConnectionMemo()));
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

