/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.insteon2412s;

import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.X10Sequence;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificMessage
extends SerialMessage {
    boolean interlocked = false;
    int responseLength = -1;
    private static final Logger log = LoggerFactory.getLogger(SpecificMessage.class);

    public SpecificMessage(int l) {
        super(l);
        this.setResponseLength(0);
        this.setBinary(true);
        this.setTimeout(5000);
    }

    public SpecificMessage(String m, int l) {
        super(m, l);
    }

    @Override
    public void setInterlocked(boolean v) {
        this.interlocked = v;
    }

    @Override
    public boolean getInterlocked() {
        return this.interlocked;
    }

    @Override
    public String toMonitorString() {
        int len = this.getNumDataElements();
        StringBuilder text = new StringBuilder();
        if ((this.getElement(0) & 0xFF) != 2) {
            text.append("INVALID HEADER: ").append(String.format("0x%1X", this.getElement(0) & 0xFF));
            text.append(" len: ").append(len);
        } else {
            block0 : switch (this.getElement(1) & 0xFF) {
                case 98: {
                    text.append("Send Cmd ");
                    if (len == 8 || len == 22) {
                        if ((this.getElement(5) & 0x10) == 0) {
                            text.append(" Std");
                        } else if (len == 22) {
                            text.append(" Ext");
                        }
                        switch (this.getElement(5) & 0xE0) {
                            case 0: {
                                text.append(" Direct");
                                break;
                            }
                            case 32: {
                                text.append(" ACK");
                                break;
                            }
                            case 160: {
                                text.append(" NAK");
                                break;
                            }
                            case 192: {
                                text.append(" Group Broadcast");
                                break;
                            }
                            case 64: {
                                text.append(" Group Broadcast Cleanup");
                                break;
                            }
                            case 96: {
                                text.append(" Group Broadcast Cleanup ACK");
                                break;
                            }
                            case 224: {
                                text.append(" Group Broadcast Cleanup NAK");
                                break;
                            }
                            default: {
                                log.warn("Unhandled flag type: {}", (Object)(this.getElement(5) & 0xE0));
                            }
                        }
                        text.append(" message,");
                        text.append(String.format(" %d hops left", this.getElement(5) & 3));
                        text.append(String.format(" , %d max hops", this.getElement(5) & 3));
                        text.append(" addr ").append(String.format("%1$X.%2$X.%3$X", this.getElement(2) & 0xFF, this.getElement(3) & 0xFF, this.getElement(4) & 0xFF));
                        switch (this.getElement(6) & 0xFF) {
                            case 17: {
                                text.append(" ON RAMP ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break block0;
                            }
                            case 18: {
                                text.append(" ON FAST ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break block0;
                            }
                            case 20: {
                                text.append(" OFF FAST ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break block0;
                            }
                            case 19: {
                                text.append(" OFF ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break block0;
                            }
                            case 33: {
                                text.append(" CHG ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break block0;
                            }
                        }
                        text.append(" Unknown cmd: ").append(StringUtil.twoHexFromInt(this.getElement(6) & 0xFF));
                        break;
                    }
                    text.append(" !! Length wrong: ").append(len);
                    break;
                }
                case 99: {
                    text.append("Send Cmd X10 ");
                    if ((this.getElement(3) & 0x80) == 128) {
                        text.append(X10Sequence.formatCommandByte(this.getElement(2) & 0xFF));
                        break;
                    }
                    text.append(X10Sequence.formatAddressByte(this.getElement(2) & 0xFF));
                    break;
                }
                default: {
                    text.append(" Unknown command: ").append(StringUtil.twoHexFromInt(this.getElement(1) & 0xFF));
                    text.append(" len: ").append(len);
                }
            }
        }
        return text + "\n";
    }

    public SpecificMessage(byte[] a, int l) {
        super(a, l);
    }

    @Override
    public void setResponseLength(int l) {
        this.responseLength = l;
    }

    @Override
    public int getResponseLength() {
        return this.responseLength;
    }

    public static SerialMessage getPoll(int addr) {
        return null;
    }

    public static SpecificMessage getX10Address(int housecode, int devicecode) {
        SpecificMessage m = new SpecificMessage(4);
        m.setInterlocked(false);
        m.setElement(0, 2);
        m.setElement(1, 99);
        m.setElement(2, (X10Sequence.encode(housecode) << 4) + X10Sequence.encode(devicecode));
        m.setElement(3, 0);
        return m;
    }

    public static SpecificMessage getX10AddressDim(int housecode, int devicecode, int dimcode) {
        SpecificMessage m = new SpecificMessage(4);
        m.setInterlocked(false);
        m.setElement(0, 2);
        m.setElement(1, 99);
        if (dimcode > 0) {
            m.setElement(2, 4 | (dimcode & 0x1F) << 3);
        } else {
            m.setElement(2, 4);
        }
        m.setElement(3, (X10Sequence.encode(housecode) << 4) + X10Sequence.encode(devicecode));
        m.setElement(3, 128);
        return m;
    }

    public static SpecificMessage getX10FunctionDim(int housecode, int function, int dimcode) {
        SpecificMessage m = new SpecificMessage(2);
        m.setInterlocked(true);
        if (dimcode > 0) {
            m.setElement(0, 6 | (dimcode & 0x1F) << 3);
        } else {
            m.setElement(0, 6);
        }
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + function);
        return m;
    }

    public static SpecificMessage getX10Function(int housecode, int function) {
        SpecificMessage m = new SpecificMessage(4);
        m.setInterlocked(false);
        m.setElement(0, 2);
        m.setElement(1, 99);
        m.setElement(2, (X10Sequence.encode(housecode) << 4) + function);
        m.setElement(3, 128);
        return m;
    }

    public static SpecificMessage getInsteonAddress(int idhighbyte, int idmiddlebyte, int idlowbyte) {
        SpecificMessage m = new SpecificMessage(8);
        m.setInterlocked(false);
        m.setElement(0, 2);
        m.setElement(1, 98);
        m.setElement(2, idhighbyte);
        m.setElement(3, idmiddlebyte);
        m.setElement(4, idlowbyte);
        m.setElement(5, 15);
        m.setElement(6, 17);
        m.setElement(7, 255);
        return m;
    }

    public static SpecificMessage getInsteonFunction(int idhighbyte, int idmiddlebyte, int idlowbyte, int function, int flag, int cmd1, int cmd2) {
        SpecificMessage m = new SpecificMessage(8);
        m.setInterlocked(false);
        m.setElement(0, 2);
        m.setElement(1, 98);
        m.setElement(2, idhighbyte);
        m.setElement(3, idmiddlebyte);
        m.setElement(4, idlowbyte);
        m.setElement(5, flag);
        m.setElement(6, cmd1);
        m.setElement(7, cmd2);
        return m;
    }
}

