/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.insteon2412s;

import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.SerialX10Light;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificX10Light
extends SerialX10Light {
    SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SpecificX10Light.class);

    public SpecificX10Light(String systemName, SerialTrafficController tc) {
        super(systemName, tc);
        this.tc = tc;
        this.maxDimStep = 22;
    }

    public SpecificX10Light(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, tc, userName);
        this.tc = tc;
        this.maxDimStep = 22;
    }

    @Override
    protected void sendIntensity(double intensity) {
        int newStep;
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) lastOutputStep: {} maxDimStep: {}", new Object[]{intensity, this.lastOutputStep, this.maxDimStep});
        }
        if ((newStep = (int)Math.round(intensity * (double)this.maxDimStep)) < 0 || newStep > this.maxDimStep) {
            log.error("newStep wrong: {} intensity: {}", (Object)newStep, (Object)intensity);
        }
        if (newStep == this.lastOutputStep) {
            if (log.isDebugEnabled()) {
                log.debug("intensity {} within current step, return", (Object)intensity);
            }
            return;
        }
        X10Sequence out = new X10Sequence();
        out.addExtData(this.housecode, this.devicecode, 49, newStep);
        this.tc.sendX10Sequence(out, null);
        this.lastOutputStep = newStep;
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) house {} device {} newStep: {}", new Object[]{intensity, X10Sequence.houseValueToText(this.housecode), this.devicecode, newStep});
        }
    }
}

