/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.serialdriver;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.powerline.SerialAddress;
import jmri.jmrix.powerline.SerialPortController;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.cm11.SpecificTrafficController;
import jmri.jmrix.powerline.cp290.SpecificSystemConnectionMemo;
import jmri.jmrix.powerline.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends SerialPortController {
    String[] stdOption1Values = new String[]{"CM11", "CP290", "Insteon 2412S"};
    protected String[] validSpeeds = new String[]{Bundle.getMessage("BaudAutomatic")};
    protected int[] validSpeedValues = new int[]{4800};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new SerialSystemConnectionMemo());
        this.option1Name = "Adapter";
        this.options.put(this.option1Name, new AbstractPortController.Option("Adapter", this.stdOption1Values));
        this.manufacturerName = "Powerline";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect Powerline to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting Powerline to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        String opt1 = this.getOptionState(this.option1Name);
        if (!opt1.equals("CM11")) {
            if (opt1.equals("CP290")) {
                baud = 600;
            } else if (opt1.equals("Insteon 2412S")) {
                baud = 19200;
            }
        }
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void configure() {
        SerialTrafficController tc = null;
        String opt1 = this.getOptionState(this.option1Name);
        if (opt1.equals("CM11")) {
            this.setSystemConnectionMemo(new jmri.jmrix.powerline.cm11.SpecificSystemConnectionMemo());
            tc = new SpecificTrafficController(this.getSystemConnectionMemo());
        } else if (opt1.equals("CP290")) {
            this.setSystemConnectionMemo(new SpecificSystemConnectionMemo());
            tc = new jmri.jmrix.powerline.cp290.SpecificTrafficController(this.getSystemConnectionMemo());
        } else if (opt1.equals("Insteon 2412S")) {
            this.setSystemConnectionMemo(new jmri.jmrix.powerline.insteon2412s.SpecificSystemConnectionMemo());
            tc = new jmri.jmrix.powerline.insteon2412s.SpecificTrafficController(this.getSystemConnectionMemo());
        } else {
            log.warn("protocol option {} defaults to CM11", (Object)opt1);
            this.setSystemConnectionMemo(new jmri.jmrix.powerline.cm11.SpecificSystemConnectionMemo());
            tc = new SpecificTrafficController(this.getSystemConnectionMemo());
        }
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setSerialAddress(new SerialAddress(this.getSystemConnectionMemo()));
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

