/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.simulator;

import jmri.jmrix.powerline.InsteonSequence;
import jmri.jmrix.powerline.SerialLight;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificInsteonLight
extends SerialLight {
    int lastOutputStep = -1;
    int maxDimStep = 255;
    SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SpecificInsteonLight.class);

    public SpecificInsteonLight(String systemName, SerialTrafficController tc) {
        super(systemName, tc);
        this.tc = tc;
    }

    public SpecificInsteonLight(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, tc, userName);
        this.tc = tc;
    }

    @Override
    protected void initIntensity(double intensity) {
        if (log.isDebugEnabled()) {
            log.debug("initIntensity({})", (Object)intensity);
        }
    }

    @Override
    protected void sendIntensity(double intensity) {
        int newStep;
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) lastOutputStep: {} maxDimStep: {}", new Object[]{intensity, this.lastOutputStep, this.maxDimStep});
        }
        if ((newStep = (int)Math.round(intensity * (double)this.maxDimStep)) < 0 || newStep > this.maxDimStep) {
            log.error("newStep wrong: {} intensity: {}", (Object)newStep, (Object)intensity);
        }
        if (newStep == this.lastOutputStep) {
            if (log.isDebugEnabled()) {
                log.debug("intensity {} within current step, return", (Object)intensity);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("function set Intensity {}", (Object)intensity);
        }
        InsteonSequence out = new InsteonSequence();
        out.addFunction(this.idhighbyte, this.idmiddlebyte, this.idlowbyte, 98, 0, 33, newStep);
        this.tc.sendInsteonSequence(out, null);
        if (log.isDebugEnabled()) {
            log.debug("sendIntensity({}) addr {}{}{} newStep {}", new Object[]{intensity, this.idhighbyte, this.idmiddlebyte, this.idlowbyte, newStep});
        }
        this.lastOutputStep = newStep;
    }

    @Override
    protected int getNumberOfSteps() {
        return this.maxDimStep;
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        int command1;
        if (log.isDebugEnabled()) {
            log.debug("start sendOnOff({}) Current: {}", (Object)newState, (Object)this.mState);
        }
        if (newState == 2) {
            command1 = 18;
        } else if (newState == 4) {
            command1 = 20;
        } else {
            log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("set state {} {}", (Object)newState, (Object)this.getSystemName());
        }
        InsteonSequence out = new InsteonSequence();
        out.addFunction(this.idhighbyte, this.idmiddlebyte, this.idlowbyte, 98, 0, command1, 0);
        this.tc.sendInsteonSequence(out, null);
        if (log.isDebugEnabled()) {
            log.debug("end sendOnOff({})  insteon {}.{}.{} cmd1: {}", new Object[]{newState, StringUtil.twoHexFromInt(this.idhighbyte), StringUtil.twoHexFromInt(this.idmiddlebyte), StringUtil.twoHexFromInt(this.idlowbyte), command1});
        }
    }
}

